/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.manager.tableOps.clone;

import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.fate.Repo;
import org.apache.accumulo.core.fate.zookeeper.ServiceLock;
import org.apache.accumulo.manager.Manager;
import org.apache.accumulo.manager.tableOps.ManagerRepo;
import org.apache.accumulo.manager.tableOps.clone.CloneInfo;
import org.apache.accumulo.manager.tableOps.clone.FinishCloneTable;
import org.apache.accumulo.server.ServerContext;
import org.apache.accumulo.server.util.MetadataTableUtil;
import org.slf4j.LoggerFactory;

class CloneMetadata
extends ManagerRepo {
    private static final long serialVersionUID = 1L;
    private CloneInfo cloneInfo;

    public CloneMetadata(CloneInfo cloneInfo) {
        this.cloneInfo = cloneInfo;
    }

    @Override
    public long isReady(long tid, Manager environment) {
        return 0L;
    }

    @Override
    public Repo<Manager> call(long tid, Manager environment) throws Exception {
        LoggerFactory.getLogger(CloneMetadata.class).info(String.format("Cloning %s with tableId %s from srcTableId %s", this.cloneInfo.tableName, this.cloneInfo.tableId, this.cloneInfo.srcTableId));
        MetadataTableUtil.deleteTable((TableId)this.cloneInfo.tableId, (boolean)false, (ServerContext)environment.getContext(), (ServiceLock)environment.getManagerLock());
        MetadataTableUtil.cloneTable((ServerContext)environment.getContext(), (TableId)this.cloneInfo.srcTableId, (TableId)this.cloneInfo.tableId);
        return new FinishCloneTable(this.cloneInfo);
    }

    @Override
    public void undo(long tid, Manager environment) throws Exception {
        MetadataTableUtil.deleteTable((TableId)this.cloneInfo.tableId, (boolean)false, (ServerContext)environment.getContext(), (ServiceLock)environment.getManagerLock());
    }
}

