/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.manager.tableOps.merge;

import org.apache.accumulo.core.data.NamespaceId;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.fate.Repo;
import org.apache.accumulo.manager.Manager;
import org.apache.accumulo.manager.tableOps.ManagerRepo;
import org.apache.accumulo.manager.tableOps.Utils;
import org.apache.accumulo.server.manager.state.MergeInfo;
import org.apache.accumulo.server.manager.state.MergeState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TableRangeOpWait
extends ManagerRepo {
    private static final Logger log = LoggerFactory.getLogger(TableRangeOpWait.class);
    private static final long serialVersionUID = 1L;
    private TableId tableId;
    private NamespaceId namespaceId;

    public TableRangeOpWait(NamespaceId namespaceId, TableId tableId) {
        this.tableId = tableId;
        this.namespaceId = namespaceId;
    }

    @Override
    public long isReady(long tid, Manager env) {
        if (!env.getMergeInfo(this.tableId).getState().equals((Object)MergeState.NONE)) {
            return 50L;
        }
        return 0L;
    }

    @Override
    public Repo<Manager> call(long tid, Manager manager) throws Exception {
        MergeInfo mergeInfo = manager.getMergeInfo(this.tableId);
        log.info("removing merge information " + mergeInfo);
        manager.clearMergeState(this.tableId);
        Utils.unreserveTable(manager, this.tableId, tid, true);
        Utils.unreserveNamespace(manager, this.namespaceId, tid, false);
        return null;
    }
}

