/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.manager.tableOps.create;

import org.apache.accumulo.core.clientImpl.thrift.TableOperation;
import org.apache.accumulo.core.clientImpl.thrift.TableOperationExceptionType;
import org.apache.accumulo.core.clientImpl.thrift.ThriftTableOperationException;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.fate.Repo;
import org.apache.accumulo.manager.Manager;
import org.apache.accumulo.manager.tableOps.ManagerRepo;
import org.apache.accumulo.manager.tableOps.TableInfo;
import org.apache.accumulo.manager.tableOps.Utils;
import org.apache.accumulo.manager.tableOps.create.ChooseDir;
import org.apache.accumulo.server.ServerContext;
import org.apache.accumulo.server.conf.store.PropStoreKey;
import org.apache.accumulo.server.conf.store.TablePropKey;
import org.apache.accumulo.server.util.PropUtil;

class PopulateZookeeper
extends ManagerRepo {
    private static final long serialVersionUID = 1L;
    private final TableInfo tableInfo;

    PopulateZookeeper(TableInfo ti) {
        this.tableInfo = ti;
    }

    @Override
    public long isReady(long tid, Manager environment) throws Exception {
        return Utils.reserveTable(environment, this.tableInfo.getTableId(), tid, true, false, TableOperation.CREATE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Repo<Manager> call(long tid, Manager manager) throws Exception {
        Utils.getTableNameLock().lock();
        try {
            Utils.checkTableDoesNotExist(manager.getContext(), this.tableInfo.getTableName(), this.tableInfo.getTableId(), TableOperation.CREATE);
            manager.getTableManager().addTable(this.tableInfo.getTableId(), this.tableInfo.getNamespaceId(), this.tableInfo.getTableName());
            try {
                PropUtil.setProperties((ServerContext)manager.getContext(), (PropStoreKey)TablePropKey.of((ServerContext)manager.getContext(), (TableId)this.tableInfo.getTableId()), this.tableInfo.props);
            }
            catch (IllegalStateException ex) {
                throw new ThriftTableOperationException(null, this.tableInfo.getTableName(), TableOperation.CREATE, TableOperationExceptionType.OTHER, "Property or value not valid for create " + this.tableInfo.getTableName() + " in " + this.tableInfo.props);
            }
            manager.getContext().clearTableListCache();
            ChooseDir chooseDir = new ChooseDir(this.tableInfo);
            return chooseDir;
        }
        finally {
            Utils.getTableNameLock().unlock();
        }
    }

    @Override
    public void undo(long tid, Manager manager) throws Exception {
        manager.getTableManager().removeTable(this.tableInfo.getTableId());
        Utils.unreserveTable(manager, this.tableInfo.getTableId(), tid, true);
        manager.getContext().clearTableListCache();
    }
}

