/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.master;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.zookeeper.ZooUtil;
import org.apache.accumulo.fate.zookeeper.ZooUtil;
import org.apache.accumulo.master.Master;
import org.apache.accumulo.server.zookeeper.ZooReaderWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MasterTime
extends TimerTask {
    private static final Logger log = LoggerFactory.getLogger(MasterTime.class);
    private final String zPath;
    private final ZooReaderWriter zk;
    private final Master master;
    private final Timer timer;
    private long skewAmount;

    public MasterTime(Master master) throws IOException {
        this.zPath = ZooUtil.getRoot((Instance)master.getInstance()) + "/masters/tick";
        this.zk = ZooReaderWriter.getInstance();
        this.master = master;
        try {
            this.zk.putPersistentData(this.zPath, "0".getBytes(StandardCharsets.UTF_8), ZooUtil.NodeExistsPolicy.SKIP);
            this.skewAmount = Long.parseLong(new String(this.zk.getData(this.zPath, null), StandardCharsets.UTF_8)) - System.nanoTime();
        }
        catch (Exception ex) {
            throw new IOException("Error updating master time", ex);
        }
        this.timer = new Timer();
        this.timer.schedule((TimerTask)this, 0L, TimeUnit.MILLISECONDS.convert(10L, TimeUnit.SECONDS));
    }

    public synchronized long getTime() {
        return TimeUnit.MILLISECONDS.convert(System.nanoTime() + this.skewAmount, TimeUnit.NANOSECONDS);
    }

    public void shutdown() {
        this.timer.cancel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        switch (this.master.getMasterState()) {
            case INITIAL: 
            case STOP: {
                try {
                    long zkTime = Long.parseLong(new String(this.zk.getData(this.zPath, null), StandardCharsets.UTF_8));
                    MasterTime masterTime = this;
                    synchronized (masterTime) {
                        this.skewAmount = zkTime - System.nanoTime();
                        return;
                    }
                }
                catch (Exception ex) {
                    if (!log.isDebugEnabled()) return;
                    log.debug("Failed to retrieve master tick time", (Throwable)ex);
                }
                return;
            }
            case HAVE_LOCK: 
            case SAFE_MODE: 
            case NORMAL: 
            case UNLOAD_METADATA_TABLETS: 
            case UNLOAD_ROOT_TABLET: {
                try {
                    this.zk.putPersistentData(this.zPath, Long.toString(System.nanoTime() + this.skewAmount).getBytes(StandardCharsets.UTF_8), ZooUtil.NodeExistsPolicy.OVERWRITE);
                    return;
                }
                catch (Exception ex) {
                    if (!log.isDebugEnabled()) return;
                    log.debug("Failed to update master tick time", (Throwable)ex);
                }
            }
        }
    }
}

