/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.master.tableOps;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Map;
import org.apache.accumulo.core.client.BatchScanner;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.ScannerBase;
import org.apache.accumulo.core.client.impl.Tables;
import org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.KeyExtent;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.user.GrepIterator;
import org.apache.accumulo.core.metadata.schema.MetadataSchema;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.security.Credentials;
import org.apache.accumulo.fate.Repo;
import org.apache.accumulo.master.Master;
import org.apache.accumulo.master.tableOps.MasterRepo;
import org.apache.accumulo.master.tableOps.Utils;
import org.apache.accumulo.server.ServerConstants;
import org.apache.accumulo.server.fs.VolumeManager;
import org.apache.accumulo.server.master.state.CurrentState;
import org.apache.accumulo.server.master.state.MetaDataTableScanner;
import org.apache.accumulo.server.master.state.TabletLocationState;
import org.apache.accumulo.server.master.state.TabletState;
import org.apache.accumulo.server.problems.ProblemReports;
import org.apache.accumulo.server.security.AuditedSecurityOperation;
import org.apache.accumulo.server.security.SystemCredentials;
import org.apache.accumulo.server.tables.TableManager;
import org.apache.accumulo.server.util.MetadataTableUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.log4j.Logger;

class CleanUp
extends MasterRepo {
    private static final Logger log = Logger.getLogger(CleanUp.class);
    private static final long serialVersionUID = 1L;
    private String tableId;
    private String namespaceId;
    private long creationTime;

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (System.currentTimeMillis() < this.creationTime) {
            this.creationTime = System.currentTimeMillis();
        }
    }

    public CleanUp(String tableId, String namespaceId) {
        this.tableId = tableId;
        this.namespaceId = namespaceId;
        this.creationTime = System.currentTimeMillis();
    }

    @Override
    public long isReady(long tid, Master master) throws Exception {
        if (!master.hasCycled(this.creationTime)) {
            return 50L;
        }
        boolean done = true;
        Range tableRange = new KeyExtent(new Text(this.tableId), null, null).toMetadataRange();
        Scanner scanner = master.getConnector().createScanner("accumulo.metadata", Authorizations.EMPTY);
        MetaDataTableScanner.configureScanner((ScannerBase)scanner, (CurrentState)master);
        scanner.setRange(tableRange);
        KeyExtent prevExtent = null;
        for (Map.Entry entry : scanner) {
            TabletLocationState locationState = MetaDataTableScanner.createTabletLocationState((Key)((Key)entry.getKey()), (Value)((Value)entry.getValue()));
            if (!locationState.extent.isPreviousExtent(prevExtent)) {
                log.info((Object)("Still waiting for table to be deleted: " + this.tableId + " saw inconsistency " + prevExtent + " " + locationState.extent));
                done = false;
                break;
            }
            prevExtent = locationState.extent;
            TabletState state = locationState.getState(master.onlineTabletServers());
            if (!state.equals((Object)TabletState.ASSIGNED) && !state.equals((Object)TabletState.HOSTED)) continue;
            log.debug((Object)("Still waiting for table to be deleted: " + this.tableId + " locationState: " + locationState));
            done = false;
            break;
        }
        if (!done) {
            return 50L;
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Repo<Master> call(long tid, Master master) throws Exception {
        master.clearMigrations(this.tableId);
        int refCount = 0;
        try {
            Connector conn = master.getConnector();
            BatchScanner bs = conn.createBatchScanner("accumulo.metadata", Authorizations.EMPTY, 8);
            try {
                Range allTables = MetadataSchema.TabletsSection.getRange();
                Range tableRange = MetadataSchema.TabletsSection.getRange((String)this.tableId);
                Range beforeTable = new Range(allTables.getStartKey(), true, tableRange.getStartKey(), false);
                Range afterTable = new Range(tableRange.getEndKey(), false, allTables.getEndKey(), true);
                bs.setRanges(Arrays.asList(beforeTable, afterTable));
                bs.fetchColumnFamily(MetadataSchema.TabletsSection.DataFileColumnFamily.NAME);
                IteratorSetting cfg = new IteratorSetting(40, "grep", GrepIterator.class);
                GrepIterator.setTerm((IteratorSetting)cfg, (String)("/" + this.tableId + "/"));
                bs.addScanIterator(cfg);
                for (Map.Entry entry : bs) {
                    if (!((Key)entry.getKey()).getColumnQualifier().toString().contains("/" + this.tableId + "/")) continue;
                    ++refCount;
                }
            }
            finally {
                bs.close();
            }
        }
        catch (Exception e) {
            refCount = -1;
            log.error((Object)("Failed to scan accumulo.metadata looking for references to deleted table " + this.tableId), (Throwable)e);
        }
        try {
            MetadataTableUtil.deleteTable((String)this.tableId, (refCount != 0 ? 1 : 0) != 0, (Credentials)SystemCredentials.get(), null);
        }
        catch (Exception e) {
            log.error((Object)("error deleting " + this.tableId + " from metadata table"), (Throwable)e);
        }
        try {
            ProblemReports.getInstance().deleteProblemReports(this.tableId);
        }
        catch (Exception e) {
            log.error((Object)("Failed to delete problem reports for table " + this.tableId), (Throwable)e);
        }
        if (refCount == 0) {
            try {
                VolumeManager fs = master.getFileSystem();
                for (String dir : ServerConstants.getTablesDirs()) {
                    fs.deleteRecursively(new Path(dir, this.tableId));
                }
            }
            catch (IOException e) {
                log.error((Object)"Unable to remove deleted table directory", (Throwable)e);
            }
            catch (IllegalArgumentException exception) {
                if (exception.getCause() instanceof UnknownHostException) {
                    log.error((Object)"Unable to remove deleted table directory", (Throwable)exception);
                }
                throw exception;
            }
        }
        try {
            TableManager.getInstance().removeTable(this.tableId);
            Tables.clearCache((Instance)master.getInstance());
        }
        catch (Exception e) {
            log.error((Object)"Failed to find table id in zookeeper", (Throwable)e);
        }
        try {
            AuditedSecurityOperation.getInstance().deleteTable(SystemCredentials.get().toThrift(master.getInstance()), this.tableId, this.namespaceId);
        }
        catch (ThriftSecurityException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        Utils.unreserveTable(this.tableId, tid, true);
        Utils.unreserveNamespace(this.namespaceId, tid, false);
        Logger.getLogger(CleanUp.class).debug((Object)("Deleted table " + this.tableId));
        return null;
    }

    @Override
    public void undo(long tid, Master environment) throws Exception {
    }
}

