/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.master.tableOps;

import java.math.BigInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.accumulo.core.Constants;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.impl.Namespaces;
import org.apache.accumulo.core.client.impl.Tables;
import org.apache.accumulo.core.client.impl.thrift.TableOperation;
import org.apache.accumulo.core.client.impl.thrift.TableOperationExceptionType;
import org.apache.accumulo.core.client.impl.thrift.ThriftTableOperationException;
import org.apache.accumulo.core.zookeeper.ZooUtil;
import org.apache.accumulo.fate.zookeeper.DistributedReadWriteLock;
import org.apache.accumulo.fate.zookeeper.IZooReaderWriter;
import org.apache.accumulo.fate.zookeeper.ZooReservation;
import org.apache.accumulo.master.tableOps.CreateTable;
import org.apache.accumulo.server.client.HdfsZooInstance;
import org.apache.accumulo.server.zookeeper.ZooQueueLock;
import org.apache.accumulo.server.zookeeper.ZooReaderWriter;
import org.apache.commons.codec.binary.Base64;
import org.apache.log4j.Logger;
import org.apache.zookeeper.KeeperException;

public class Utils {
    private static final byte[] ZERO_BYTE = new byte[]{48};
    static final Lock tableNameLock = new ReentrantLock();
    static final Lock idLock = new ReentrantLock();
    private static final Logger log = Logger.getLogger(Utils.class);

    static void checkTableDoesNotExist(Instance instance, String tableName, String tableId, TableOperation operation) throws ThriftTableOperationException {
        String id = (String)Tables.getNameToIdMap((Instance)instance).get(tableName);
        if (id != null && !id.equals(tableId)) {
            throw new ThriftTableOperationException(null, tableName, operation, TableOperationExceptionType.EXISTS, null);
        }
    }

    static String getNextTableId(String tableName, Instance instance) throws ThriftTableOperationException {
        String tableId = null;
        try {
            IZooReaderWriter zoo = ZooReaderWriter.getRetryingInstance();
            String ntp = ZooUtil.getRoot((Instance)instance) + "/tables";
            byte[] nid = zoo.mutate(ntp, ZERO_BYTE, ZooUtil.PUBLIC, new IZooReaderWriter.Mutator(){

                public byte[] mutate(byte[] currentValue) throws Exception {
                    BigInteger nextId = new BigInteger(new String(currentValue, Constants.UTF8), 36);
                    nextId = nextId.add(BigInteger.ONE);
                    return nextId.toString(36).getBytes(Constants.UTF8);
                }
            });
            return new String(nid, Constants.UTF8);
        }
        catch (Exception e1) {
            Logger.getLogger(CreateTable.class).error((Object)("Failed to assign tableId to " + tableName), (Throwable)e1);
            throw new ThriftTableOperationException(tableId, tableName, TableOperation.CREATE, TableOperationExceptionType.OTHER, e1.getMessage());
        }
    }

    public static long reserveTable(String tableId, long tid, boolean writeLock, boolean tableMustExist, TableOperation op) throws Exception {
        if (Utils.getLock(tableId, tid, writeLock).tryLock()) {
            if (tableMustExist) {
                Instance instance = HdfsZooInstance.getInstance();
                IZooReaderWriter zk = ZooReaderWriter.getRetryingInstance();
                if (!zk.exists(ZooUtil.getRoot((Instance)instance) + "/tables" + "/" + tableId)) {
                    throw new ThriftTableOperationException(tableId, "", op, TableOperationExceptionType.NOTFOUND, "Table does not exist");
                }
            }
            log.info((Object)("table " + tableId + " (" + Long.toHexString(tid) + ") locked for " + (writeLock ? "write" : "read") + " operation: " + op));
            return 0L;
        }
        return 100L;
    }

    public static void unreserveTable(String tableId, long tid, boolean writeLock) throws Exception {
        Utils.getLock(tableId, tid, writeLock).unlock();
        log.info((Object)("table " + tableId + " (" + Long.toHexString(tid) + ") unlocked for " + (writeLock ? "write" : "read")));
    }

    public static void unreserveNamespace(String namespaceId, long id, boolean writeLock) throws Exception {
        Utils.getLock(namespaceId, id, writeLock).unlock();
        log.info((Object)("namespace " + namespaceId + " (" + Long.toHexString(id) + ") unlocked for " + (writeLock ? "write" : "read")));
    }

    public static long reserveNamespace(String namespaceId, long id, boolean writeLock, boolean mustExist, TableOperation op) throws Exception {
        if (Utils.getLock(namespaceId, id, writeLock).tryLock()) {
            if (mustExist) {
                Instance instance = HdfsZooInstance.getInstance();
                IZooReaderWriter zk = ZooReaderWriter.getRetryingInstance();
                if (!zk.exists(ZooUtil.getRoot((Instance)instance) + "/namespaces" + "/" + namespaceId)) {
                    throw new ThriftTableOperationException(namespaceId, "", op, TableOperationExceptionType.NAMESPACE_NOTFOUND, "Namespace does not exist");
                }
            }
            log.info((Object)("namespace " + namespaceId + " (" + Long.toHexString(id) + ") locked for " + (writeLock ? "write" : "read") + " operation: " + op));
            return 0L;
        }
        return 100L;
    }

    public static long reserveHdfsDirectory(String directory, long tid) throws KeeperException, InterruptedException {
        Instance instance = HdfsZooInstance.getInstance();
        String resvPath = ZooUtil.getRoot((Instance)instance) + "/hdfs_reservations" + "/" + new String(Base64.encodeBase64((byte[])directory.getBytes(Constants.UTF8)), Constants.UTF8);
        IZooReaderWriter zk = ZooReaderWriter.getRetryingInstance();
        if (ZooReservation.attempt((IZooReaderWriter)zk, (String)resvPath, (String)String.format("%016x", tid), (String)"")) {
            return 0L;
        }
        return 50L;
    }

    public static void unreserveHdfsDirectory(String directory, long tid) throws KeeperException, InterruptedException {
        Instance instance = HdfsZooInstance.getInstance();
        String resvPath = ZooUtil.getRoot((Instance)instance) + "/hdfs_reservations" + "/" + new String(Base64.encodeBase64((byte[])directory.getBytes(Constants.UTF8)), Constants.UTF8);
        ZooReservation.release((IZooReaderWriter)ZooReaderWriter.getRetryingInstance(), (String)resvPath, (String)String.format("%016x", tid));
    }

    private static Lock getLock(String tableId, long tid, boolean writeLock) throws Exception {
        byte[] lockData = String.format("%016x", tid).getBytes(Constants.UTF8);
        ZooQueueLock qlock = new ZooQueueLock(ZooUtil.getRoot((Instance)HdfsZooInstance.getInstance()) + "/table_locks" + "/" + tableId, false);
        Lock lock = DistributedReadWriteLock.recoverLock((DistributedReadWriteLock.QueueLock)qlock, (byte[])lockData);
        if (lock == null) {
            DistributedReadWriteLock locker = new DistributedReadWriteLock((DistributedReadWriteLock.QueueLock)qlock, lockData);
            lock = writeLock ? locker.writeLock() : locker.readLock();
        }
        return lock;
    }

    public static Lock getReadLock(String tableId, long tid) throws Exception {
        return Utils.getLock(tableId, tid, false);
    }

    static void checkNamespaceDoesNotExist(Instance instance, String namespace, String namespaceId, TableOperation operation) throws ThriftTableOperationException {
        String n = (String)Namespaces.getNameToIdMap((Instance)instance).get(namespace);
        if (n != null && !n.equals(namespaceId)) {
            throw new ThriftTableOperationException(null, namespace, operation, TableOperationExceptionType.NAMESPACE_EXISTS, null);
        }
    }
}

