/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.master.util;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import java.util.ArrayList;
import java.util.List;
import org.apache.accumulo.core.cli.Help;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.zookeeper.ZooUtil;
import org.apache.accumulo.fate.AdminUtil;
import org.apache.accumulo.fate.ReadOnlyStore;
import org.apache.accumulo.fate.ReadOnlyTStore;
import org.apache.accumulo.fate.TStore;
import org.apache.accumulo.fate.ZooStore;
import org.apache.accumulo.fate.zookeeper.IZooReaderWriter;
import org.apache.accumulo.server.client.HdfsZooInstance;
import org.apache.accumulo.server.zookeeper.ZooReaderWriter;

public class FateAdmin {
    public static void main(String[] args) throws Exception {
        Help opts = new Help();
        JCommander jc = new JCommander((Object)opts);
        jc.setProgramName(FateAdmin.class.getName());
        jc.addCommand("fail", (Object)new FailOpts());
        jc.addCommand("delete", (Object)new DeleteOpts());
        jc.addCommand("print", (Object)new PrintOpts());
        jc.parse(args);
        if (opts.help || jc.getParsedCommand() == null) {
            jc.usage();
            System.exit(1);
        }
        System.err.printf("This tool has been deprecated%nFATE administration now available within 'accumulo shell'%n$ fate fail <txid>... | delete <txid>... | print [<txid>...]%n%n", new Object[0]);
        AdminUtil admin = new AdminUtil();
        Instance instance = HdfsZooInstance.getInstance();
        String path = ZooUtil.getRoot((Instance)instance) + "/fate";
        String masterPath = ZooUtil.getRoot((Instance)instance) + "/masters/lock";
        IZooReaderWriter zk = ZooReaderWriter.getRetryingInstance();
        ZooStore zs = new ZooStore(path, zk);
        if (jc.getParsedCommand().equals("fail")) {
            if (!admin.prepFail((TStore)zs, zk, masterPath, args[1])) {
                System.exit(1);
            }
        } else if (jc.getParsedCommand().equals("delete")) {
            if (!admin.prepDelete((TStore)zs, zk, masterPath, args[1])) {
                System.exit(1);
            }
            admin.deleteLocks((TStore)zs, zk, ZooUtil.getRoot((Instance)instance) + "/table_locks", args[1]);
        } else if (jc.getParsedCommand().equals("print")) {
            admin.print((ReadOnlyTStore)new ReadOnlyStore((TStore)zs), zk, ZooUtil.getRoot((Instance)instance) + "/table_locks");
        }
    }

    @Parameters(commandDescription="List the existing FATE transactions")
    static class PrintOpts {
        PrintOpts() {
        }
    }

    @Parameters(commandDescription="Delete an existing FATE by transaction id")
    static class DeleteOpts
    extends TxOpts {
        DeleteOpts() {
        }
    }

    @Parameters(commandDescription="Stop an existing FATE by transaction id")
    static class FailOpts
    extends TxOpts {
        FailOpts() {
        }
    }

    static class TxOpts {
        @Parameter(description="<txid>", required=true)
        List<String> args = new ArrayList<String>();

        TxOpts() {
        }
    }
}

