/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.master.tableOps;

import org.apache.accumulo.core.Constants;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.impl.Tables;
import org.apache.accumulo.core.client.impl.thrift.TableOperation;
import org.apache.accumulo.fate.Repo;
import org.apache.accumulo.fate.zookeeper.IZooReaderWriter;
import org.apache.accumulo.master.Master;
import org.apache.accumulo.master.tableOps.FinishCancelCompaction;
import org.apache.accumulo.master.tableOps.MasterRepo;
import org.apache.accumulo.master.tableOps.Utils;
import org.apache.accumulo.server.client.HdfsZooInstance;
import org.apache.accumulo.server.zookeeper.ZooReaderWriter;

public class CancelCompactions
extends MasterRepo {
    private static final long serialVersionUID = 1L;
    private String tableId;
    private String namespaceId;

    public CancelCompactions(String tableId) {
        this.tableId = tableId;
        Instance inst = HdfsZooInstance.getInstance();
        this.namespaceId = Tables.getNamespaceId((Instance)inst, (String)tableId);
    }

    @Override
    public long isReady(long tid, Master environment) throws Exception {
        return Utils.reserveNamespace(this.namespaceId, tid, false, true, TableOperation.COMPACT_CANCEL) + Utils.reserveTable(this.tableId, tid, false, true, TableOperation.COMPACT_CANCEL);
    }

    @Override
    public Repo<Master> call(long tid, Master environment) throws Exception {
        String zCompactID = "/accumulo/" + HdfsZooInstance.getInstance().getInstanceID() + "/tables" + "/" + this.tableId + "/compact-id";
        String zCancelID = "/accumulo/" + HdfsZooInstance.getInstance().getInstanceID() + "/tables" + "/" + this.tableId + "/compact-cancel-id";
        IZooReaderWriter zoo = ZooReaderWriter.getRetryingInstance();
        byte[] currentValue = zoo.getData(zCompactID, null);
        String cvs = new String(currentValue, Constants.UTF8);
        String[] tokens = cvs.split(",");
        final long flushID = Long.parseLong(tokens[0]);
        zoo.mutate(zCancelID, null, null, new IZooReaderWriter.Mutator(){

            public byte[] mutate(byte[] currentValue) throws Exception {
                long cid = Long.parseLong(new String(currentValue, Constants.UTF8));
                if (cid < flushID) {
                    return Long.toString(flushID).getBytes(Constants.UTF8);
                }
                return Long.toString(cid).getBytes(Constants.UTF8);
            }
        });
        return new FinishCancelCompaction(this.tableId);
    }

    @Override
    public void undo(long tid, Master environment) throws Exception {
        Utils.unreserveNamespace(this.namespaceId, tid, false);
        Utils.unreserveTable(this.tableId, tid, false);
    }
}

