/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.master.tableOps;

import org.apache.accumulo.fate.Repo;
import org.apache.accumulo.master.Master;
import org.apache.accumulo.master.tableOps.ImportedTableInfo;
import org.apache.accumulo.master.tableOps.MapImportFileNames;
import org.apache.accumulo.master.tableOps.MasterRepo;
import org.apache.accumulo.server.ServerConstants;
import org.apache.accumulo.server.tablets.UniqueNameAllocator;
import org.apache.hadoop.fs.Path;

class CreateImportDir
extends MasterRepo {
    private static final long serialVersionUID = 1L;
    private ImportedTableInfo tableInfo;

    CreateImportDir(ImportedTableInfo ti) {
        this.tableInfo = ti;
    }

    @Override
    public Repo<Master> call(long tid, Master master) throws Exception {
        UniqueNameAllocator namer = UniqueNameAllocator.getInstance();
        Path base = master.getFileSystem().matchingFileSystem(new Path(this.tableInfo.exportDir), ServerConstants.getTablesDirs());
        Path directory = new Path(base, this.tableInfo.tableId);
        Path newBulkDir = new Path(directory, "b-" + namer.getNextName());
        this.tableInfo.importDir = newBulkDir.toString();
        return new MapImportFileNames(this.tableInfo);
    }
}

