/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.master.recovery;

import com.google.common.base.Charsets;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.KeyExtent;
import org.apache.accumulo.core.util.NamingThreadFactory;
import org.apache.accumulo.core.zookeeper.ZooUtil;
import org.apache.accumulo.master.Master;
import org.apache.accumulo.server.ServerConstants;
import org.apache.accumulo.server.fs.VolumeManager;
import org.apache.accumulo.server.fs.VolumeUtil;
import org.apache.accumulo.server.log.SortedLogState;
import org.apache.accumulo.server.master.recovery.HadoopLogCloser;
import org.apache.accumulo.server.master.recovery.LogCloser;
import org.apache.accumulo.server.master.recovery.RecoveryPath;
import org.apache.accumulo.server.zookeeper.DistributedWorkQueue;
import org.apache.accumulo.server.zookeeper.ZooCache;
import org.apache.hadoop.fs.Path;
import org.apache.log4j.Logger;
import org.apache.zookeeper.KeeperException;

public class RecoveryManager {
    private static Logger log = Logger.getLogger(RecoveryManager.class);
    private Map<String, Long> recoveryDelay = new HashMap<String, Long>();
    private Set<String> closeTasksQueued = new HashSet<String>();
    private Set<String> sortsQueued = new HashSet<String>();
    private ScheduledExecutorService executor;
    private Master master;
    private ZooCache zooCache;

    public RecoveryManager(Master master) {
        this.master = master;
        this.executor = Executors.newScheduledThreadPool(4, (ThreadFactory)new NamingThreadFactory("Walog sort starter "));
        this.zooCache = new ZooCache();
        try {
            List workIDs = new DistributedWorkQueue(ZooUtil.getRoot((Instance)master.getInstance()) + "/recovery").getWorkQueued();
            this.sortsQueued.addAll(workIDs);
        }
        catch (Exception e) {
            log.warn((Object)e, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initiateSort(String sortId, String source, String destination) throws KeeperException, InterruptedException, IOException {
        String work = source + "|" + destination;
        new DistributedWorkQueue(ZooUtil.getRoot((Instance)this.master.getInstance()) + "/recovery").addWork(sortId, work.getBytes(Charsets.UTF_8));
        RecoveryManager recoveryManager = this;
        synchronized (recoveryManager) {
            this.sortsQueued.add(sortId);
        }
        String path = ZooUtil.getRoot((Instance)this.master.getInstance()) + "/recovery" + "/" + sortId;
        log.info((Object)("Created zookeeper entry " + path + " with data " + work));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean recoverLogs(KeyExtent extent, Collection<Collection<String>> walogs) throws IOException {
        boolean recoveryNeeded = false;
        for (Collection<String> logs : walogs) {
            for (String walog : logs) {
                boolean sortQueued;
                String switchedWalog = VolumeUtil.switchVolume((String)walog, (VolumeManager.FileType)VolumeManager.FileType.WAL, (List)ServerConstants.getVolumeReplacements());
                if (switchedWalog != null) {
                    log.info((Object)("Volume replaced " + walog + " -> " + switchedWalog));
                    walog = switchedWalog;
                }
                String[] parts = walog.split("/");
                String sortId = parts[parts.length - 1];
                String filename = this.master.getFileSystem().getFullPath(VolumeManager.FileType.WAL, walog).toString();
                String dest = RecoveryPath.getRecoveryPath((VolumeManager)this.master.getFileSystem(), (Path)new Path(filename)).toString();
                log.debug((Object)("Recovering " + filename + " to " + dest));
                RecoveryManager recoveryManager = this;
                synchronized (recoveryManager) {
                    sortQueued = this.sortsQueued.contains(sortId);
                }
                if (sortQueued && this.zooCache.get(ZooUtil.getRoot((Instance)this.master.getInstance()) + "/recovery" + "/" + sortId) == null) {
                    recoveryManager = this;
                    synchronized (recoveryManager) {
                        this.sortsQueued.remove(sortId);
                    }
                }
                if (this.master.getFileSystem().exists(SortedLogState.getFinishedMarkerPath((String)dest))) {
                    recoveryManager = this;
                    synchronized (recoveryManager) {
                        this.closeTasksQueued.remove(sortId);
                        this.recoveryDelay.remove(sortId);
                        this.sortsQueued.remove(sortId);
                        continue;
                    }
                }
                recoveryNeeded = true;
                recoveryManager = this;
                synchronized (recoveryManager) {
                    if (!this.closeTasksQueued.contains(sortId) && !this.sortsQueued.contains(sortId)) {
                        AccumuloConfiguration aconf = this.master.getConfiguration().getConfiguration();
                        LogCloser closer = (LogCloser)aconf.instantiateClassProperty(Property.MASTER_WALOG_CLOSER_IMPLEMETATION, LogCloser.class, (Object)new HadoopLogCloser());
                        Long delay = this.recoveryDelay.get(sortId);
                        delay = delay == null ? Long.valueOf(this.master.getSystemConfiguration().getTimeInMillis(Property.MASTER_RECOVERY_DELAY)) : Long.valueOf(Math.min(2L * delay, 300000L));
                        log.info((Object)("Starting recovery of " + filename + " (in : " + delay / 1000L + "s), tablet " + extent + " holds a reference"));
                        this.executor.schedule(new LogSortTask(closer, filename, dest, sortId), (long)delay, TimeUnit.MILLISECONDS);
                        this.closeTasksQueued.add(sortId);
                        this.recoveryDelay.put(sortId, delay);
                    }
                }
            }
        }
        return recoveryNeeded;
    }

    private class LogSortTask
    implements Runnable {
        private String source;
        private String destination;
        private String sortId;
        private LogCloser closer;

        public LogSortTask(LogCloser closer, String source, String destination, String sortId) {
            this.closer = closer;
            this.source = source;
            this.destination = destination;
            this.sortId = sortId;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            boolean rescheduled = false;
            try {
                long time = this.closer.close(RecoveryManager.this.master.getConfiguration().getConfiguration(), RecoveryManager.this.master.getFileSystem(), new Path(this.source));
                if (time > 0L) {
                    RecoveryManager.this.executor.schedule(this, time, TimeUnit.MILLISECONDS);
                    rescheduled = true;
                } else {
                    RecoveryManager.this.initiateSort(this.sortId, this.source, this.destination);
                }
            }
            catch (FileNotFoundException e) {
                log.debug((Object)("Unable to initate log sort for " + this.source + ": " + e));
            }
            catch (Exception e) {
                log.warn((Object)("Failed to initiate log sort " + this.source), (Throwable)e);
            }
            finally {
                if (!rescheduled) {
                    RecoveryManager e = RecoveryManager.this;
                    synchronized (e) {
                        RecoveryManager.this.closeTasksQueued.remove(this.sortId);
                    }
                }
            }
        }
    }
}

