/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.master.tableOps;

import com.google.common.base.Charsets;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.NamespaceNotFoundException;
import org.apache.accumulo.core.client.impl.Namespaces;
import org.apache.accumulo.core.client.impl.Tables;
import org.apache.accumulo.core.client.impl.thrift.TableOperation;
import org.apache.accumulo.core.client.impl.thrift.TableOperationExceptionType;
import org.apache.accumulo.core.client.impl.thrift.ThriftTableOperationException;
import org.apache.accumulo.core.util.Pair;
import org.apache.accumulo.core.zookeeper.ZooUtil;
import org.apache.accumulo.fate.Repo;
import org.apache.accumulo.fate.zookeeper.IZooReaderWriter;
import org.apache.accumulo.master.Master;
import org.apache.accumulo.master.tableOps.MasterRepo;
import org.apache.accumulo.master.tableOps.Utils;
import org.apache.accumulo.server.client.HdfsZooInstance;
import org.apache.accumulo.server.zookeeper.ZooReaderWriter;
import org.apache.log4j.Logger;

public class RenameTable
extends MasterRepo {
    private static final long serialVersionUID = 1L;
    private String tableId;
    private String oldTableName;
    private String newTableName;
    private String namespaceId;

    @Override
    public long isReady(long tid, Master environment) throws Exception {
        return Utils.reserveNamespace(this.namespaceId, tid, false, true, TableOperation.RENAME) + Utils.reserveTable(this.tableId, tid, true, true, TableOperation.RENAME);
    }

    public RenameTable(String tableId, String oldTableName, String newTableName) throws NamespaceNotFoundException {
        this.tableId = tableId;
        this.oldTableName = oldTableName;
        this.newTableName = newTableName;
        Instance inst = HdfsZooInstance.getInstance();
        this.namespaceId = Tables.getNamespaceId((Instance)inst, (String)tableId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Repo<Master> call(long tid, Master master) throws Exception {
        Instance instance = master.getInstance();
        Pair qualifiedOldTableName = Tables.qualify((String)this.oldTableName);
        Pair qualifiedNewTableName = Tables.qualify((String)this.newTableName);
        if (this.newTableName.contains(".") && !this.namespaceId.equals(Namespaces.getNamespaceId((Instance)instance, (String)((String)qualifiedNewTableName.getFirst())))) {
            throw new ThriftTableOperationException(this.tableId, this.oldTableName, TableOperation.RENAME, TableOperationExceptionType.INVALID_NAME, "Namespace in new table name does not match the old table name");
        }
        ZooReaderWriter zoo = ZooReaderWriter.getInstance();
        Utils.tableNameLock.lock();
        try {
            Utils.checkTableDoesNotExist(instance, this.newTableName, this.tableId, TableOperation.RENAME);
            final String newName = (String)qualifiedNewTableName.getSecond();
            final String oldName = (String)qualifiedOldTableName.getSecond();
            String tap = ZooUtil.getRoot((Instance)instance) + "/tables" + "/" + this.tableId + "/name";
            zoo.mutate(tap, null, null, new IZooReaderWriter.Mutator(){

                public byte[] mutate(byte[] current) throws Exception {
                    String currentName = new String(current, Charsets.UTF_8);
                    if (currentName.equals(newName)) {
                        return null;
                    }
                    if (!currentName.equals(oldName)) {
                        throw new ThriftTableOperationException(null, RenameTable.this.oldTableName, TableOperation.RENAME, TableOperationExceptionType.NOTFOUND, "Name changed while processing");
                    }
                    return newName.getBytes(Charsets.UTF_8);
                }
            });
            Tables.clearCache((Instance)instance);
        }
        finally {
            Utils.tableNameLock.unlock();
            Utils.unreserveTable(this.tableId, tid, true);
            Utils.unreserveNamespace(this.namespaceId, tid, false);
        }
        Logger.getLogger(RenameTable.class).debug((Object)("Renamed table " + this.tableId + " " + this.oldTableName + " " + this.newTableName));
        return null;
    }

    @Override
    public void undo(long tid, Master env) throws Exception {
        Utils.unreserveTable(this.tableId, tid, true);
        Utils.unreserveNamespace(this.namespaceId, tid, false);
    }
}

