/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.master.tableOps;

import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.impl.Tables;
import org.apache.accumulo.core.client.impl.thrift.TableOperation;
import org.apache.accumulo.core.master.state.tables.TableState;
import org.apache.accumulo.fate.Repo;
import org.apache.accumulo.master.Master;
import org.apache.accumulo.master.tableOps.MasterRepo;
import org.apache.accumulo.master.tableOps.Utils;
import org.apache.accumulo.server.client.HdfsZooInstance;
import org.apache.accumulo.server.tables.TableManager;
import org.apache.log4j.Logger;

public class ChangeTableState
extends MasterRepo {
    private static final long serialVersionUID = 1L;
    private String tableId;
    private TableOperation top;
    private String namespaceId;

    public ChangeTableState(String tableId, TableOperation top) {
        this.tableId = tableId;
        this.top = top;
        Instance inst = HdfsZooInstance.getInstance();
        this.namespaceId = Tables.getNamespaceId((Instance)inst, (String)tableId);
        if (top != TableOperation.ONLINE && top != TableOperation.OFFLINE) {
            throw new IllegalArgumentException(top.toString());
        }
    }

    @Override
    public long isReady(long tid, Master environment) throws Exception {
        return Utils.reserveNamespace(this.namespaceId, tid, false, true, this.top) + Utils.reserveTable(this.tableId, tid, true, true, this.top);
    }

    @Override
    public Repo<Master> call(long tid, Master env) throws Exception {
        TableState ts = TableState.ONLINE;
        if (this.top == TableOperation.OFFLINE) {
            ts = TableState.OFFLINE;
        }
        TableManager.getInstance().transitionTableState(this.tableId, ts);
        Utils.unreserveNamespace(this.namespaceId, tid, false);
        Utils.unreserveTable(this.tableId, tid, true);
        Logger.getLogger(ChangeTableState.class).debug((Object)("Changed table state " + this.tableId + " " + ts));
        env.getEventCoordinator().event("Set table state of %s to %s", this.tableId, ts);
        return null;
    }

    @Override
    public void undo(long tid, Master env) throws Exception {
        Utils.unreserveNamespace(this.namespaceId, tid, false);
        Utils.unreserveTable(this.tableId, tid, true);
    }
}

