/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.master.tableOps;

import org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException;
import org.apache.accumulo.core.security.NamespacePermission;
import org.apache.accumulo.fate.Repo;
import org.apache.accumulo.master.Master;
import org.apache.accumulo.master.tableOps.FinishCreateNamespace;
import org.apache.accumulo.master.tableOps.MasterRepo;
import org.apache.accumulo.master.tableOps.NamespaceInfo;
import org.apache.accumulo.master.tableOps.PopulateZookeeperWithNamespace;
import org.apache.accumulo.server.security.AuditedSecurityOperation;
import org.apache.accumulo.server.security.SecurityOperation;
import org.apache.accumulo.server.security.SystemCredentials;
import org.apache.log4j.Logger;

class SetupNamespacePermissions
extends MasterRepo {
    private static final long serialVersionUID = 1L;
    private NamespaceInfo namespaceInfo;

    public SetupNamespacePermissions(NamespaceInfo ti) {
        this.namespaceInfo = ti;
    }

    @Override
    public Repo<Master> call(long tid, Master env) throws Exception {
        SecurityOperation security = AuditedSecurityOperation.getInstance();
        for (NamespacePermission permission : NamespacePermission.values()) {
            try {
                security.grantNamespacePermission(SystemCredentials.get().toThrift(env.getInstance()), this.namespaceInfo.user, this.namespaceInfo.namespaceId, permission);
            }
            catch (ThriftSecurityException e) {
                Logger.getLogger(FinishCreateNamespace.class).error((Object)e.getMessage(), (Throwable)e);
                throw e;
            }
        }
        return new PopulateZookeeperWithNamespace(this.namespaceInfo);
    }
}

