/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.master.tableOps;

import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.impl.Tables;
import org.apache.accumulo.core.client.impl.thrift.TableOperation;
import org.apache.accumulo.core.master.state.tables.TableState;
import org.apache.accumulo.fate.Repo;
import org.apache.accumulo.master.Master;
import org.apache.accumulo.master.tableOps.MasterRepo;
import org.apache.accumulo.master.tableOps.Utils;
import org.apache.accumulo.server.tables.TableManager;
import org.slf4j.LoggerFactory;

public class ChangeTableState
extends MasterRepo {
    private static final long serialVersionUID = 1L;
    private String tableId;
    private TableOperation top;

    public ChangeTableState(String tableId, TableOperation top) {
        this.tableId = tableId;
        this.top = top;
        if (top != TableOperation.ONLINE && top != TableOperation.OFFLINE) {
            throw new IllegalArgumentException(top.toString());
        }
    }

    @Override
    public long isReady(long tid, Master environment) throws Exception {
        String namespaceId = Tables.getNamespaceId((Instance)environment.getInstance(), (String)this.tableId);
        return Utils.reserveNamespace(namespaceId, tid, false, true, this.top) + Utils.reserveTable(this.tableId, tid, true, true, this.top);
    }

    @Override
    public Repo<Master> call(long tid, Master env) throws Exception {
        String namespaceId = Tables.getNamespaceId((Instance)env.getInstance(), (String)this.tableId);
        TableState ts = TableState.ONLINE;
        if (this.top == TableOperation.OFFLINE) {
            ts = TableState.OFFLINE;
        }
        TableManager.getInstance().transitionTableState(this.tableId, ts);
        Utils.unreserveNamespace(namespaceId, tid, false);
        Utils.unreserveTable(this.tableId, tid, true);
        LoggerFactory.getLogger(ChangeTableState.class).debug("Changed table state " + this.tableId + " " + ts);
        env.getEventCoordinator().event("Set table state of %s to %s", this.tableId, ts);
        return null;
    }

    @Override
    public void undo(long tid, Master env) throws Exception {
        String namespaceId = Tables.getNamespaceId((Instance)env.getInstance(), (String)this.tableId);
        Utils.unreserveNamespace(namespaceId, tid, false);
        Utils.unreserveTable(this.tableId, tid, true);
    }
}

