/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.master.tableOps;

import org.apache.accumulo.core.master.state.tables.TableState;
import org.apache.accumulo.fate.Repo;
import org.apache.accumulo.master.Master;
import org.apache.accumulo.master.tableOps.CloneInfo;
import org.apache.accumulo.master.tableOps.MasterRepo;
import org.apache.accumulo.master.tableOps.Utils;
import org.apache.accumulo.server.tables.TableManager;
import org.slf4j.LoggerFactory;

class FinishCloneTable
extends MasterRepo {
    private static final long serialVersionUID = 1L;
    private CloneInfo cloneInfo;

    public FinishCloneTable(CloneInfo cloneInfo) {
        this.cloneInfo = cloneInfo;
    }

    @Override
    public long isReady(long tid, Master environment) throws Exception {
        return 0L;
    }

    @Override
    public Repo<Master> call(long tid, Master environment) throws Exception {
        TableManager.getInstance().transitionTableState(this.cloneInfo.tableId, TableState.ONLINE);
        Utils.unreserveNamespace(this.cloneInfo.srcNamespaceId, tid, false);
        if (!this.cloneInfo.srcNamespaceId.equals(this.cloneInfo.namespaceId)) {
            Utils.unreserveNamespace(this.cloneInfo.namespaceId, tid, false);
        }
        Utils.unreserveTable(this.cloneInfo.srcTableId, tid, false);
        Utils.unreserveTable(this.cloneInfo.tableId, tid, true);
        environment.getEventCoordinator().event("Cloned table %s from %s", this.cloneInfo.tableName, this.cloneInfo.srcTableId);
        LoggerFactory.getLogger(FinishCloneTable.class).debug("Cloned table " + this.cloneInfo.srcTableId + " " + this.cloneInfo.tableId + " " + this.cloneInfo.tableName);
        return null;
    }

    @Override
    public void undo(long tid, Master environment) throws Exception {
    }
}

