/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.master.tableOps;

import java.util.Map;
import java.util.Set;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.impl.Tables;
import org.apache.accumulo.core.client.impl.thrift.TableOperation;
import org.apache.accumulo.core.client.impl.thrift.TableOperationExceptionType;
import org.apache.accumulo.core.client.impl.thrift.ThriftTableOperationException;
import org.apache.accumulo.fate.Repo;
import org.apache.accumulo.master.Master;
import org.apache.accumulo.master.tableOps.CloneInfo;
import org.apache.accumulo.master.tableOps.ClonePermissions;
import org.apache.accumulo.master.tableOps.MasterRepo;
import org.apache.accumulo.master.tableOps.Utils;
import org.apache.accumulo.server.client.HdfsZooInstance;

public class CloneTable
extends MasterRepo {
    private static final long serialVersionUID = 1L;
    private CloneInfo cloneInfo = new CloneInfo();

    public CloneTable(String user, String srcTableId, String tableName, Map<String, String> propertiesToSet, Set<String> propertiesToExclude) throws ThriftTableOperationException {
        this.cloneInfo.user = user;
        this.cloneInfo.srcTableId = srcTableId;
        this.cloneInfo.tableName = tableName;
        this.cloneInfo.propertiesToExclude = propertiesToExclude;
        this.cloneInfo.propertiesToSet = propertiesToSet;
        Instance inst = HdfsZooInstance.getInstance();
        try {
            this.cloneInfo.srcNamespaceId = Tables.getNamespaceId((Instance)inst, (String)this.cloneInfo.srcTableId);
        }
        catch (IllegalArgumentException e) {
            if (inst == null || this.cloneInfo.srcTableId == null) {
                throw e;
            }
            throw new ThriftTableOperationException(this.cloneInfo.srcTableId, "", TableOperation.CLONE, TableOperationExceptionType.NOTFOUND, "Table does not exist");
        }
    }

    @Override
    public long isReady(long tid, Master environment) throws Exception {
        long val = Utils.reserveNamespace(this.cloneInfo.srcNamespaceId, tid, false, true, TableOperation.CLONE);
        return val += Utils.reserveTable(this.cloneInfo.srcTableId, tid, false, true, TableOperation.CLONE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Repo<Master> call(long tid, Master environment) throws Exception {
        Utils.idLock.lock();
        try {
            this.cloneInfo.tableId = Utils.getNextTableId(this.cloneInfo.tableName, environment.getInstance());
            ClonePermissions clonePermissions = new ClonePermissions(this.cloneInfo);
            return clonePermissions;
        }
        finally {
            Utils.idLock.unlock();
        }
    }

    @Override
    public void undo(long tid, Master environment) throws Exception {
        Utils.unreserveNamespace(this.cloneInfo.srcNamespaceId, tid, false);
        Utils.unreserveTable(this.cloneInfo.srcTableId, tid, false);
    }
}

