/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.master.tableOps;

import org.apache.accumulo.core.client.impl.thrift.TableOperation;
import org.apache.accumulo.fate.Repo;
import org.apache.accumulo.master.Master;
import org.apache.accumulo.master.tableOps.MasterRepo;
import org.apache.accumulo.master.tableOps.Utils;
import org.apache.accumulo.server.master.state.MergeInfo;
import org.apache.accumulo.server.master.state.MergeState;
import org.apache.hadoop.io.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TableRangeOpWait
extends MasterRepo {
    private static final Logger log = LoggerFactory.getLogger(TableRangeOpWait.class);
    private static final long serialVersionUID = 1L;
    private String tableId;
    private String namespaceId;

    public TableRangeOpWait(String namespaceId, String tableId) {
        this.tableId = tableId;
        this.namespaceId = namespaceId;
    }

    @Override
    public long isReady(long tid, Master env) throws Exception {
        Text tableIdText = new Text(this.tableId);
        if (!env.getMergeInfo(tableIdText).getState().equals((Object)MergeState.NONE)) {
            return 50L;
        }
        return 0L;
    }

    @Override
    public Repo<Master> call(long tid, Master master) throws Exception {
        Text tableIdText = new Text(this.tableId);
        MergeInfo mergeInfo = master.getMergeInfo(tableIdText);
        log.info("removing merge information " + mergeInfo);
        master.clearMergeState(tableIdText);
        Utils.unreserveTable(this.tableId, tid, true);
        Utils.unreserveNamespace(Utils.getNamespaceId(master.getInstance(), this.tableId, TableOperation.MERGE, this.namespaceId), tid, false);
        return null;
    }
}

