/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.master.tableOps;

import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.IsolatedScanner;
import org.apache.accumulo.core.client.RowIterator;
import org.apache.accumulo.core.client.ScannerBase;
import org.apache.accumulo.core.client.impl.Tables;
import org.apache.accumulo.core.client.impl.thrift.TableOperation;
import org.apache.accumulo.core.client.impl.thrift.TableOperationExceptionType;
import org.apache.accumulo.core.client.impl.thrift.ThriftTableOperationException;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.data.impl.KeyExtent;
import org.apache.accumulo.core.master.state.tables.TableState;
import org.apache.accumulo.core.metadata.schema.MetadataSchema;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.util.MapCounter;
import org.apache.accumulo.fate.Repo;
import org.apache.accumulo.master.Master;
import org.apache.accumulo.master.tableOps.CompactRange;
import org.apache.accumulo.master.tableOps.MasterRepo;
import org.apache.accumulo.master.tableOps.Utils;
import org.apache.accumulo.server.master.LiveTServerSet;
import org.apache.accumulo.server.master.state.TServerInstance;
import org.apache.accumulo.server.zookeeper.ZooReaderWriter;
import org.apache.hadoop.io.BinaryComparable;
import org.apache.hadoop.io.Text;
import org.apache.thrift.TException;
import org.slf4j.LoggerFactory;

class CompactionDriver
extends MasterRepo {
    private static final long serialVersionUID = 1L;
    private long compactId;
    private final String tableId;
    private final String namespaceId;
    private byte[] startRow;
    private byte[] endRow;

    private String getNamespaceId(Master env) throws Exception {
        return Utils.getNamespaceId(env.getInstance(), this.tableId, TableOperation.COMPACT, this.namespaceId);
    }

    public CompactionDriver(long compactId, String namespaceId, String tableId, byte[] startRow, byte[] endRow) {
        this.compactId = compactId;
        this.tableId = tableId;
        this.namespaceId = namespaceId;
        this.startRow = startRow;
        this.endRow = endRow;
    }

    @Override
    public long isReady(long tid, Master master) throws Exception {
        IsolatedScanner scanner;
        String zCancelID = "/accumulo/" + master.getInstance().getInstanceID() + "/tables" + "/" + this.tableId + "/compact-cancel-id";
        ZooReaderWriter zoo = ZooReaderWriter.getInstance();
        if (Long.parseLong(new String(zoo.getData(zCancelID, null))) >= this.compactId) {
            throw new ThriftTableOperationException(this.tableId, null, TableOperation.COMPACT, TableOperationExceptionType.OTHER, "Compaction canceled");
        }
        MapCounter serversToFlush = new MapCounter();
        Connector conn = master.getConnector();
        if (this.tableId.equals("!0")) {
            scanner = new IsolatedScanner(conn.createScanner("accumulo.root", Authorizations.EMPTY));
            scanner.setRange(MetadataSchema.TabletsSection.getRange());
        } else {
            scanner = new IsolatedScanner(conn.createScanner("accumulo.metadata", Authorizations.EMPTY));
            Range range = new KeyExtent(new Text(this.tableId), null, this.startRow == null ? null : new Text(this.startRow)).toMetadataRange();
            scanner.setRange(range);
        }
        MetadataSchema.TabletsSection.ServerColumnFamily.COMPACT_COLUMN.fetch((ScannerBase)scanner);
        MetadataSchema.TabletsSection.ServerColumnFamily.DIRECTORY_COLUMN.fetch((ScannerBase)scanner);
        scanner.fetchColumnFamily(MetadataSchema.TabletsSection.CurrentLocationColumnFamily.NAME);
        long t1 = System.currentTimeMillis();
        RowIterator ri = new RowIterator((Iterable)scanner);
        int tabletsToWaitFor = 0;
        int tabletCount = 0;
        while (ri.hasNext()) {
            Iterator row = ri.next();
            long tabletCompactID = -1L;
            TServerInstance server = null;
            Map.Entry entry = null;
            while (row.hasNext()) {
                entry = (Map.Entry)row.next();
                Key key = (Key)entry.getKey();
                if (MetadataSchema.TabletsSection.ServerColumnFamily.COMPACT_COLUMN.equals(key.getColumnFamily(), key.getColumnQualifier())) {
                    tabletCompactID = Long.parseLong(((Value)entry.getValue()).toString());
                }
                if (!MetadataSchema.TabletsSection.CurrentLocationColumnFamily.NAME.equals((Object)key.getColumnFamily())) continue;
                server = new TServerInstance((Value)entry.getValue(), key.getColumnQualifier());
            }
            if (tabletCompactID < this.compactId) {
                ++tabletsToWaitFor;
                if (server != null) {
                    serversToFlush.increment(server, 1L);
                }
            }
            ++tabletCount;
            Text tabletEndRow = new KeyExtent(((Key)entry.getKey()).getRow(), (Text)null).getEndRow();
            if (tabletEndRow != null && (this.endRow == null || tabletEndRow.compareTo((BinaryComparable)new Text(this.endRow)) < 0)) continue;
            break;
        }
        long scanTime = System.currentTimeMillis() - t1;
        Instance instance = master.getInstance();
        Tables.clearCache((Instance)instance);
        if (tabletCount == 0 && !Tables.exists((Instance)instance, (String)this.tableId)) {
            throw new ThriftTableOperationException(this.tableId, null, TableOperation.COMPACT, TableOperationExceptionType.NOTFOUND, null);
        }
        if (serversToFlush.size() == 0 && Tables.getTableState((Instance)instance, (String)this.tableId) == TableState.OFFLINE) {
            throw new ThriftTableOperationException(this.tableId, null, TableOperation.COMPACT, TableOperationExceptionType.OFFLINE, null);
        }
        if (tabletsToWaitFor == 0) {
            return 0L;
        }
        for (TServerInstance tsi : serversToFlush.keySet()) {
            try {
                LiveTServerSet.TServerConnection server = master.getConnection(tsi);
                if (server == null) continue;
                server.compact(master.getMasterLock(), this.tableId, this.startRow, this.endRow);
            }
            catch (TException ex) {
                LoggerFactory.getLogger(CompactionDriver.class).error(ex.toString());
            }
        }
        long sleepTime = 500L;
        if (serversToFlush.size() > 0) {
            sleepTime = (Long)Collections.max(serversToFlush.values()) * sleepTime;
        }
        sleepTime = Math.max(2L * scanTime, sleepTime);
        sleepTime = Math.min(sleepTime, 30000L);
        return sleepTime;
    }

    @Override
    public Repo<Master> call(long tid, Master env) throws Exception {
        CompactRange.removeIterators(env, tid, this.tableId);
        Utils.getReadLock(this.tableId, tid).unlock();
        Utils.getReadLock(this.getNamespaceId(env), tid).unlock();
        return null;
    }

    @Override
    public void undo(long tid, Master environment) throws Exception {
    }
}

