/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.master.tableOps;

import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.impl.Tables;
import org.apache.accumulo.core.client.impl.thrift.TableOperation;
import org.apache.accumulo.core.client.impl.thrift.TableOperationExceptionType;
import org.apache.accumulo.core.client.impl.thrift.ThriftTableOperationException;
import org.apache.accumulo.core.zookeeper.ZooUtil;
import org.apache.accumulo.fate.Repo;
import org.apache.accumulo.fate.zookeeper.IZooReaderWriter;
import org.apache.accumulo.master.Master;
import org.apache.accumulo.master.tableOps.MasterRepo;
import org.apache.accumulo.master.tableOps.Utils;
import org.apache.accumulo.server.zookeeper.ZooReaderWriter;
import org.slf4j.LoggerFactory;

public class RenameNamespace
extends MasterRepo {
    private static final long serialVersionUID = 1L;
    private String namespaceId;
    private String oldName;
    private String newName;

    @Override
    public long isReady(long id, Master environment) throws Exception {
        return Utils.reserveNamespace(this.namespaceId, id, true, true, TableOperation.RENAME);
    }

    public RenameNamespace(String namespaceId, String oldName, String newName) {
        this.namespaceId = namespaceId;
        this.oldName = oldName;
        this.newName = newName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Repo<Master> call(long id, Master master) throws Exception {
        Instance instance = master.getInstance();
        ZooReaderWriter zoo = ZooReaderWriter.getInstance();
        Utils.tableNameLock.lock();
        try {
            Utils.checkNamespaceDoesNotExist(instance, this.newName, this.namespaceId, TableOperation.RENAME);
            String tap = ZooUtil.getRoot((Instance)instance) + "/namespaces" + "/" + this.namespaceId + "/name";
            zoo.mutate(tap, null, null, new IZooReaderWriter.Mutator(){

                public byte[] mutate(byte[] current) throws Exception {
                    String currentName = new String(current);
                    if (currentName.equals(RenameNamespace.this.newName)) {
                        return null;
                    }
                    if (!currentName.equals(RenameNamespace.this.oldName)) {
                        throw new ThriftTableOperationException(null, RenameNamespace.this.oldName, TableOperation.RENAME, TableOperationExceptionType.NAMESPACE_NOTFOUND, "Name changed while processing");
                    }
                    return RenameNamespace.this.newName.getBytes();
                }
            });
            Tables.clearCache((Instance)instance);
        }
        finally {
            Utils.tableNameLock.unlock();
            Utils.unreserveNamespace(this.namespaceId, id, true);
        }
        LoggerFactory.getLogger(RenameNamespace.class).debug("Renamed namespace " + this.namespaceId + " " + this.oldName + " " + this.newName);
        return null;
    }

    @Override
    public void undo(long tid, Master env) throws Exception {
        Utils.unreserveNamespace(this.namespaceId, tid, true);
    }
}

