/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.master;

import com.google.common.base.Optional;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.Uninterruptibles;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.ScannerBase;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.impl.ClientContext;
import org.apache.accumulo.core.client.impl.Namespaces;
import org.apache.accumulo.core.client.impl.Tables;
import org.apache.accumulo.core.client.impl.ThriftTransportPool;
import org.apache.accumulo.core.client.impl.thrift.TableOperation;
import org.apache.accumulo.core.client.impl.thrift.TableOperationExceptionType;
import org.apache.accumulo.core.client.impl.thrift.ThriftTableOperationException;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.conf.SiteConfiguration;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.data.impl.KeyExtent;
import org.apache.accumulo.core.master.state.tables.TableState;
import org.apache.accumulo.core.master.thrift.BulkImportState;
import org.apache.accumulo.core.master.thrift.MasterClientService;
import org.apache.accumulo.core.master.thrift.MasterGoalState;
import org.apache.accumulo.core.master.thrift.MasterMonitorInfo;
import org.apache.accumulo.core.master.thrift.MasterState;
import org.apache.accumulo.core.master.thrift.TableInfo;
import org.apache.accumulo.core.master.thrift.TabletServerStatus;
import org.apache.accumulo.core.metadata.schema.MetadataSchema;
import org.apache.accumulo.core.replication.thrift.ReplicationCoordinator;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.security.NamespacePermission;
import org.apache.accumulo.core.security.TablePermission;
import org.apache.accumulo.core.tabletserver.thrift.TUnloadTabletGoal;
import org.apache.accumulo.core.trace.DistributedTrace;
import org.apache.accumulo.core.trace.thrift.TInfo;
import org.apache.accumulo.core.util.Daemon;
import org.apache.accumulo.core.util.Pair;
import org.apache.accumulo.core.zookeeper.ZooUtil;
import org.apache.accumulo.fate.AgeOffStore;
import org.apache.accumulo.fate.Fate;
import org.apache.accumulo.fate.TStore;
import org.apache.accumulo.fate.ZooStore;
import org.apache.accumulo.fate.zookeeper.IZooReaderWriter;
import org.apache.accumulo.fate.zookeeper.ZooLock;
import org.apache.accumulo.fate.zookeeper.ZooUtil;
import org.apache.accumulo.master.EventCoordinator;
import org.apache.accumulo.master.MasterClientServiceHandler;
import org.apache.accumulo.master.MasterTime;
import org.apache.accumulo.master.TabletGroupWatcher;
import org.apache.accumulo.master.metrics.MasterMetricsFactory;
import org.apache.accumulo.master.recovery.RecoveryManager;
import org.apache.accumulo.master.replication.MasterReplicationCoordinator;
import org.apache.accumulo.master.replication.ReplicationDriver;
import org.apache.accumulo.master.replication.WorkDriver;
import org.apache.accumulo.master.state.TableCounts;
import org.apache.accumulo.server.Accumulo;
import org.apache.accumulo.server.AccumuloServerContext;
import org.apache.accumulo.server.ServerConstants;
import org.apache.accumulo.server.ServerOpts;
import org.apache.accumulo.server.client.HdfsZooInstance;
import org.apache.accumulo.server.conf.ServerConfigurationFactory;
import org.apache.accumulo.server.fs.VolumeManager;
import org.apache.accumulo.server.fs.VolumeManagerImpl;
import org.apache.accumulo.server.init.Initialize;
import org.apache.accumulo.server.log.WalStateManager;
import org.apache.accumulo.server.master.LiveTServerSet;
import org.apache.accumulo.server.master.balancer.DefaultLoadBalancer;
import org.apache.accumulo.server.master.balancer.TabletBalancer;
import org.apache.accumulo.server.master.state.CurrentState;
import org.apache.accumulo.server.master.state.DeadServerList;
import org.apache.accumulo.server.master.state.DistributedStore;
import org.apache.accumulo.server.master.state.MergeInfo;
import org.apache.accumulo.server.master.state.MergeState;
import org.apache.accumulo.server.master.state.MetaDataStateStore;
import org.apache.accumulo.server.master.state.RootTabletStateStore;
import org.apache.accumulo.server.master.state.TServerInstance;
import org.apache.accumulo.server.master.state.TabletLocationState;
import org.apache.accumulo.server.master.state.TabletMigration;
import org.apache.accumulo.server.master.state.TabletServerState;
import org.apache.accumulo.server.master.state.TabletState;
import org.apache.accumulo.server.master.state.TabletStateStore;
import org.apache.accumulo.server.master.state.ZooTabletStateStore;
import org.apache.accumulo.server.metrics.Metrics;
import org.apache.accumulo.server.replication.ZooKeeperInitialization;
import org.apache.accumulo.server.rpc.RpcWrapper;
import org.apache.accumulo.server.rpc.ServerAddress;
import org.apache.accumulo.server.rpc.TCredentialsUpdatingWrapper;
import org.apache.accumulo.server.rpc.TServerUtils;
import org.apache.accumulo.server.rpc.ThriftServerType;
import org.apache.accumulo.server.security.AuditedSecurityOperation;
import org.apache.accumulo.server.security.SecurityOperation;
import org.apache.accumulo.server.security.SecurityUtil;
import org.apache.accumulo.server.security.delegation.AuthenticationTokenKeyManager;
import org.apache.accumulo.server.security.delegation.AuthenticationTokenSecretManager;
import org.apache.accumulo.server.security.delegation.ZooAuthenticationKeyDistributor;
import org.apache.accumulo.server.security.handler.ZKPermHandler;
import org.apache.accumulo.server.tables.TableManager;
import org.apache.accumulo.server.tables.TableObserver;
import org.apache.accumulo.server.util.DefaultMap;
import org.apache.accumulo.server.util.Halt;
import org.apache.accumulo.server.util.MetadataTableUtil;
import org.apache.accumulo.server.util.ServerBulkImportStatus;
import org.apache.accumulo.server.util.TableInfoUtil;
import org.apache.accumulo.server.util.time.SimpleTimer;
import org.apache.accumulo.server.zookeeper.ZooLock;
import org.apache.accumulo.server.zookeeper.ZooReaderWriter;
import org.apache.accumulo.start.classloader.vfs.AccumuloVFSClassLoader;
import org.apache.accumulo.start.classloader.vfs.ContextManager;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.DataInputBuffer;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.thrift.TBaseProcessor;
import org.apache.thrift.TException;
import org.apache.thrift.TProcessor;
import org.apache.thrift.server.TServer;
import org.apache.thrift.transport.TTransportException;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Master
extends AccumuloServerContext
implements LiveTServerSet.Listener,
TableObserver,
CurrentState {
    static final Logger log = LoggerFactory.getLogger(Master.class);
    static final int ONE_SECOND = 1000;
    static final long TIME_TO_WAIT_BETWEEN_SCANS = 60000L;
    private static final long TIME_BETWEEN_MIGRATION_CLEANUPS = 300000L;
    static final long WAIT_BETWEEN_ERRORS = 1000L;
    private static final long DEFAULT_WAIT_FOR_WATCHER = 10000L;
    private static final int MAX_CLEANUP_WAIT_TIME = 1000;
    private static final int TIME_TO_WAIT_BETWEEN_LOCK_CHECKS = 1000;
    static final int MAX_TSERVER_WORK_CHUNK = 5000;
    private static final int MAX_BAD_STATUS_COUNT = 3;
    final VolumeManager fs;
    private final String hostname;
    private final Object balancedNotifier = new Object();
    final LiveTServerSet tserverSet;
    private final List<TabletGroupWatcher> watchers = new ArrayList<TabletGroupWatcher>();
    final SecurityOperation security;
    final Map<TServerInstance, AtomicInteger> badServers = Collections.synchronizedMap(new DefaultMap((Object)new AtomicInteger()));
    final Set<TServerInstance> serversToShutdown = Collections.synchronizedSet(new HashSet());
    final SortedMap<KeyExtent, TServerInstance> migrations = Collections.synchronizedSortedMap(new TreeMap());
    final EventCoordinator nextEvent = new EventCoordinator();
    private final Object mergeLock = new Object();
    private ReplicationDriver replicationWorkDriver;
    private WorkDriver replicationWorkAssigner;
    RecoveryManager recoveryManager = null;
    private final MasterTime timeKeeper;
    private final boolean delegationTokensAvailable;
    private ZooAuthenticationKeyDistributor keyDistributor;
    private AuthenticationTokenKeyManager authenticationTokenKeyManager;
    ZooLock masterLock = null;
    private TServer clientService = null;
    TabletBalancer tabletBalancer;
    private MasterState state = MasterState.INITIAL;
    Fate<Master> fate;
    volatile SortedMap<TServerInstance, TabletServerStatus> tserverStatus = Collections.unmodifiableSortedMap(new TreeMap());
    final ServerBulkImportStatus bulkImportStatus = new ServerBulkImportStatus();
    static final boolean X = true;
    static final boolean O = false;
    static final boolean[][] transitionOK = new boolean[][]{{true, true, false, false, false, false, true}, {false, true, true, true, false, false, true}, {false, false, true, true, true, false, true}, {false, false, true, true, true, false, true}, {false, false, true, true, true, true, true}, {false, false, false, true, true, true, true}, {false, false, false, false, false, true, true}};
    private boolean haveUpgradedZooKeeper = false;
    private final AtomicBoolean upgradeMetadataRunning = new AtomicBoolean(false);
    private final CountDownLatch waitForMetadataUpgrade = new CountDownLatch(1);
    private final ServerConfigurationFactory serverConfig;
    private MasterClientServiceHandler clientHandler;

    public synchronized MasterState getMasterState() {
        return this.state;
    }

    public boolean stillMaster() {
        return this.getMasterState() != MasterState.STOP;
    }

    synchronized void setMasterState(MasterState newState) {
        if (this.state.equals((Object)newState)) {
            return;
        }
        if (!transitionOK[this.state.ordinal()][newState.ordinal()]) {
            log.error("Programmer error: master should not transition from " + this.state + " to " + newState);
        }
        MasterState oldState = this.state;
        this.state = newState;
        this.nextEvent.event("State changed from %s to %s", oldState, newState);
        if (newState == MasterState.STOP) {
            SimpleTimer.getInstance((AccumuloConfiguration)this.getConfiguration()).schedule(new Runnable(){

                @Override
                public void run() {
                    Master.this.clientService.stop();
                    Master.this.nextEvent.event("stopped event loop", new Object[0]);
                }
            }, 100L, 1000L);
        }
        if (oldState != newState && newState == MasterState.HAVE_LOCK) {
            this.upgradeZookeeper();
        }
        if (oldState != newState && newState == MasterState.NORMAL) {
            this.upgradeMetadata();
        }
    }

    private void moveRootTabletToRootTable(IZooReaderWriter zoo) throws Exception {
        String dirZPath = ZooUtil.getRoot((Instance)this.getInstance()) + "/root_tablet/dir";
        if (!zoo.exists(dirZPath)) {
            Path oldPath = this.fs.getFullPath(VolumeManager.FileType.TABLE, "/!0/root_tablet");
            if (this.fs.exists(oldPath)) {
                String newPath = this.fs.choose(Optional.of((Object)"+r"), ServerConstants.getBaseUris()) + "/tables" + "/" + "+r";
                this.fs.mkdirs(new Path(newPath));
                if (!this.fs.rename(oldPath, new Path(newPath))) {
                    throw new IOException("Failed to move root tablet from " + oldPath + " to " + newPath);
                }
                log.info("Upgrade renamed " + oldPath + " to " + newPath);
            }
            Path location = null;
            for (String basePath : ServerConstants.getTablesDirs()) {
                Path path = new Path(basePath + "/" + "+r" + "/root_tablet");
                if (!this.fs.exists(path)) continue;
                if (location != null) {
                    throw new IllegalStateException("Root table at multiple locations " + location + " " + path);
                }
                location = path;
            }
            if (location == null) {
                throw new IllegalStateException("Failed to find root tablet");
            }
            log.info("Upgrade setting root table location in zookeeper " + location);
            zoo.putPersistentData(dirZPath, location.toString().getBytes(), ZooUtil.NodeExistsPolicy.FAIL);
        }
    }

    private void upgradeZookeeper() {
        int accumuloPersistentVersion = Accumulo.getAccumuloPersistentVersion((VolumeManager)this.fs);
        if (Accumulo.persistentVersionNeedsUpgrade((int)accumuloPersistentVersion)) {
            if (null != this.fate) {
                throw new IllegalStateException("Access to Fate should not have been initialized prior to the Master transitioning to active. Please save all logs and file a bug.");
            }
            Accumulo.abortIfFateTransactions();
            try {
                log.info("Upgrading zookeeper");
                ZooReaderWriter zoo = ZooReaderWriter.getInstance();
                String zooRoot = ZooUtil.getRoot((Instance)this.getInstance());
                log.debug("Handling updates for version " + accumuloPersistentVersion);
                log.debug("Cleaning out remnants of logger role.");
                zoo.recursiveDelete(zooRoot + "/loggers", ZooUtil.NodeMissingPolicy.SKIP);
                zoo.recursiveDelete(zooRoot + "/dead/loggers", ZooUtil.NodeMissingPolicy.SKIP);
                byte[] zero = new byte[]{48};
                log.debug("Initializing recovery area.");
                zoo.putPersistentData(zooRoot + "/recovery", zero, ZooUtil.NodeExistsPolicy.SKIP);
                for (String id : zoo.getChildren(zooRoot + "/tables")) {
                    log.debug("Prepping table " + id + " for compaction cancellations.");
                    zoo.putPersistentData(zooRoot + "/tables" + "/" + id + "/compact-cancel-id", zero, ZooUtil.NodeExistsPolicy.SKIP);
                }
                String zpath = zooRoot + "/config" + "/" + Property.TSERV_WAL_SYNC_METHOD.getKey();
                boolean flushDefault = false;
                try {
                    byte[] data = zoo.getData(zpath, null);
                    if (new String(data, StandardCharsets.UTF_8).endsWith("flush")) {
                        flushDefault = true;
                    }
                }
                catch (KeeperException.NoNodeException data) {
                    // empty catch block
                }
                for (String id : zoo.getChildren(zooRoot + "/tables")) {
                    log.debug("Converting table " + id + " WALog setting to Durability");
                    try {
                        String path = zooRoot + "/tables" + "/" + id + "/conf" + "/" + Property.TABLE_WALOG_ENABLED.getKey();
                        byte[] data = zoo.getData(path, null);
                        boolean useWAL = Boolean.parseBoolean(new String(data, StandardCharsets.UTF_8));
                        zoo.recursiveDelete(path, ZooUtil.NodeMissingPolicy.FAIL);
                        path = zooRoot + "/tables" + "/" + id + "/conf" + "/" + Property.TABLE_DURABILITY.getKey();
                        if (useWAL) {
                            if (flushDefault) {
                                zoo.putPersistentData(path, "flush".getBytes(), ZooUtil.NodeExistsPolicy.SKIP);
                                continue;
                            }
                            zoo.putPersistentData(path, "sync".getBytes(), ZooUtil.NodeExistsPolicy.SKIP);
                            continue;
                        }
                        zoo.putPersistentData(path, "none".getBytes(), ZooUtil.NodeExistsPolicy.SKIP);
                    }
                    catch (KeeperException.NoNodeException path) {}
                }
                String namespaces = ZooUtil.getRoot((Instance)this.getInstance()) + "/namespaces";
                zoo.putPersistentData(namespaces, new byte[0], ZooUtil.NodeExistsPolicy.SKIP);
                for (Pair namespace : Iterables.concat(Collections.singleton(new Pair((Object)"accumulo", (Object)"+accumulo")), Collections.singleton(new Pair((Object)"", (Object)"+default")))) {
                    String ns = (String)namespace.getFirst();
                    String id = (String)namespace.getSecond();
                    log.debug("Upgrade creating namespace \"" + ns + "\" (ID: " + id + ")");
                    if (Namespaces.exists((Instance)this.getInstance(), (String)id)) continue;
                    TableManager.prepareNewNamespaceState((String)this.getInstance().getInstanceID(), (String)id, (String)ns, (ZooUtil.NodeExistsPolicy)ZooUtil.NodeExistsPolicy.SKIP);
                }
                log.debug("Upgrade creating table accumulo.replication (ID: +rep)");
                TableManager.prepareNewTableState((String)this.getInstance().getInstanceID(), (String)"+rep", (String)"+accumulo", (String)"accumulo.replication", (TableState)TableState.OFFLINE, (ZooUtil.NodeExistsPolicy)ZooUtil.NodeExistsPolicy.SKIP);
                log.debug("Upgrade creating table accumulo.root (ID: +r)");
                TableManager.prepareNewTableState((String)this.getInstance().getInstanceID(), (String)"+r", (String)"+accumulo", (String)"accumulo.root", (TableState)TableState.ONLINE, (ZooUtil.NodeExistsPolicy)ZooUtil.NodeExistsPolicy.SKIP);
                Initialize.initSystemTablesConfig();
                this.security.grantTablePermission(this.rpcCreds(), this.security.getRootUsername(), "+r", TablePermission.ALTER_TABLE, "+accumulo");
                String tables = ZooUtil.getRoot((Instance)this.getInstance()) + "/tables";
                for (String tableId : zoo.getChildren(tables)) {
                    String targetNamespace = "!0".equals(tableId) || "+r".equals(tableId) ? "+accumulo" : "+default";
                    log.debug("Upgrade moving table " + new String(zoo.getData(tables + "/" + tableId + "/name", null), StandardCharsets.UTF_8) + " (ID: " + tableId + ") into namespace with ID " + targetNamespace);
                    zoo.putPersistentData(tables + "/" + tableId + "/namespace", targetNamespace.getBytes(StandardCharsets.UTF_8), ZooUtil.NodeExistsPolicy.SKIP);
                }
                log.debug("Upgrade renaming table !METADATA (ID: !0) to accumulo.metadata");
                zoo.putPersistentData(tables + "/" + "!0" + "/name", ((String)Tables.qualify((String)"accumulo.metadata").getSecond()).getBytes(StandardCharsets.UTF_8), ZooUtil.NodeExistsPolicy.OVERWRITE);
                this.moveRootTabletToRootTable((IZooReaderWriter)zoo);
                ZKPermHandler perm = new ZKPermHandler();
                perm.initialize(this.getInstance().getInstanceID(), true);
                String users = ZooUtil.getRoot((Instance)this.getInstance()) + "/users";
                for (String user : zoo.getChildren(users)) {
                    zoo.putPersistentData(users + "/" + user + "/Namespaces", new byte[0], ZooUtil.NodeExistsPolicy.SKIP);
                    perm.grantNamespacePermission(user, "+accumulo", NamespacePermission.READ);
                }
                perm.grantNamespacePermission("root", "+accumulo", NamespacePermission.ALTER_TABLE);
                zoo.putPersistentData(ZooUtil.getRoot((Instance)this.getInstance()) + "/root_tablet/current_logs", new byte[0], ZooUtil.NodeExistsPolicy.SKIP);
                zoo.putPersistentData(ZooUtil.getRoot((Instance)this.getInstance()) + "/wals", new byte[0], ZooUtil.NodeExistsPolicy.SKIP);
                this.haveUpgradedZooKeeper = true;
            }
            catch (Exception ex) {
                log.error("FATAL: Error performing upgrade", (Throwable)ex);
                System.exit(1);
            }
        }
    }

    private void upgradeMetadata() {
        if (this.upgradeMetadataRunning.compareAndSet(false, true)) {
            final int accumuloPersistentVersion = Accumulo.getAccumuloPersistentVersion((VolumeManager)this.fs);
            if (Accumulo.persistentVersionNeedsUpgrade((int)accumuloPersistentVersion)) {
                if (!this.haveUpgradedZooKeeper) {
                    throw new IllegalStateException("We should only attempt to upgrade Accumulo's metadata table if we've already upgraded ZooKeeper. Please save all logs and file a bug.");
                }
                if (null != this.fate) {
                    throw new IllegalStateException("Access to Fate should not have been initialized prior to the Master finishing upgrades. Please save all logs and file a bug.");
                }
                Runnable upgradeTask = new Runnable(){
                    int version;
                    {
                        this.version = accumuloPersistentVersion;
                    }

                    @Override
                    public void run() {
                        try {
                            log.info("Starting to upgrade metadata table.");
                            if (this.version == 4) {
                                log.info("Updating Delete Markers in metadata table for version 1.4");
                                MetadataTableUtil.moveMetaDeleteMarkersFrom14((ClientContext)Master.this);
                                ++this.version;
                            }
                            if (this.version == 5) {
                                log.info("Updating Delete Markers in metadata table.");
                                MetadataTableUtil.moveMetaDeleteMarkers((ClientContext)Master.this);
                                ++this.version;
                            }
                            if (this.version == 6) {
                                log.info("Updating metadata table with entries for the replication table");
                                MetadataTableUtil.createReplicationTable((ClientContext)Master.this);
                                ++this.version;
                            }
                            log.info("Updating persistent data version.");
                            Accumulo.updateAccumuloVersion((VolumeManager)Master.this.fs, (int)accumuloPersistentVersion);
                            log.info("Upgrade complete");
                            Master.this.waitForMetadataUpgrade.countDown();
                        }
                        catch (Exception ex) {
                            log.error("FATAL: Error performing upgrade", (Throwable)ex);
                            System.exit(1);
                        }
                    }
                };
                new Thread(upgradeTask).start();
            } else {
                this.waitForMetadataUpgrade.countDown();
            }
        }
    }

    private int assignedOrHosted(String tableId) {
        int result = 0;
        for (TabletGroupWatcher watcher : this.watchers) {
            TableCounts count = watcher.getStats(tableId);
            result += count.hosted() + count.assigned();
        }
        return result;
    }

    private int totalAssignedOrHosted() {
        int result = 0;
        for (TabletGroupWatcher watcher : this.watchers) {
            for (TableCounts counts : watcher.getStats().values()) {
                result += counts.assigned() + counts.hosted();
            }
        }
        return result;
    }

    private int nonMetaDataTabletsAssignedOrHosted() {
        return this.totalAssignedOrHosted() - this.assignedOrHosted("!0") - this.assignedOrHosted("+r");
    }

    private int notHosted() {
        int result = 0;
        for (TabletGroupWatcher watcher : this.watchers) {
            for (TableCounts counts : watcher.getStats().values()) {
                result += counts.assigned() + counts.assignedToDeadServers() + counts.suspended();
            }
        }
        return result;
    }

    int displayUnassigned() {
        int result = 0;
        switch (this.getMasterState()) {
            case NORMAL: {
                for (TabletGroupWatcher watcher : this.watchers) {
                    TableManager manager = TableManager.getInstance();
                    for (Map.Entry<String, TableCounts> entry : watcher.getStats().entrySet()) {
                        String tableId = entry.getKey();
                        TableCounts counts = entry.getValue();
                        TableState tableState = manager.getTableState(tableId);
                        if (tableState == null || !tableState.equals((Object)TableState.ONLINE)) continue;
                        result += counts.unassigned() + counts.assignedToDeadServers() + counts.assigned() + counts.suspended();
                    }
                }
                break;
            }
            case SAFE_MODE: {
                for (TabletGroupWatcher watcher : this.watchers) {
                    TableCounts counts = watcher.getStats("!0");
                    result += counts.unassigned() + counts.suspended();
                }
                break;
            }
            case UNLOAD_METADATA_TABLETS: 
            case UNLOAD_ROOT_TABLET: {
                for (TabletGroupWatcher watcher : this.watchers) {
                    TableCounts counts = watcher.getStats("!0");
                    result += counts.unassigned() + counts.suspended();
                }
                break;
            }
        }
        return result;
    }

    public void mustBeOnline(String tableId) throws ThriftTableOperationException {
        Tables.clearCache((Instance)this.getInstance());
        if (!Tables.getTableState((Instance)this.getInstance(), (String)tableId).equals((Object)TableState.ONLINE)) {
            throw new ThriftTableOperationException(tableId, null, TableOperation.MERGE, TableOperationExceptionType.OFFLINE, "table is not online");
        }
    }

    public Master(ServerConfigurationFactory config, VolumeManager fs, String hostname) throws IOException {
        super(config);
        this.serverConfig = config;
        this.fs = fs;
        this.hostname = hostname;
        AccumuloConfiguration aconf = this.serverConfig.getConfiguration();
        log.info("Version 1.8.1");
        log.info("Instance " + this.getInstance().getInstanceID());
        this.timeKeeper = new MasterTime(this);
        ThriftTransportPool.getInstance().setIdleTime(aconf.getTimeInMillis(Property.GENERAL_RPC_TIMEOUT));
        this.tserverSet = new LiveTServerSet((ClientContext)this, (LiveTServerSet.Listener)this);
        this.tabletBalancer = (TabletBalancer)aconf.instantiateClassProperty(Property.MASTER_TABLET_BALANCER, TabletBalancer.class, (Object)new DefaultLoadBalancer());
        this.tabletBalancer.init(this.serverConfig);
        try {
            AccumuloVFSClassLoader.getContextManager().setContextConfig((ContextManager.ContextsConfig)new ContextManager.DefaultContextsConfig((Iterable)new Iterable<Map.Entry<String, String>>(){

                @Override
                public Iterator<Map.Entry<String, String>> iterator() {
                    return Master.this.getConfiguration().iterator();
                }
            }));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.security = AuditedSecurityOperation.getInstance((AccumuloServerContext)this);
        long tokenLifetime = aconf.getTimeInMillis(Property.GENERAL_DELEGATION_TOKEN_LIFETIME);
        this.setSecretManager(new AuthenticationTokenSecretManager(this.getInstance(), tokenLifetime));
        this.authenticationTokenKeyManager = null;
        this.keyDistributor = null;
        if (this.getConfiguration().getBoolean(Property.INSTANCE_RPC_SASL_ENABLED)) {
            log.info("SASL is enabled, creating delegation token key manager and distributor");
            long tokenUpdateInterval = aconf.getTimeInMillis(Property.GENERAL_DELEGATION_TOKEN_UPDATE_INTERVAL);
            this.keyDistributor = new ZooAuthenticationKeyDistributor(ZooReaderWriter.getInstance(), ZooUtil.getRoot((Instance)this.getInstance()) + "/delegation_token_keys");
            this.authenticationTokenKeyManager = new AuthenticationTokenKeyManager(this.getSecretManager(), this.keyDistributor, tokenUpdateInterval, tokenLifetime);
            this.delegationTokensAvailable = true;
        } else {
            log.info("SASL is not enabled, delegation tokens will not be available");
            this.delegationTokensAvailable = false;
        }
    }

    public LiveTServerSet.TServerConnection getConnection(TServerInstance server) {
        return this.tserverSet.getConnection(server);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MergeInfo getMergeInfo(String tableId) {
        Object object = this.mergeLock;
        synchronized (object) {
            try {
                String path = ZooUtil.getRoot((String)this.getInstance().getInstanceID()) + "/tables" + "/" + tableId + "/merge";
                if (!ZooReaderWriter.getInstance().exists(path)) {
                    return new MergeInfo();
                }
                byte[] data = ZooReaderWriter.getInstance().getData(path, new Stat());
                DataInputBuffer in = new DataInputBuffer();
                in.reset(data, data.length);
                MergeInfo info = new MergeInfo();
                info.readFields((DataInput)in);
                return info;
            }
            catch (KeeperException.NoNodeException ex) {
                log.info("Error reading merge state, it probably just finished");
                return new MergeInfo();
            }
            catch (Exception ex) {
                log.warn("Unexpected error reading merge state", (Throwable)ex);
                return new MergeInfo();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMergeState(MergeInfo info, MergeState state) throws IOException, KeeperException, InterruptedException {
        Object object = this.mergeLock;
        synchronized (object) {
            String path = ZooUtil.getRoot((String)this.getInstance().getInstanceID()) + "/tables" + "/" + info.getExtent().getTableId() + "/merge";
            info.setState(state);
            if (state.equals((Object)MergeState.NONE)) {
                ZooReaderWriter.getInstance().recursiveDelete(path, ZooUtil.NodeMissingPolicy.SKIP);
            } else {
                DataOutputBuffer out = new DataOutputBuffer();
                try {
                    info.write((DataOutput)out);
                }
                catch (IOException ex) {
                    throw new RuntimeException("Unlikely", ex);
                }
                ZooReaderWriter.getInstance().putPersistentData(path, out.getData(), state.equals((Object)MergeState.STARTED) ? ZooUtil.NodeExistsPolicy.FAIL : ZooUtil.NodeExistsPolicy.OVERWRITE);
            }
            this.mergeLock.notifyAll();
        }
        this.nextEvent.event("Merge state of %s set to %s", info.getExtent(), state);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearMergeState(String tableId) throws IOException, KeeperException, InterruptedException {
        Object object = this.mergeLock;
        synchronized (object) {
            String path = ZooUtil.getRoot((String)this.getInstance().getInstanceID()) + "/tables" + "/" + tableId + "/merge";
            ZooReaderWriter.getInstance().recursiveDelete(path, ZooUtil.NodeMissingPolicy.SKIP);
            this.mergeLock.notifyAll();
        }
        this.nextEvent.event("Merge state of %s cleared", tableId);
    }

    void setMasterGoalState(MasterGoalState state) {
        try {
            ZooReaderWriter.getInstance().putPersistentData(ZooUtil.getRoot((Instance)this.getInstance()) + "/masters/goal_state", state.name().getBytes(), ZooUtil.NodeExistsPolicy.OVERWRITE);
        }
        catch (Exception ex) {
            log.error("Unable to set master goal state in zookeeper");
        }
    }

    MasterGoalState getMasterGoalState() {
        while (true) {
            try {
                byte[] data = ZooReaderWriter.getInstance().getData(ZooUtil.getRoot((Instance)this.getInstance()) + "/masters/goal_state", null);
                return MasterGoalState.valueOf((String)new String(data));
            }
            catch (Exception e) {
                log.error("Problem getting real goal state from zookeeper: " + e);
                Uninterruptibles.sleepUninterruptibly((long)1L, (TimeUnit)TimeUnit.SECONDS);
                continue;
            }
            break;
        }
    }

    public boolean hasCycled(long time) {
        for (TabletGroupWatcher watcher : this.watchers) {
            if (watcher.stats.lastScanFinished() >= time) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearMigrations(String tableId) {
        SortedMap<KeyExtent, TServerInstance> sortedMap = this.migrations;
        synchronized (sortedMap) {
            Iterator<KeyExtent> iterator = this.migrations.keySet().iterator();
            while (iterator.hasNext()) {
                KeyExtent extent = iterator.next();
                if (!extent.getTableId().equals(tableId)) continue;
                iterator.remove();
            }
        }
    }

    TabletGoalState getSystemGoalState(TabletLocationState tls) {
        switch (this.getMasterState()) {
            case NORMAL: {
                return TabletGoalState.HOSTED;
            }
            case SAFE_MODE: 
            case HAVE_LOCK: 
            case INITIAL: {
                if (tls.extent.isMeta()) {
                    return TabletGoalState.HOSTED;
                }
                return TabletGoalState.UNASSIGNED;
            }
            case UNLOAD_METADATA_TABLETS: {
                if (tls.extent.isRootTablet()) {
                    return TabletGoalState.HOSTED;
                }
                return TabletGoalState.UNASSIGNED;
            }
            case UNLOAD_ROOT_TABLET: {
                return TabletGoalState.UNASSIGNED;
            }
            case STOP: {
                return TabletGoalState.UNASSIGNED;
            }
        }
        throw new IllegalStateException("Unknown Master State");
    }

    TabletGoalState getTableGoalState(KeyExtent extent) {
        TableState tableState = TableManager.getInstance().getTableState(extent.getTableId());
        if (tableState == null) {
            return TabletGoalState.DELETED;
        }
        switch (tableState) {
            case DELETING: {
                return TabletGoalState.DELETED;
            }
            case OFFLINE: 
            case NEW: {
                return TabletGoalState.UNASSIGNED;
            }
        }
        return TabletGoalState.HOSTED;
    }

    TabletGoalState getGoalState(TabletLocationState tls, MergeInfo mergeInfo) {
        KeyExtent extent = tls.extent;
        TabletGoalState state = this.getSystemGoalState(tls);
        if (state == TabletGoalState.HOSTED) {
            TServerInstance dest;
            if (tls.current != null && this.serversToShutdown.contains(tls.current)) {
                return TabletGoalState.SUSPENDED;
            }
            if (mergeInfo.getExtent() != null) {
                log.debug("mergeInfo overlaps: " + extent + " " + mergeInfo.overlaps(extent));
                if (mergeInfo.overlaps(extent)) {
                    switch (mergeInfo.getState()) {
                        case NONE: 
                        case COMPLETE: {
                            break;
                        }
                        case STARTED: 
                        case SPLITTING: {
                            return TabletGoalState.HOSTED;
                        }
                        case WAITING_FOR_CHOPPED: {
                            if (tls.getState(this.tserverSet.getCurrentServers()).equals((Object)TabletState.HOSTED) ? tls.chopped : tls.chopped && tls.walogs.isEmpty()) {
                                return TabletGoalState.UNASSIGNED;
                            }
                            return TabletGoalState.HOSTED;
                        }
                        case WAITING_FOR_OFFLINE: 
                        case MERGING: {
                            return TabletGoalState.UNASSIGNED;
                        }
                    }
                }
            }
            if ((state = this.getTableGoalState(extent)) == TabletGoalState.HOSTED && (dest = (TServerInstance)this.migrations.get(extent)) != null && tls.current != null && !dest.equals((Object)tls.current)) {
                return TabletGoalState.UNASSIGNED;
            }
        }
        return state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SortedMap<TServerInstance, TabletServerStatus> gatherTableInformation(Set<TServerInstance> currentServers) {
        long start = System.currentTimeMillis();
        int threads = Math.max(this.getConfiguration().getCount(Property.MASTER_STATUS_THREAD_POOL_SIZE), 1);
        ExecutorService tp = Executors.newFixedThreadPool(threads);
        final TreeMap<TServerInstance, TabletServerStatus> result = new TreeMap<TServerInstance, TabletServerStatus>();
        Iterator<TServerInstance> i$ = currentServers.iterator();
        while (i$.hasNext()) {
            TServerInstance serverInstance;
            final TServerInstance server = serverInstance = i$.next();
            tp.submit(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    block10: {
                        try {
                            Thread t = Thread.currentThread();
                            String oldName = t.getName();
                            try {
                                t.setName("Getting status from " + server);
                                LiveTServerSet.TServerConnection connection = Master.this.tserverSet.getConnection(server);
                                if (connection == null) {
                                    throw new IOException("No connection to " + server);
                                }
                                TabletServerStatus status = connection.getTableMap(false);
                                result.put(server, status);
                            }
                            finally {
                                t.setName(oldName);
                            }
                        }
                        catch (Exception ex) {
                            log.error("unable to get tablet server status " + server + " " + ex.toString());
                            log.debug("unable to get tablet server status " + server, (Throwable)ex);
                            if (Master.this.badServers.get(server).incrementAndGet() <= 3) break block10;
                            log.warn("attempting to stop " + server);
                            try {
                                LiveTServerSet.TServerConnection connection = Master.this.tserverSet.getConnection(server);
                                if (connection != null) {
                                    connection.halt(Master.this.masterLock);
                                }
                            }
                            catch (TTransportException connection) {
                            }
                            catch (Exception e) {
                                log.info("error talking to troublesome tablet server ", (Throwable)e);
                            }
                            Master.this.badServers.remove(server);
                        }
                    }
                }
            });
        }
        tp.shutdown();
        try {
            tp.awaitTermination(this.getConfiguration().getTimeInMillis(Property.TSERV_CLIENT_TIMEOUT) * 2L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            log.debug("Interrupted while fetching status");
        }
        Map<TServerInstance, AtomicInteger> map = this.badServers;
        synchronized (map) {
            this.badServers.keySet().retainAll(currentServers);
            this.badServers.keySet().removeAll(result.keySet());
        }
        log.debug(String.format("Finished gathering information from %d servers in %.2f seconds", result.size(), (double)(System.currentTimeMillis() - start) / 1000.0));
        return result;
    }

    public void run() throws IOException, InterruptedException, KeeperException {
        MasterClientService.Processor processor;
        final String zroot = ZooUtil.getRoot((Instance)this.getInstance());
        this.getMasterLock(zroot + "/masters/lock");
        this.recoveryManager = new RecoveryManager(this);
        TableManager.getInstance().addObserver((TableObserver)this);
        StatusThread statusThread = new StatusThread();
        statusThread.start();
        MigrationCleanupThread migrationCleanupThread = new MigrationCleanupThread();
        migrationCleanupThread.start();
        this.tserverSet.startListeningForTabletServerChanges();
        ZooReaderWriter zReaderWriter = ZooReaderWriter.getInstance();
        zReaderWriter.getChildren(zroot + "/recovery", new Watcher(){

            public void process(WatchedEvent event) {
                Master.this.nextEvent.event("Noticed recovery changes", event.getType());
                try {
                    ZooReaderWriter.getInstance().getChildren(zroot + "/recovery", (Watcher)this);
                }
                catch (Exception e) {
                    log.error("Failed to add log recovery watcher back", (Throwable)e);
                }
            }
        });
        this.watchers.add(new TabletGroupWatcher(this, (TabletStateStore)new MetaDataStateStore((ClientContext)this, (CurrentState)this), null){

            @Override
            boolean canSuspendTablets() {
                return true;
            }
        });
        this.watchers.add(new TabletGroupWatcher(this, (TabletStateStore)new RootTabletStateStore((ClientContext)this, (CurrentState)this), this.watchers.get(0)){

            @Override
            boolean canSuspendTablets() {
                return Master.this.getConfiguration().getBoolean(Property.MASTER_METADATA_SUSPENDABLE);
            }
        });
        this.watchers.add(new TabletGroupWatcher(this, (TabletStateStore)new ZooTabletStateStore((DistributedStore)new org.apache.accumulo.server.master.state.ZooStore(zroot)), this.watchers.get(1)){

            @Override
            boolean canSuspendTablets() {
                return false;
            }
        });
        for (TabletGroupWatcher watcher : this.watchers) {
            watcher.start();
        }
        this.waitForMetadataUpgrade.await();
        try {
            final AgeOffStore store = new AgeOffStore((TStore)new ZooStore(ZooUtil.getRoot((Instance)this.getInstance()) + "/fate", (IZooReaderWriter)ZooReaderWriter.getInstance()), 28800000L);
            int threads = this.getConfiguration().getCount(Property.MASTER_FATE_THREADPOOL_SIZE);
            this.fate = new Fate((Object)this, (TStore)store);
            this.fate.startTransactionRunners(threads);
            SimpleTimer.getInstance((AccumuloConfiguration)this.getConfiguration()).schedule(new Runnable(){

                @Override
                public void run() {
                    store.ageOff();
                }
            }, 63000L, 63000L);
        }
        catch (KeeperException e) {
            throw new IOException(e);
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
        ZooKeeperInitialization.ensureZooKeeperInitialized((ZooReaderWriter)zReaderWriter, (String)zroot);
        if (null != this.authenticationTokenKeyManager && null != this.keyDistributor) {
            log.info("Starting delegation-token key manager");
            this.keyDistributor.initialize();
            this.authenticationTokenKeyManager.start();
            boolean logged = false;
            while (!this.authenticationTokenKeyManager.isInitialized()) {
                if (!logged) {
                    log.info("Waiting for AuthenticationTokenKeyManager to be initialized");
                    logged = true;
                }
                Uninterruptibles.sleepUninterruptibly((long)200L, (TimeUnit)TimeUnit.MILLISECONDS);
            }
            log.info("AuthenticationTokenSecretManager is initialized");
        }
        this.clientHandler = new MasterClientServiceHandler(this);
        MasterClientService.Iface rpcProxy = (MasterClientService.Iface)RpcWrapper.service((Object)this.clientHandler, (TBaseProcessor)new MasterClientService.Processor((MasterClientService.Iface)this.clientHandler));
        if (ThriftServerType.SASL == this.getThriftServerType()) {
            MasterClientService.Iface tcredsProxy = (MasterClientService.Iface)TCredentialsUpdatingWrapper.service((Object)rpcProxy, this.clientHandler.getClass(), (AccumuloConfiguration)this.getConfiguration());
            processor = new MasterClientService.Processor(tcredsProxy);
        } else {
            processor = new MasterClientService.Processor(rpcProxy);
        }
        ServerAddress sa = TServerUtils.startServer((AccumuloServerContext)this, (String)this.hostname, (Property)Property.MASTER_CLIENTPORT, (TProcessor)processor, (String)"Master", (String)"Master Client Service Handler", null, (Property)Property.MASTER_MINTHREADS, (Property)Property.MASTER_THREADCHECK, (Property)Property.GENERAL_MAX_MESSAGE_SIZE);
        this.clientService = sa.server;
        String address = sa.address.toString();
        log.info("Setting master lock data to " + address);
        this.masterLock.replaceLockData(address.getBytes());
        while (!this.clientService.isServing()) {
            Uninterruptibles.sleepUninterruptibly((long)100L, (TimeUnit)TimeUnit.MILLISECONDS);
        }
        this.replicationWorkDriver = new ReplicationDriver(this);
        this.replicationWorkDriver.start();
        try {
            this.replicationWorkAssigner = new WorkDriver(this);
        }
        catch (AccumuloException | AccumuloSecurityException e) {
            log.error("Caught exception trying to initialize replication WorkDriver", e);
            throw new RuntimeException(e);
        }
        this.replicationWorkAssigner.start();
        MasterReplicationCoordinator impl = new MasterReplicationCoordinator(this);
        ReplicationCoordinator.Processor replicationCoordinatorProcessor = new ReplicationCoordinator.Processor((ReplicationCoordinator.Iface)RpcWrapper.service((Object)impl, (TBaseProcessor)new ReplicationCoordinator.Processor((ReplicationCoordinator.Iface)impl)));
        ServerAddress replAddress = TServerUtils.startServer((AccumuloServerContext)this, (String)this.hostname, (Property)Property.MASTER_REPLICATION_COORDINATOR_PORT, (TProcessor)replicationCoordinatorProcessor, (String)"Master Replication Coordinator", (String)"Replication Coordinator", null, (Property)Property.MASTER_REPLICATION_COORDINATOR_MINTHREADS, (Property)Property.MASTER_REPLICATION_COORDINATOR_THREADCHECK, (Property)Property.GENERAL_MAX_MESSAGE_SIZE);
        log.info("Started replication coordinator service at " + replAddress.address);
        ZooReaderWriter.getInstance().putPersistentData(ZooUtil.getRoot((Instance)this.getInstance()) + "/masters/repl_coord_addr", replAddress.address.toString().getBytes(StandardCharsets.UTF_8), ZooUtil.NodeExistsPolicy.OVERWRITE);
        MasterMetricsFactory factory = new MasterMetricsFactory(this.getConfiguration(), this);
        Metrics replicationMetrics = factory.createReplicationMetrics();
        try {
            replicationMetrics.register();
        }
        catch (Exception e) {
            log.error("Failed to register replication metrics", (Throwable)e);
        }
        while (this.clientService.isServing()) {
            Uninterruptibles.sleepUninterruptibly((long)500L, (TimeUnit)TimeUnit.MILLISECONDS);
        }
        log.info("Shutting down fate.");
        this.fate.shutdown();
        log.info("Shutting down timekeeping.");
        this.timeKeeper.shutdown();
        long deadline = System.currentTimeMillis() + 1000L;
        statusThread.join(this.remaining(deadline));
        this.replicationWorkAssigner.join(this.remaining(deadline));
        this.replicationWorkDriver.join(this.remaining(deadline));
        replAddress.server.stop();
        if (this.authenticationTokenKeyManager != null) {
            this.authenticationTokenKeyManager.gracefulStop();
            this.authenticationTokenKeyManager.join(this.remaining(deadline));
        }
        for (TabletGroupWatcher watcher : this.watchers) {
            watcher.join(this.remaining(deadline));
        }
        log.info("exiting");
    }

    private long remaining(long deadline) {
        return Math.max(1L, deadline - System.currentTimeMillis());
    }

    public ZooLock getMasterLock() {
        return this.masterLock;
    }

    private void getMasterLock(String zMasterLoc) throws KeeperException, InterruptedException {
        log.info("trying to get master lock");
        String masterClientAddress = this.hostname + ":" + this.getConfiguration().getPort(Property.MASTER_CLIENTPORT)[0];
        while (true) {
            MasterLockWatcher masterLockWatcher = new MasterLockWatcher();
            this.masterLock = new ZooLock(zMasterLoc);
            this.masterLock.lockAsync((ZooLock.AsyncLockWatcher)masterLockWatcher, masterClientAddress.getBytes());
            masterLockWatcher.waitForChange();
            if (masterLockWatcher.acquiredLock) break;
            if (!masterLockWatcher.failedToAcquireLock) {
                throw new IllegalStateException("master lock in unknown state");
            }
            this.masterLock.tryToCancelAsyncLockOrUnlock();
            Uninterruptibles.sleepUninterruptibly((long)1000L, (TimeUnit)TimeUnit.MILLISECONDS);
        }
        this.setMasterState(MasterState.HAVE_LOCK);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        try {
            String app = "master";
            Accumulo.setupLogging((String)"master");
            SecurityUtil.serverLogin((AccumuloConfiguration)SiteConfiguration.getInstance());
            ServerOpts opts = new ServerOpts();
            opts.parseArgs("master", args, new Object[0]);
            String hostname = opts.getAddress();
            ServerConfigurationFactory conf = new ServerConfigurationFactory(HdfsZooInstance.getInstance());
            VolumeManager fs = VolumeManagerImpl.get();
            Accumulo.init((VolumeManager)fs, (ServerConfigurationFactory)conf, (String)"master");
            Master master = new Master(conf, fs, hostname);
            DistributedTrace.enable((String)hostname, (String)"master", (AccumuloConfiguration)conf.getConfiguration());
            master.run();
        }
        catch (Exception ex) {
            log.error("Unexpected exception, exiting", (Throwable)ex);
            System.exit(1);
        }
        finally {
            DistributedTrace.disable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(LiveTServerSet current, Set<TServerInstance> deleted, Set<TServerInstance> added) {
        DeadServerList obit = new DeadServerList(ZooUtil.getRoot((Instance)this.getInstance()) + "/dead/tservers");
        if (added.size() > 0) {
            log.info("New servers: " + added);
            for (TServerInstance up : added) {
                obit.delete(up.hostPort());
            }
        }
        for (TServerInstance dead : deleted) {
            String cause = "unexpected failure";
            if (this.serversToShutdown.contains(dead)) {
                cause = "clean shutdown";
            }
            if (this.getMasterGoalState().equals((Object)MasterGoalState.CLEAN_STOP)) continue;
            obit.post(dead.hostPort(), cause);
        }
        HashSet<TServerInstance> unexpected = new HashSet<TServerInstance>(deleted);
        unexpected.removeAll(this.serversToShutdown);
        if (unexpected.size() > 0 && this.stillMaster() && !this.getMasterGoalState().equals((Object)MasterGoalState.CLEAN_STOP)) {
            log.warn("Lost servers " + unexpected);
        }
        this.serversToShutdown.removeAll(deleted);
        this.badServers.keySet().removeAll(deleted);
        SortedMap<KeyExtent, TServerInstance> sortedMap = this.badServers;
        synchronized (sortedMap) {
            Master.cleanListByHostAndPort(this.badServers.keySet(), deleted, added);
        }
        sortedMap = this.serversToShutdown;
        synchronized (sortedMap) {
            Master.cleanListByHostAndPort(this.serversToShutdown, deleted, added);
        }
        sortedMap = this.migrations;
        synchronized (sortedMap) {
            Iterator<Map.Entry<KeyExtent, TServerInstance>> iter = this.migrations.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry<KeyExtent, TServerInstance> entry = iter.next();
                if (!deleted.contains(entry.getValue())) continue;
                log.info("Canceling migration of " + entry.getKey() + " to " + entry.getValue());
                iter.remove();
            }
        }
        this.nextEvent.event("There are now %d tablet servers", current.size());
    }

    private static void cleanListByHostAndPort(Collection<TServerInstance> badServers, Set<TServerInstance> deleted, Set<TServerInstance> added) {
        Iterator<TServerInstance> badIter = badServers.iterator();
        block0: while (badIter.hasNext()) {
            TServerInstance bad = badIter.next();
            for (TServerInstance add : added) {
                if (!bad.hostPort().equals(add.hostPort())) continue;
                badIter.remove();
                break;
            }
            for (TServerInstance del : deleted) {
                if (!bad.hostPort().equals(del.hostPort())) continue;
                badIter.remove();
                continue block0;
            }
        }
    }

    public void stateChanged(String tableId, TableState state) {
        this.nextEvent.event("Table state in zookeeper changed for %s to %s", tableId, state);
        if (TableState.OFFLINE == state) {
            this.clearMigrations(tableId);
        }
    }

    public void initialize(Map<String, TableState> tableIdToStateMap) {
    }

    public void sessionExpired() {
    }

    public Set<String> onlineTables() {
        HashSet<String> result = new HashSet<String>();
        if (this.getMasterState() != MasterState.NORMAL) {
            if (this.getMasterState() != MasterState.UNLOAD_METADATA_TABLETS) {
                result.add("!0");
            }
            if (this.getMasterState() != MasterState.UNLOAD_ROOT_TABLET) {
                result.add("+r");
            }
            return result;
        }
        TableManager manager = TableManager.getInstance();
        for (String tableId : Tables.getIdToNameMap((Instance)this.getInstance()).keySet()) {
            TableState state = manager.getTableState(tableId);
            if (state == null || state != TableState.ONLINE) continue;
            result.add(tableId);
        }
        return result;
    }

    public Set<TServerInstance> onlineTabletServers() {
        return this.tserverSet.getCurrentServers();
    }

    public Collection<MergeInfo> merges() {
        ArrayList<MergeInfo> result = new ArrayList<MergeInfo>();
        for (String tableId : Tables.getIdToNameMap((Instance)this.getInstance()).keySet()) {
            result.add(this.getMergeInfo(tableId));
        }
        return result;
    }

    public void shutdownTServer(TServerInstance server) {
        this.nextEvent.event("Tablet Server shutdown requested for %s", server);
        this.serversToShutdown.add(server);
    }

    public EventCoordinator getEventCoordinator() {
        return this.nextEvent;
    }

    public ServerConfigurationFactory getConfigurationFactory() {
        return this.serverConfig;
    }

    public VolumeManager getFileSystem() {
        return this.fs;
    }

    public void assignedTablet(KeyExtent extent) {
        if (extent.isMeta() && this.getMasterState().equals((Object)MasterState.UNLOAD_ROOT_TABLET)) {
            this.setMasterState(MasterState.UNLOAD_METADATA_TABLETS);
        }
        if (extent.isRootTablet() && this.getMasterState().equals((Object)MasterState.STOP)) {
            this.setMasterState(MasterState.UNLOAD_ROOT_TABLET);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForBalance(TInfo tinfo) {
        Object object = this.balancedNotifier;
        synchronized (object) {
            long eventCounter;
            do {
                eventCounter = this.nextEvent.waitForEvents(0L, 0L);
                try {
                    this.balancedNotifier.wait();
                }
                catch (InterruptedException e) {
                    log.debug(e.toString(), (Throwable)e);
                }
            } while (this.displayUnassigned() > 0 || this.migrations.size() > 0 || eventCounter != this.nextEvent.waitForEvents(0L, 0L));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MasterMonitorInfo getMasterMonitorInfo() {
        MasterMonitorInfo result = new MasterMonitorInfo();
        result.tServerInfo = new ArrayList();
        result.tableMap = new DefaultMap((Object)new TableInfo());
        for (Map.Entry<TServerInstance, TabletServerStatus> serverEntry : this.tserverStatus.entrySet()) {
            TabletServerStatus status = serverEntry.getValue();
            result.tServerInfo.add(status);
            for (Map.Entry entry : status.tableMap.entrySet()) {
                TableInfoUtil.add((TableInfo)((TableInfo)result.tableMap.get(entry.getKey())), (TableInfo)((TableInfo)entry.getValue()));
            }
        }
        result.badTServers = new HashMap();
        Set<TServerInstance> i$ = this.badServers;
        synchronized (i$) {
            for (TServerInstance bad : this.badServers.keySet()) {
                result.badTServers.put(bad.hostPort(), TabletServerState.UNRESPONSIVE.getId());
            }
        }
        result.state = this.getMasterState();
        result.goalState = this.getMasterGoalState();
        result.unassignedTablets = this.displayUnassigned();
        result.serversShuttingDown = new HashSet();
        i$ = this.serversToShutdown;
        synchronized (i$) {
            for (TServerInstance server : this.serversToShutdown) {
                result.serversShuttingDown.add(server.hostPort());
            }
        }
        DeadServerList obit = new DeadServerList(ZooUtil.getRoot((Instance)this.getInstance()) + "/dead/tservers");
        result.deadTabletServers = obit.getList();
        result.bulkImports = this.bulkImportStatus.getBulkLoadStatus();
        return result;
    }

    public boolean delegationTokensAvailable() {
        return this.delegationTokensAvailable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<KeyExtent> migrationsSnapshot() {
        HashSet<KeyExtent> migrationKeys = new HashSet<KeyExtent>();
        SortedMap<KeyExtent, TServerInstance> sortedMap = this.migrations;
        synchronized (sortedMap) {
            migrationKeys.addAll(this.migrations.keySet());
        }
        return Collections.unmodifiableSet(migrationKeys);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<TServerInstance> shutdownServers() {
        Set<TServerInstance> set = this.serversToShutdown;
        synchronized (set) {
            return new HashSet<TServerInstance>(this.serversToShutdown);
        }
    }

    public void markDeadServerLogsAsClosed(Map<TServerInstance, List<Path>> logsForDeadServers) throws WalStateManager.WalMarkerException {
        WalStateManager mgr = new WalStateManager(this.inst, ZooReaderWriter.getInstance());
        for (Map.Entry<TServerInstance, List<Path>> server : logsForDeadServers.entrySet()) {
            for (Path path : server.getValue()) {
                mgr.closeWal(server.getKey(), path);
            }
        }
    }

    public void updateBulkImportStatus(String directory, BulkImportState state) {
        this.bulkImportStatus.updateBulkImportStatus(Collections.singletonList(directory), state);
    }

    public void removeBulkImportStatus(String directory) {
        this.bulkImportStatus.removeBulkImportStatus(Collections.singletonList(directory));
    }

    public Long getSteadyTime() {
        return this.timeKeeper.getTime();
    }

    private static class MasterLockWatcher
    implements ZooLock.AsyncLockWatcher {
        boolean acquiredLock = false;
        boolean failedToAcquireLock = false;

        private MasterLockWatcher() {
        }

        public void lostLock(ZooLock.LockLossReason reason) {
            Halt.halt((String)("Master lock in zookeeper lost (reason = " + reason + "), exiting!"), (int)-1);
        }

        public void unableToMonitorLockNode(final Throwable e) {
            Halt.halt((int)-1, (Runnable)new Runnable(){

                @Override
                public void run() {
                    log.error("FATAL: No longer able to monitor master lock node", e);
                }
            });
        }

        public synchronized void acquiredLock() {
            log.debug("Acquired master lock");
            if (this.acquiredLock || this.failedToAcquireLock) {
                Halt.halt((String)("Zoolock in unexpected state AL " + this.acquiredLock + " " + this.failedToAcquireLock), (int)-1);
            }
            this.acquiredLock = true;
            this.notifyAll();
        }

        public synchronized void failedToAcquireLock(Exception e) {
            log.warn("Failed to get master lock " + e);
            if (e instanceof KeeperException.NoAuthException) {
                String msg = "Failed to acquire master lock due to incorrect ZooKeeper authentication.";
                log.error(msg + " Ensure instance.secret is consistent across Accumulo configuration", (Throwable)e);
                Halt.halt((String)msg, (int)-1);
            }
            if (this.acquiredLock) {
                Halt.halt((String)("Zoolock in unexpected state FAL " + this.acquiredLock + " " + this.failedToAcquireLock), (int)-1);
            }
            this.failedToAcquireLock = true;
            this.notifyAll();
        }

        public synchronized void waitForChange() {
            while (!this.acquiredLock && !this.failedToAcquireLock) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    private class StatusThread
    extends Daemon {
        private StatusThread() {
        }

        private boolean goodStats() {
            switch (Master.this.getMasterState()) {
                case UNLOAD_METADATA_TABLETS: {
                    int start = 1;
                    break;
                }
                case UNLOAD_ROOT_TABLET: {
                    int start = 2;
                    break;
                }
                default: {
                    int start = 0;
                }
            }
            for (int i = start; i < Master.this.watchers.size(); ++i) {
                TabletGroupWatcher watcher = (TabletGroupWatcher)((Object)Master.this.watchers.get(i));
                if (watcher.stats.getLastMasterState() == Master.this.getMasterState()) continue;
                log.debug(watcher.getName() + ": " + watcher.stats.getLastMasterState() + " != " + Master.this.getMasterState());
                return false;
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            this.setName("Status Thread");
            EventCoordinator.Listener eventListener = Master.this.nextEvent.getListener();
            while (Master.this.stillMaster()) {
                long wait = 10000L;
                try {
                    switch (Master.this.getMasterGoalState()) {
                        case NORMAL: {
                            Master.this.setMasterState(MasterState.NORMAL);
                            break;
                        }
                        case SAFE_MODE: {
                            if (Master.this.getMasterState() == MasterState.NORMAL) {
                                Master.this.setMasterState(MasterState.SAFE_MODE);
                            }
                            if (Master.this.getMasterState() == MasterState.HAVE_LOCK) {
                                Master.this.setMasterState(MasterState.SAFE_MODE);
                            }
                            break;
                        }
                        case CLEAN_STOP: {
                            switch (Master.this.getMasterState()) {
                                case NORMAL: {
                                    Master.this.setMasterState(MasterState.SAFE_MODE);
                                    break;
                                }
                                case SAFE_MODE: {
                                    int count = Master.this.nonMetaDataTabletsAssignedOrHosted();
                                    log.debug(String.format("There are %d non-metadata tablets assigned or hosted", count));
                                    if (count != 0 || !this.goodStats()) break;
                                    Master.this.setMasterState(MasterState.UNLOAD_METADATA_TABLETS);
                                    break;
                                }
                                case UNLOAD_METADATA_TABLETS: {
                                    int count = Master.this.assignedOrHosted("!0");
                                    log.debug(String.format("There are %d metadata tablets assigned or hosted", count));
                                    if (count != 0 || !this.goodStats()) break;
                                    Master.this.setMasterState(MasterState.UNLOAD_ROOT_TABLET);
                                    break;
                                }
                                case UNLOAD_ROOT_TABLET: {
                                    int root_count;
                                    int count = Master.this.assignedOrHosted("!0");
                                    if (count > 0 && this.goodStats()) {
                                        log.debug(String.format("%d metadata tablets online", count));
                                        Master.this.setMasterState(MasterState.UNLOAD_ROOT_TABLET);
                                    }
                                    if ((root_count = Master.this.assignedOrHosted("+r")) > 0 && this.goodStats()) {
                                        log.debug("The root tablet is still assigned or hosted");
                                    }
                                    if (count + root_count != 0 || !this.goodStats()) break;
                                    Set currentServers = Master.this.tserverSet.getCurrentServers();
                                    log.debug("stopping " + currentServers.size() + " tablet servers");
                                    for (TServerInstance server : currentServers) {
                                        try {
                                            Master.this.serversToShutdown.add(server);
                                            Master.this.tserverSet.getConnection(server).fastHalt(Master.this.masterLock);
                                        }
                                        catch (TException tException) {}
                                        continue;
                                        finally {
                                            Master.this.tserverSet.remove(server);
                                        }
                                    }
                                    if (currentServers.size() != 0) break;
                                    Master.this.setMasterState(MasterState.STOP);
                                    break;
                                }
                            }
                            break;
                        }
                    }
                }
                catch (Throwable t) {
                    log.error("Error occurred reading / switching master goal state. Will continue with attempt to update status", t);
                }
                try {
                    wait = this.updateStatus();
                    eventListener.waitForEvents(wait);
                }
                catch (Throwable t) {
                    log.error("Error balancing tablets, will wait for 1 (seconds) and then retry", t);
                    Uninterruptibles.sleepUninterruptibly((long)1000L, (TimeUnit)TimeUnit.MILLISECONDS);
                    continue;
                }
                break;
            }
            return;
        }

        private long updateStatus() throws AccumuloException, AccumuloSecurityException, TableNotFoundException {
            Set currentServers = Master.this.tserverSet.getCurrentServers();
            Master.this.tserverStatus = Collections.synchronizedSortedMap(Master.this.gatherTableInformation(currentServers));
            this.checkForHeldServer(Master.this.tserverStatus);
            if (!Master.this.badServers.isEmpty()) {
                log.debug("not balancing because the balance information is out-of-date " + Master.this.badServers.keySet());
            } else if (Master.this.notHosted() > 0) {
                log.debug("not balancing because there are unhosted tablets: " + Master.this.notHosted());
            } else if (Master.this.getMasterGoalState() == MasterGoalState.CLEAN_STOP) {
                log.debug("not balancing because the master is attempting to stop cleanly");
            } else if (!Master.this.serversToShutdown.isEmpty()) {
                log.debug("not balancing while shutting down servers " + Master.this.serversToShutdown);
            } else {
                for (TabletGroupWatcher tgw : Master.this.watchers) {
                    if (tgw.isSameTserversAsLastScan(currentServers)) continue;
                    log.debug("not balancing just yet, as collection of live tservers is in flux");
                    return 10000L;
                }
                return this.balanceTablets();
            }
            return 10000L;
        }

        private void checkForHeldServer(SortedMap<TServerInstance, TabletServerStatus> tserverStatus) {
            TServerInstance instance = null;
            int crazyHoldTime = 0;
            int someHoldTime = 0;
            long maxWait = Master.this.getConfiguration().getTimeInMillis(Property.TSERV_HOLD_TIME_SUICIDE);
            for (Map.Entry<TServerInstance, TabletServerStatus> entry : tserverStatus.entrySet()) {
                if (entry.getValue().getHoldTime() <= 0L) continue;
                ++someHoldTime;
                if (entry.getValue().getHoldTime() <= maxWait) continue;
                instance = entry.getKey();
                ++crazyHoldTime;
            }
            if (crazyHoldTime == 1 && someHoldTime == 1 && tserverStatus.size() > 1) {
                log.warn("Tablet server " + instance + " exceeded maximum hold time: attempting to kill it");
                try {
                    LiveTServerSet.TServerConnection connection = Master.this.tserverSet.getConnection(instance);
                    if (connection != null) {
                        connection.fastHalt(Master.this.masterLock);
                    }
                }
                catch (TException e) {
                    log.error("{}", (Object)e.getMessage(), (Object)e);
                }
                Master.this.tserverSet.remove(instance);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private long balanceTablets() {
            ArrayList migrationsOut = new ArrayList();
            long wait = Master.this.tabletBalancer.balance(Collections.unmodifiableSortedMap(Master.this.tserverStatus), Master.this.migrationsSnapshot(), migrationsOut);
            for (TabletMigration m : TabletBalancer.checkMigrationSanity(Master.this.tserverStatus.keySet(), migrationsOut)) {
                if (Master.this.migrations.containsKey(m.tablet)) {
                    log.warn("balancer requested migration more than once, skipping " + m);
                    continue;
                }
                Master.this.migrations.put(m.tablet, m.newServer);
                log.debug("migration " + m);
            }
            if (migrationsOut.size() > 0) {
                Master.this.nextEvent.event("Migrating %d more tablets, %d total", migrationsOut.size(), Master.this.migrations.size());
            } else {
                Object object = Master.this.balancedNotifier;
                synchronized (object) {
                    Master.this.balancedNotifier.notifyAll();
                }
            }
            return wait;
        }
    }

    private class MigrationCleanupThread
    extends Daemon {
        private MigrationCleanupThread() {
        }

        public void run() {
            this.setName("Migration Cleanup Thread");
            while (Master.this.stillMaster()) {
                if (!Master.this.migrations.isEmpty()) {
                    try {
                        this.cleanupOfflineMigrations();
                        this.cleanupNonexistentMigrations(Master.this.getConnector());
                    }
                    catch (Exception ex) {
                        log.error("Error cleaning up migrations", (Throwable)ex);
                    }
                }
                Uninterruptibles.sleepUninterruptibly((long)300000L, (TimeUnit)TimeUnit.MILLISECONDS);
            }
        }

        private void cleanupNonexistentMigrations(Connector connector) throws AccumuloException, AccumuloSecurityException, TableNotFoundException {
            Scanner scanner = connector.createScanner("accumulo.metadata", Authorizations.EMPTY);
            MetadataSchema.TabletsSection.TabletColumnFamily.PREV_ROW_COLUMN.fetch((ScannerBase)scanner);
            HashSet<KeyExtent> found = new HashSet<KeyExtent>();
            for (Map.Entry entry : scanner) {
                KeyExtent extent = new KeyExtent(((Key)entry.getKey()).getRow(), (Value)entry.getValue());
                if (!Master.this.migrations.containsKey(extent)) continue;
                found.add(extent);
            }
            Master.this.migrations.keySet().retainAll(found);
        }

        private void cleanupOfflineMigrations() {
            TableManager manager = TableManager.getInstance();
            for (String tableId : Tables.getIdToNameMap((Instance)Master.this.getInstance()).keySet()) {
                TableState state = manager.getTableState(tableId);
                if (TableState.OFFLINE != state) continue;
                Master.this.clearMigrations(tableId);
            }
        }
    }

    static enum TabletGoalState {
        HOSTED(TUnloadTabletGoal.UNKNOWN),
        UNASSIGNED(TUnloadTabletGoal.UNASSIGNED),
        DELETED(TUnloadTabletGoal.DELETED),
        SUSPENDED(TUnloadTabletGoal.SUSPENDED);

        private final TUnloadTabletGoal unloadGoal;

        private TabletGoalState(TUnloadTabletGoal unloadGoal) {
            this.unloadGoal = unloadGoal;
        }

        public TUnloadTabletGoal howUnload() {
            return this.unloadGoal;
        }
    }
}

