/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.master.replication;

import com.google.protobuf.GeneratedMessage;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.Map;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.BatchWriterConfig;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.MutationsRejectedException;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.metadata.schema.MetadataSchema;
import org.apache.accumulo.core.protobuf.ProtobufUtil;
import org.apache.accumulo.core.replication.ReplicationSchema;
import org.apache.accumulo.core.replication.ReplicationTable;
import org.apache.accumulo.core.replication.ReplicationTableOfflineException;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.trace.Span;
import org.apache.accumulo.core.trace.Trace;
import org.apache.accumulo.server.replication.proto.Replication;
import org.apache.hadoop.io.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatusMaker {
    private static final Logger log = LoggerFactory.getLogger(StatusMaker.class);
    private final Connector conn;
    private BatchWriter replicationWriter;
    private BatchWriter metadataWriter;
    private String sourceTableName = "accumulo.metadata";

    public StatusMaker(Connector conn) {
        this.conn = conn;
    }

    public void setSourceTableName(String table) {
        this.sourceTableName = table;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Span span = Trace.start((String)"replicationStatusMaker");
        try {
            Scanner s;
            try {
                s = this.conn.createScanner(this.sourceTableName, Authorizations.EMPTY);
            }
            catch (TableNotFoundException e) {
                throw new RuntimeException(e);
            }
            s.fetchColumnFamily(MetadataSchema.ReplicationSection.COLF);
            s.setRange(MetadataSchema.ReplicationSection.getRange());
            Text file = new Text();
            for (Map.Entry entry : s) {
                Replication.Status status;
                if (null == this.replicationWriter) {
                    try {
                        ReplicationTable.setOnline((Connector)this.conn);
                        this.replicationWriter = ReplicationTable.getBatchWriter((Connector)this.conn);
                    }
                    catch (AccumuloException | AccumuloSecurityException | ReplicationTableOfflineException e) {
                        log.warn("Replication table did not come online");
                        this.replicationWriter = null;
                        span.stop();
                        return;
                    }
                }
                MetadataSchema.ReplicationSection.getFile((Key)((Key)entry.getKey()), (Text)file);
                String tableId = MetadataSchema.ReplicationSection.getTableId((Key)((Key)entry.getKey()));
                try {
                    status = Replication.Status.parseFrom((byte[])((Value)entry.getValue()).get());
                }
                catch (InvalidProtocolBufferException e) {
                    log.warn("Could not deserialize protobuf for {}", (Object)file);
                    continue;
                }
                log.debug("Creating replication status record for {} on table {} with {}.", new Object[]{file, tableId, ProtobufUtil.toString((GeneratedMessage)status)});
                Span workSpan = Trace.start((String)"createStatusMutations");
                try {
                    if (!this.addStatusRecord(file, tableId, (Value)entry.getValue())) {
                        continue;
                    }
                }
                finally {
                    workSpan.stop();
                    continue;
                }
                if (!status.getClosed()) continue;
                Span orderSpan = Trace.start((String)"recordStatusOrder");
                try {
                    if (!this.addOrderRecord(file, tableId, status, (Value)entry.getValue())) {
                        continue;
                    }
                }
                finally {
                    orderSpan.stop();
                    continue;
                }
                Span deleteSpan = Trace.start((String)"deleteClosedStatus");
                try {
                    this.deleteStatusRecord((Key)entry.getKey());
                }
                finally {
                    deleteSpan.stop();
                }
            }
        }
        finally {
            span.stop();
        }
    }

    protected void setBatchWriter(BatchWriter bw) {
        this.replicationWriter = bw;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean addStatusRecord(Text file, String tableId, Value v) {
        try {
            Mutation m = new Mutation(file);
            m.put(ReplicationSchema.StatusSection.NAME, new Text(tableId), v);
            try {
                this.replicationWriter.addMutation(m);
            }
            catch (MutationsRejectedException e) {
                log.warn("Failed to write work mutations for replication, will retry", (Throwable)e);
                boolean bl = false;
                try {
                    this.replicationWriter.flush();
                }
                catch (MutationsRejectedException e2) {
                    log.warn("Failed to write work mutations for replication, will retry", (Throwable)e2);
                    return false;
                }
                return bl;
            }
        }
        finally {
            try {
                this.replicationWriter.flush();
            }
            catch (MutationsRejectedException e) {
                log.warn("Failed to write work mutations for replication, will retry", (Throwable)e);
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean addOrderRecord(Text file, String tableId, Replication.Status stat, Value value) {
        try {
            if (!stat.hasCreatedTime()) {
                log.error("Status record ({}) for {} in table {} was written to metadata table which lacked createdTime", new Object[]{ProtobufUtil.toString((GeneratedMessage)stat), file, tableId});
                boolean bl = false;
                return bl;
            }
            log.info("Creating order record for {} for {} with {}", new Object[]{file, tableId, ProtobufUtil.toString((GeneratedMessage)stat)});
            Mutation m = ReplicationSchema.OrderSection.createMutation((String)file.toString(), (long)stat.getCreatedTime());
            ReplicationSchema.OrderSection.add((Mutation)m, (String)tableId, (Value)value);
            try {
                this.replicationWriter.addMutation(m);
            }
            catch (MutationsRejectedException e) {
                log.warn("Failed to write order mutation for replication, will retry", (Throwable)e);
                boolean bl = false;
                try {
                    this.replicationWriter.flush();
                }
                catch (MutationsRejectedException e2) {
                    log.warn("Failed to write order mutation for replication, will retry", (Throwable)e2);
                    return false;
                }
                return bl;
            }
        }
        finally {
            try {
                this.replicationWriter.flush();
            }
            catch (MutationsRejectedException e) {
                log.warn("Failed to write order mutation for replication, will retry", (Throwable)e);
                return false;
            }
        }
        return true;
    }

    protected void deleteStatusRecord(Key k) {
        log.debug("Deleting {} from metadata table as it's no longer needed", (Object)k.toStringNoTruncate());
        if (null == this.metadataWriter) {
            try {
                this.metadataWriter = this.conn.createBatchWriter(this.sourceTableName, new BatchWriterConfig());
            }
            catch (TableNotFoundException e) {
                throw new RuntimeException("Metadata table doesn't exist");
            }
        }
        try {
            Mutation m = new Mutation(k.getRow());
            m.putDelete(k.getColumnFamily(), k.getColumnQualifier());
            this.metadataWriter.addMutation(m);
            this.metadataWriter.flush();
        }
        catch (MutationsRejectedException e) {
            log.warn("Failed to delete status mutations for metadata table, will retry", (Throwable)e);
        }
    }
}

