/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.master.util;

import com.google.common.base.Joiner;
import java.util.Arrays;
import java.util.List;
import org.apache.accumulo.core.client.impl.Tables;
import org.apache.accumulo.core.util.Validator;

public class TableValidators {
    public static final String VALID_ID_REGEX = "^([a-z0-9]+)$";
    public static final Validator<String> VALID_NAME = new Validator<String>(){

        public boolean apply(String tableName) {
            return tableName != null && tableName.matches("^(\\w+\\.)?(\\w+)$");
        }

        public String invalidMessage(String tableName) {
            if (tableName == null) {
                return "Table name cannot be null";
            }
            return "Table names must only contain word characters (letters, digits, and underscores): " + tableName;
        }
    };
    public static final Validator<String> VALID_ID = new Validator<String>(){

        public boolean apply(String tableId) {
            return tableId != null && ("+r".equals(tableId) || "!0".equals(tableId) || "+rep".equals(tableId) || tableId.matches(TableValidators.VALID_ID_REGEX));
        }

        public String invalidMessage(String tableId) {
            if (tableId == null) {
                return "Table id cannot be null";
            }
            return "Table IDs are base-36 numbers, represented with lowercase alphanumeric digits: " + tableId;
        }
    };
    public static final Validator<String> NOT_METADATA = new Validator<String>(){
        private List<String> metadataTables = Arrays.asList("accumulo.root", "accumulo.metadata");

        public boolean apply(String tableName) {
            return !this.metadataTables.contains(tableName);
        }

        public String invalidMessage(String tableName) {
            return "Table cannot be one of {" + Joiner.on((String)",").join(this.metadataTables) + "}";
        }
    };
    public static final Validator<String> NOT_SYSTEM = new Validator<String>(){

        public boolean apply(String tableName) {
            return !"accumulo".equals(Tables.qualify((String)tableName).getFirst());
        }

        public String invalidMessage(String tableName) {
            return "Table cannot be in the accumulo namespace";
        }
    };
    public static final Validator<String> NOT_ROOT = new Validator<String>(){

        public boolean apply(String tableName) {
            return !"accumulo.root".equals(tableName);
        }

        public String invalidMessage(String tableName) {
            return "Table cannot be the accumulo.root(Id: +r) table";
        }
    };
    public static final Validator<String> NOT_ROOT_ID = new Validator<String>(){

        public boolean apply(String tableId) {
            return !"+r".equals(tableId);
        }

        public String invalidMessage(String tableId) {
            return "Table cannot be the accumulo.root(Id: +r) table";
        }
    };
}

