/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.master.metrics.fate;

import java.util.List;
import org.apache.accumulo.core.zookeeper.ZooUtil;
import org.apache.accumulo.fate.AdminUtil;
import org.apache.accumulo.fate.ReadOnlyTStore;
import org.apache.accumulo.fate.ZooStore;
import org.apache.accumulo.fate.zookeeper.IZooReaderWriter;
import org.apache.accumulo.master.metrics.fate.FateMetrics;
import org.apache.accumulo.server.zookeeper.ZooReaderWriter;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class FateMetricValues {
    private static final Logger log = LoggerFactory.getLogger(FateMetrics.class);
    private final long updateTime;
    private final long currentFateOps;
    private final long zkFateChildOpsTotal;
    private final long zkConnectionErrors;

    private FateMetricValues(long updateTime, long currentFateOps, long zkFateChildOpsTotal, long zkConnectionErrors) {
        this.updateTime = updateTime;
        this.currentFateOps = currentFateOps;
        this.zkFateChildOpsTotal = zkFateChildOpsTotal;
        this.zkConnectionErrors = zkConnectionErrors;
    }

    long getCurrentFateOps() {
        return this.currentFateOps;
    }

    long getZkFateChildOpsTotal() {
        return this.zkFateChildOpsTotal;
    }

    long getZkConnectionErrors() {
        return this.zkConnectionErrors;
    }

    static FateMetricValues updateFromZookeeper(String instanceId, FateMetricValues currentValues) {
        return FateMetricValues.updateFromZookeeper(instanceId, FateMetricValues.builder().copy(currentValues));
    }

    private static FateMetricValues updateFromZookeeper(String instanceId, Builder builder) {
        AdminUtil admin = new AdminUtil(false);
        try {
            ZooReaderWriter zoo = ZooReaderWriter.getInstance();
            ZooStore zs = new ZooStore(ZooUtil.getRoot((String)instanceId) + "/fate", (IZooReaderWriter)zoo);
            List currFates = admin.getTransactionStatus((ReadOnlyTStore)zs, null, null);
            builder.withCurrentFateOps(currFates.size());
            Stat node = zoo.getZooKeeper().exists(ZooUtil.getRoot((String)instanceId) + "/fate", false);
            builder.withZkFateChildOpsTotal(node.getCversion());
            if (log.isTraceEnabled()) {
                log.trace("ZkNodeStat: {czxid: {}, mzxid: {}, pzxid: {}, ctime: {}, mtime: {}, version: {}, cversion: {}, num children: {}", new Object[]{node.getCzxid(), node.getMzxid(), node.getPzxid(), node.getCtime(), node.getMtime(), node.getVersion(), node.getCversion(), node.getNumChildren()});
            }
        }
        catch (KeeperException ex) {
            log.debug("Error connecting to ZooKeeper", (Throwable)ex);
            builder.incrZkConnectionErrors();
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
        return builder.build();
    }

    public String toString() {
        return "FateMetricValues{updateTime=" + this.updateTime + ", currentFateOps=" + this.currentFateOps + ", zkFateChildOpsTotal=" + this.zkFateChildOpsTotal + ", zkConnectionErrors=" + this.zkConnectionErrors + '}';
    }

    public static Builder builder() {
        return new Builder();
    }

    static class Builder {
        private long currentFateOps = 0L;
        private long zkFateChildOpsTotal = 0L;
        private long zkConnectionErrors = 0L;

        Builder() {
        }

        Builder copy(FateMetricValues prevValues) {
            if (prevValues == null) {
                return new Builder();
            }
            return new Builder().withCurrentFateOps(prevValues.getCurrentFateOps()).withZkFateChildOpsTotal(prevValues.getZkFateChildOpsTotal()).withZkConnectionErrors(prevValues.getZkConnectionErrors());
        }

        Builder withCurrentFateOps(long value) {
            this.currentFateOps = value;
            return this;
        }

        Builder withZkFateChildOpsTotal(long value) {
            this.zkFateChildOpsTotal = value;
            return this;
        }

        Builder incrZkConnectionErrors() {
            ++this.zkConnectionErrors;
            return this;
        }

        Builder withZkConnectionErrors(long value) {
            this.zkConnectionErrors = value;
            return this;
        }

        FateMetricValues build() {
            return new FateMetricValues(System.currentTimeMillis(), this.currentFateOps, this.zkFateChildOpsTotal, this.zkConnectionErrors);
        }
    }
}

