/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.master.metrics.fate;

import java.lang.management.ManagementFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.accumulo.master.metrics.fate.FateMetricValues;
import org.apache.accumulo.master.metrics.fate.FateMetricsMBean;
import org.apache.accumulo.server.metrics.Metrics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FateMetrics
implements Metrics,
FateMetricsMBean {
    private static final Logger log = LoggerFactory.getLogger(FateMetrics.class);
    private static final long DEFAULT_MIN_REFRESH_DELAY = TimeUnit.SECONDS.toMillis(10L);
    private volatile long minimumRefreshDelay;
    private final AtomicReference<FateMetricValues> metricValues;
    private volatile long lastUpdate = 0L;
    private final String instanceId;
    private ObjectName objectName = null;
    private volatile boolean enabled = false;

    public FateMetrics(String instanceId, long minimumRefreshDelay) {
        this.instanceId = instanceId;
        this.minimumRefreshDelay = Math.max(DEFAULT_MIN_REFRESH_DELAY, minimumRefreshDelay);
        this.metricValues = new AtomicReference<FateMetricValues>(FateMetricValues.builder().build());
        try {
            this.objectName = new ObjectName("accumulo.server.metrics:service=FateMetrics,name=FateMetricsMBean,instance=" + Thread.currentThread().getName());
        }
        catch (Exception e) {
            log.error("Exception setting MBean object name", (Throwable)e);
        }
    }

    public void register() throws Exception {
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        if (null == this.objectName) {
            throw new IllegalArgumentException("MBean object name must be set.");
        }
        mbs.registerMBean(this, this.objectName);
        this.enabled = true;
    }

    public void add(String name, long time) {
        throw new UnsupportedOperationException("add() is not implemented");
    }

    public synchronized FateMetricValues snapshot() {
        FateMetricValues current = this.metricValues.get();
        long now = System.currentTimeMillis();
        if (this.lastUpdate + this.minimumRefreshDelay > now) {
            return current;
        }
        FateMetricValues updates = FateMetricValues.updateFromZookeeper(this.instanceId, current);
        this.metricValues.set(updates);
        this.lastUpdate = now;
        return updates;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public long getCurrentFateOps() {
        this.snapshot();
        return this.metricValues.get().getCurrentFateOps();
    }

    @Override
    public long getZkFateChildOpsTotal() {
        this.snapshot();
        return this.metricValues.get().getZkFateChildOpsTotal();
    }

    @Override
    public long getZKConnectionErrorsTotal() {
        this.snapshot();
        return this.metricValues.get().getZkConnectionErrors();
    }
}

