/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.master.metrics.fate;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.accumulo.master.metrics.fate.FateMetricValues;
import org.apache.accumulo.server.metrics.Metrics;
import org.apache.accumulo.server.metrics.MetricsSystemHelper;
import org.apache.hadoop.metrics2.MetricsCollector;
import org.apache.hadoop.metrics2.MetricsInfo;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.metrics2.MetricsSource;
import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.impl.MsInfo;
import org.apache.hadoop.metrics2.lib.Interns;
import org.apache.hadoop.metrics2.lib.MetricsRegistry;
import org.apache.hadoop.metrics2.lib.MutableGaugeLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Metrics2FateMetrics
implements Metrics,
MetricsSource {
    private static final Logger log = LoggerFactory.getLogger(Metrics2FateMetrics.class);
    private static final long DEFAULT_MIN_REFRESH_DELAY = TimeUnit.SECONDS.toMillis(10L);
    private volatile long minimumRefreshDelay;
    public static final String NAME = "Master,sub=Fate";
    public static final String DESCRIPTION = "Fate Metrics";
    public static final String CONTEXT = "master";
    public static final String RECORD = "fate";
    public static final String CUR_FATE_OPS = "currentFateOps";
    public static final String TOTAL_FATE_OPS = "totalFateOps";
    public static final String TOTAL_ZK_CONN_ERRORS = "totalZkConnErrors";
    private final String instanceId;
    private final MetricsSystem metricsSystem;
    private final MetricsRegistry registry;
    private final MutableGaugeLong currentFateOps;
    private final MutableGaugeLong zkChildFateOpsTotal;
    private final MutableGaugeLong zkConnectionErrorsTotal;
    private final AtomicReference<FateMetricValues> metricValues;
    private volatile long lastUpdate = 0L;

    public Metrics2FateMetrics(String instanceId, MetricsSystem metricsSystem, long minimumRefreshDelay) {
        this.instanceId = instanceId;
        this.minimumRefreshDelay = Math.max(DEFAULT_MIN_REFRESH_DELAY, minimumRefreshDelay);
        this.metricValues = new AtomicReference<FateMetricValues>(FateMetricValues.updateFromZookeeper(instanceId, null));
        this.metricsSystem = metricsSystem;
        this.registry = new MetricsRegistry(Interns.info((String)NAME, (String)DESCRIPTION));
        this.registry.tag((MetricsInfo)MsInfo.ProcessName, MetricsSystemHelper.getProcessName());
        this.currentFateOps = this.registry.newGauge(CUR_FATE_OPS, "Current number of FATE Ops", 0L);
        this.zkChildFateOpsTotal = this.registry.newGauge(TOTAL_FATE_OPS, "Total FATE Ops", 0L);
        this.zkConnectionErrorsTotal = this.registry.newGauge(TOTAL_ZK_CONN_ERRORS, "Total ZK Connection Errors", 0L);
    }

    public void register() {
        this.metricsSystem.register(NAME, DESCRIPTION, (Object)this);
    }

    public void add(String name, long time) {
        throw new UnsupportedOperationException("add() is not implemented");
    }

    public boolean isEnabled() {
        return true;
    }

    public void getMetrics(MetricsCollector collector, boolean all) {
        log.trace("getMetrics called with collector: {}", (Object)collector);
        FateMetricValues fateMetrics = this.metricValues.get();
        long now = System.currentTimeMillis();
        if (this.lastUpdate + this.minimumRefreshDelay < now) {
            fateMetrics = FateMetricValues.updateFromZookeeper(this.instanceId, fateMetrics);
            this.metricValues.set(fateMetrics);
            this.lastUpdate = now;
            this.currentFateOps.set(fateMetrics.getCurrentFateOps());
            this.zkChildFateOpsTotal.set(fateMetrics.getZkFateChildOpsTotal());
            this.zkConnectionErrorsTotal.set(fateMetrics.getZkConnectionErrors());
        }
        MetricsRecordBuilder builder = collector.addRecord(RECORD).setContext(CONTEXT);
        this.registry.snapshot(builder, all);
    }
}

