/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.master;

import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Iterators;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.BatchWriterConfig;
import org.apache.accumulo.core.client.MutationsRejectedException;
import org.apache.accumulo.core.client.RowIterator;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.ScannerBase;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.impl.Table;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.PartialKey;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.data.impl.KeyExtent;
import org.apache.accumulo.core.master.state.tables.TableState;
import org.apache.accumulo.core.master.thrift.MasterState;
import org.apache.accumulo.core.master.thrift.TabletServerStatus;
import org.apache.accumulo.core.metadata.schema.MetadataSchema;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.tabletserver.thrift.NotServingTabletException;
import org.apache.accumulo.core.util.Daemon;
import org.apache.accumulo.fate.util.UtilWaitThread;
import org.apache.accumulo.fate.zookeeper.ZooLock;
import org.apache.accumulo.master.EventCoordinator;
import org.apache.accumulo.master.Master;
import org.apache.accumulo.master.state.MergeStats;
import org.apache.accumulo.master.state.TableCounts;
import org.apache.accumulo.master.state.TableStats;
import org.apache.accumulo.server.ServerConstants;
import org.apache.accumulo.server.ServerContext;
import org.apache.accumulo.server.conf.TableConfiguration;
import org.apache.accumulo.server.fs.FileRef;
import org.apache.accumulo.server.fs.VolumeChooserEnvironment;
import org.apache.accumulo.server.fs.VolumeManager;
import org.apache.accumulo.server.log.WalStateManager;
import org.apache.accumulo.server.master.LiveTServerSet;
import org.apache.accumulo.server.master.state.Assignment;
import org.apache.accumulo.server.master.state.ClosableIterator;
import org.apache.accumulo.server.master.state.DistributedStoreException;
import org.apache.accumulo.server.master.state.MergeInfo;
import org.apache.accumulo.server.master.state.MergeState;
import org.apache.accumulo.server.master.state.TServerInstance;
import org.apache.accumulo.server.master.state.TabletLocationState;
import org.apache.accumulo.server.master.state.TabletState;
import org.apache.accumulo.server.master.state.TabletStateStore;
import org.apache.accumulo.server.tablets.TabletTime;
import org.apache.accumulo.server.util.MetadataTableUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.BinaryComparable;
import org.apache.hadoop.io.Text;
import org.apache.thrift.TException;

abstract class TabletGroupWatcher
extends Daemon {
    private static final String ASSIGNMENT_BUFFER_SEPARATOR = ", ";
    private static final int ASSINGMENT_BUFFER_MAX_LENGTH = 4096;
    private final Master master;
    final TabletStateStore store;
    final TabletGroupWatcher dependentWatcher;
    private MasterState masterState;
    final TableStats stats = new TableStats();
    private SortedSet<TServerInstance> lastScanServers = ImmutableSortedSet.of();

    TabletGroupWatcher(Master master, TabletStateStore store, TabletGroupWatcher dependentWatcher) {
        this.master = master;
        this.store = store;
        this.dependentWatcher = dependentWatcher;
    }

    abstract boolean canSuspendTablets();

    Map<Table.ID, TableCounts> getStats() {
        return this.stats.getLast();
    }

    MasterState statsState() {
        return this.masterState;
    }

    TableCounts getStats(Table.ID tableId) {
        return this.stats.getLast(tableId);
    }

    public synchronized boolean isSameTserversAsLastScan(Set<TServerInstance> candidates) {
        return candidates.equals(this.lastScanServers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void run() {
        Thread.currentThread().setName("Watching " + this.store.name());
        int[] oldCounts = new int[TabletState.values().length];
        EventCoordinator.Listener eventListener = this.master.nextEvent.getListener();
        WalStateManager wals = new WalStateManager(this.master.getContext());
        while (this.master.stillMaster()) {
            UtilWaitThread.sleepUninterruptibly((long)100L, (TimeUnit)TimeUnit.MILLISECONDS);
            this.masterState = this.master.getMasterState();
            int totalUnloaded = 0;
            int unloaded = 0;
            ClosableIterator iter = null;
            try {
                HashMap<Table.ID, MergeStats> mergeStatsCache = new HashMap<Table.ID, MergeStats>();
                HashMap<Table.ID, MergeStats> currentMerges = new HashMap<Table.ID, MergeStats>();
                for (MergeInfo mergeInfo : this.master.merges()) {
                    if (mergeInfo.getExtent() == null) continue;
                    currentMerges.put(mergeInfo.getExtent().getTableId(), new MergeStats(mergeInfo));
                }
                TreeMap currentTServers = new TreeMap();
                for (TServerInstance entry : this.master.tserverSet.getCurrentServers()) {
                    currentTServers.put(entry, this.master.tserverStatus.get(entry));
                }
                if (currentTServers.size() == 0) {
                    eventListener.waitForEvents(60000L);
                    TabletGroupWatcher tabletGroupWatcher = this;
                    // MONITORENTER : tabletGroupWatcher
                    this.lastScanServers = ImmutableSortedSet.of();
                    // MONITOREXIT : tabletGroupWatcher
                    continue;
                }
                TreeMap<TServerInstance, TabletServerStatus> treeMap = new TreeMap<TServerInstance, TabletServerStatus>(currentTServers);
                treeMap.keySet().removeAll(this.master.serversToShutdown);
                ArrayList<Assignment> assignments = new ArrayList<Assignment>();
                ArrayList<Assignment> assigned = new ArrayList<Assignment>();
                ArrayList<TabletLocationState> assignedToDeadServers = new ArrayList<TabletLocationState>();
                ArrayList<TabletLocationState> suspendedToGoneServers = new ArrayList<TabletLocationState>();
                HashMap<KeyExtent, TServerInstance> unassigned = new HashMap<KeyExtent, TServerInstance>();
                TreeMap<TServerInstance, List<Path>> logsForDeadServers = new TreeMap<TServerInstance, List<Path>>();
                MasterState masterState = this.master.getMasterState();
                int[] counts = new int[TabletState.values().length];
                this.stats.begin();
                for (TabletLocationState tabletLocationState : this.store) {
                    TabletState state;
                    block56: {
                        TServerInstance server;
                        Master.TabletGoalState goal;
                        block55: {
                            if (tabletLocationState == null) continue;
                            Master.log.debug("{} location State: {}", (Object)this.store.name(), (Object)tabletLocationState);
                            if (this.master.getTableManager().getTableState(tabletLocationState.extent.getTableId()) == null) continue;
                            if (Master.log.isTraceEnabled()) {
                                Master.log.trace("{} walogs {}", (Object)tabletLocationState, (Object)tabletLocationState.walogs.size());
                            }
                            if (unassigned.size() + unloaded > 5000 * currentTServers.size()) {
                                this.flushChanges(treeMap, assignments, assigned, assignedToDeadServers, logsForDeadServers, suspendedToGoneServers, unassigned);
                                assignments.clear();
                                assigned.clear();
                                assignedToDeadServers.clear();
                                suspendedToGoneServers.clear();
                                unassigned.clear();
                                unloaded = 0;
                                eventListener.waitForEvents(60000L);
                            }
                            Table.ID tableId = tabletLocationState.extent.getTableId();
                            TableConfiguration tableConf = this.master.getConfigurationFactory().getTableConfiguration(tableId);
                            MergeStats mergeStats = (MergeStats)mergeStatsCache.get(tableId);
                            if (mergeStats == null) {
                                mergeStats = (MergeStats)currentMerges.get(tableId);
                                if (mergeStats == null) {
                                    mergeStats = new MergeStats(new MergeInfo());
                                }
                                mergeStatsCache.put(tableId, mergeStats);
                            }
                            goal = this.master.getGoalState(tabletLocationState, mergeStats.getMergeInfo());
                            server = tabletLocationState.getServer();
                            state = tabletLocationState.getState(currentTServers.keySet());
                            if (Master.log.isTraceEnabled()) {
                                Master.log.trace("Goal state {} current {} for {}", new Object[]{goal, state, tabletLocationState.extent});
                            }
                            this.stats.update(tableId, state);
                            mergeStats.update(tabletLocationState.extent, state, tabletLocationState.chopped, !tabletLocationState.walogs.isEmpty());
                            this.sendChopRequest(mergeStats.getMergeInfo(), state, tabletLocationState);
                            this.sendSplitRequest(mergeStats.getMergeInfo(), state, tabletLocationState);
                            if (state == TabletState.ASSIGNED) {
                                goal = Master.TabletGoalState.HOSTED;
                            }
                            if (goal == Master.TabletGoalState.SUSPENDED && state == TabletState.HOSTED && this.master.serversToShutdown.equals(currentTServers.keySet()) && this.dependentWatcher != null && this.dependentWatcher.assignedOrHosted() > 0) {
                                goal = Master.TabletGoalState.HOSTED;
                            }
                            if (goal != Master.TabletGoalState.HOSTED) break block55;
                            if (state != TabletState.HOSTED && !tabletLocationState.walogs.isEmpty() && this.master.recoveryManager.recoverLogs(tabletLocationState.extent, tabletLocationState.walogs)) continue;
                            switch (state) {
                                case HOSTED: {
                                    if (server.equals(this.master.migrations.get(tabletLocationState.extent))) {
                                        this.master.migrations.remove(tabletLocationState.extent);
                                        break;
                                    }
                                    break block56;
                                }
                                case ASSIGNED_TO_DEAD_SERVER: {
                                    TServerInstance tserver;
                                    assignedToDeadServers.add(tabletLocationState);
                                    if (server.equals(this.master.migrations.get(tabletLocationState.extent))) {
                                        this.master.migrations.remove(tabletLocationState.extent);
                                    }
                                    if (!logsForDeadServers.containsKey(tserver = tabletLocationState.futureOrCurrent())) {
                                        logsForDeadServers.put(tserver, wals.getWalsInUse(tserver));
                                        break;
                                    }
                                    break block56;
                                }
                                case SUSPENDED: {
                                    if (this.master.getSteadyTime() - tabletLocationState.suspend.suspensionTime < tableConf.getTimeInMillis(Property.TABLE_SUSPEND_DURATION)) {
                                        TServerInstance found;
                                        TServerInstance returnInstance = null;
                                        Iterator<TServerInstance> find = treeMap.tailMap(new TServerInstance(tabletLocationState.suspend.server, " ")).keySet().iterator();
                                        if (find.hasNext() && (found = find.next()).getLocation().equals((Object)tabletLocationState.suspend.server)) {
                                            returnInstance = found;
                                        }
                                        if (returnInstance == null) break;
                                        assignments.add(new Assignment(tabletLocationState.extent, returnInstance));
                                        break;
                                    }
                                    unassigned.put(tabletLocationState.extent, server);
                                    break;
                                }
                                case UNASSIGNED: {
                                    TServerInstance dest = (TServerInstance)this.master.migrations.get(tabletLocationState.extent);
                                    if (dest != null) {
                                        if (treeMap.keySet().contains(dest)) {
                                            assignments.add(new Assignment(tabletLocationState.extent, dest));
                                            break;
                                        }
                                        this.master.migrations.remove(tabletLocationState.extent);
                                        unassigned.put(tabletLocationState.extent, server);
                                        break;
                                    }
                                    unassigned.put(tabletLocationState.extent, server);
                                    break;
                                }
                                case ASSIGNED: {
                                    assigned.add(new Assignment(tabletLocationState.extent, tabletLocationState.future));
                                    break;
                                }
                            }
                            break block56;
                        }
                        switch (state) {
                            case SUSPENDED: {
                                suspendedToGoneServers.add(tabletLocationState);
                                this.cancelOfflineTableMigrations(tabletLocationState);
                                break;
                            }
                            case UNASSIGNED: {
                                this.cancelOfflineTableMigrations(tabletLocationState);
                                break;
                            }
                            case ASSIGNED_TO_DEAD_SERVER: {
                                assignedToDeadServers.add(tabletLocationState);
                                if (logsForDeadServers.containsKey(tabletLocationState.futureOrCurrent())) break;
                                logsForDeadServers.put(tabletLocationState.futureOrCurrent(), wals.getWalsInUse(tabletLocationState.futureOrCurrent()));
                                break;
                            }
                            case HOSTED: {
                                LiveTServerSet.TServerConnection client = this.master.tserverSet.getConnection(server);
                                if (client != null) {
                                    client.unloadTablet(this.master.masterLock, tabletLocationState.extent, goal.howUnload(), this.master.getSteadyTime().longValue());
                                    ++unloaded;
                                    ++totalUnloaded;
                                    break;
                                }
                                Master.log.warn("Could not connect to server {}", (Object)server);
                                break;
                            }
                        }
                    }
                    int n = state.ordinal();
                    counts[n] = counts[n] + 1;
                }
                this.flushChanges(treeMap, assignments, assigned, assignedToDeadServers, logsForDeadServers, suspendedToGoneServers, unassigned);
                this.stats.end(masterState);
                for (TabletState state : TabletState.values()) {
                    int i = state.ordinal();
                    if (counts[i] <= 0 || counts[i] == oldCounts[i]) continue;
                    this.master.nextEvent.event("[%s]: %d tablets are %s", this.store.name(), counts[i], state.name());
                }
                Master.log.debug(String.format("[%s]: scan time %.2f seconds", this.store.name(), (double)this.stats.getScanTime() / 1000.0));
                oldCounts = counts;
                if (totalUnloaded > 0) {
                    this.master.nextEvent.event("[%s]: %d tablets unloaded", this.store.name(), totalUnloaded);
                }
                this.updateMergeState(mergeStatsCache);
                TabletGroupWatcher tabletGroupWatcher = this;
                // MONITORENTER : tabletGroupWatcher
                this.lastScanServers = ImmutableSortedSet.copyOf(currentTServers.keySet());
                // MONITOREXIT : tabletGroupWatcher
                if (this.master.tserverSet.getCurrentServers().equals(currentTServers.keySet())) {
                    Master.log.debug(String.format("[%s] sleeping for %.2f seconds", this.store.name(), 60.0));
                    eventListener.waitForEvents(60000L);
                    continue;
                }
                Master.log.info("Detected change in current tserver set, re-running state machine.");
            }
            catch (Exception ex) {
                Master.log.error("Error processing table state for store " + this.store.name(), (Throwable)ex);
                if (ex.getCause() != null && ex.getCause() instanceof TabletLocationState.BadLocationStateException) {
                    this.repairMetadata(((TabletLocationState.BadLocationStateException)ex.getCause()).getEncodedEndRow());
                    continue;
                }
                UtilWaitThread.sleepUninterruptibly((long)1000L, (TimeUnit)TimeUnit.MILLISECONDS);
            }
            finally {
                if (iter == null) continue;
                try {
                    iter.close();
                }
                catch (IOException ex) {
                    Master.log.warn("Error closing TabletLocationState iterator: " + ex, (Throwable)ex);
                }
            }
        }
    }

    private void cancelOfflineTableMigrations(TabletLocationState tls) {
        TServerInstance dest = (TServerInstance)this.master.migrations.get(tls.extent);
        TableState tableState = this.master.getTableManager().getTableState(tls.extent.getTableId());
        if (dest != null && tableState == TableState.OFFLINE) {
            this.master.migrations.remove(tls.extent);
        }
    }

    private void repairMetadata(Text row) {
        Master.log.debug("Attempting repair on {}", (Object)row);
        try {
            HashMap future = new HashMap();
            HashMap assigned = new HashMap();
            KeyExtent extent = new KeyExtent(row, new Value(new byte[]{0}));
            String table = "accumulo.metadata";
            if (extent.isMeta()) {
                table = "accumulo.root";
            }
            Scanner scanner = this.master.getClient().createScanner(table, Authorizations.EMPTY);
            scanner.fetchColumnFamily(MetadataSchema.TabletsSection.CurrentLocationColumnFamily.NAME);
            scanner.fetchColumnFamily(MetadataSchema.TabletsSection.FutureLocationColumnFamily.NAME);
            scanner.setRange(new Range(row));
            for (Map.Entry entry : scanner) {
                if (((Key)entry.getKey()).getColumnFamily().equals((Object)MetadataSchema.TabletsSection.CurrentLocationColumnFamily.NAME)) {
                    assigned.put(entry.getKey(), entry.getValue());
                    continue;
                }
                if (!((Key)entry.getKey()).getColumnFamily().equals((Object)MetadataSchema.TabletsSection.FutureLocationColumnFamily.NAME)) continue;
                future.put(entry.getKey(), entry.getValue());
            }
            if (future.size() > 0 && assigned.size() > 0) {
                Master.log.warn("Found a tablet assigned and hosted, attempting to repair");
            } else if (future.size() > 1 && assigned.size() == 0) {
                Master.log.warn("Found a tablet assigned to multiple servers, attempting to repair");
            } else if (future.size() == 0 && assigned.size() > 1) {
                Master.log.warn("Found a tablet hosted on multiple servers, attempting to repair");
            } else {
                Master.log.info("Attempted a repair, but nothing seems to be obviously wrong. {} {}", assigned, future);
                return;
            }
            Iterator iter = Iterators.concat(future.entrySet().iterator(), assigned.entrySet().iterator());
            while (iter.hasNext()) {
                Map.Entry entry;
                entry = (Map.Entry)iter.next();
                TServerInstance alive = this.master.tserverSet.find(((Value)entry.getValue()).toString());
                if (alive != null) continue;
                Master.log.info("Removing entry  {}", (Object)entry);
                BatchWriter bw = this.master.getClient().createBatchWriter(table, new BatchWriterConfig());
                Mutation m = new Mutation(((Key)entry.getKey()).getRow());
                m.putDelete(((Key)entry.getKey()).getColumnFamily(), ((Key)entry.getKey()).getColumnQualifier());
                bw.addMutation(m);
                bw.close();
                return;
            }
            Master.log.error("Metadata table is inconsistent at {} and all assigned/future tservers are still online.", (Object)row);
        }
        catch (Throwable e) {
            Master.log.error("Error attempting repair of metadata " + row + ": " + e, e);
        }
    }

    private int assignedOrHosted() {
        int result = 0;
        for (TableCounts counts : this.stats.getLast().values()) {
            result += counts.assigned() + counts.hosted();
        }
        return result;
    }

    private void sendSplitRequest(MergeInfo info, TabletState state, TabletLocationState tls) {
        if (!info.getState().equals((Object)MergeState.SPLITTING)) {
            return;
        }
        if (!info.isDelete()) {
            return;
        }
        if (!state.equals((Object)TabletState.HOSTED)) {
            return;
        }
        KeyExtent range = info.getExtent();
        if (tls.extent.overlaps(range)) {
            for (Text splitPoint : new Text[]{range.getPrevEndRow(), range.getEndRow()}) {
                if (splitPoint == null || !tls.extent.contains((BinaryComparable)splitPoint) || splitPoint.equals((Object)tls.extent.getEndRow()) || splitPoint.equals((Object)tls.extent.getPrevEndRow())) continue;
                try {
                    LiveTServerSet.TServerConnection conn = this.master.tserverSet.getConnection(tls.current);
                    if (conn != null) {
                        Master.log.info("Asking {} to split {} at {}", new Object[]{tls.current, tls.extent, splitPoint});
                        conn.splitTablet(this.master.masterLock, tls.extent, splitPoint);
                        continue;
                    }
                    Master.log.warn("Not connected to server {}", (Object)tls.current);
                }
                catch (NotServingTabletException e) {
                    Master.log.debug("Error asking tablet server to split a tablet: ", (Throwable)e);
                }
                catch (Exception e) {
                    Master.log.warn("Error asking tablet server to split a tablet: ", (Throwable)e);
                }
            }
        }
    }

    private void sendChopRequest(MergeInfo info, TabletState state, TabletLocationState tls) {
        if (!info.getState().equals((Object)MergeState.WAITING_FOR_CHOPPED)) {
            return;
        }
        if (!state.equals((Object)TabletState.HOSTED)) {
            return;
        }
        if (tls.chopped) {
            return;
        }
        if (info.needsToBeChopped(tls.extent)) {
            try {
                LiveTServerSet.TServerConnection conn = this.master.tserverSet.getConnection(tls.current);
                if (conn != null) {
                    Master.log.info("Asking {} to chop {}", (Object)tls.current, (Object)tls.extent);
                    conn.chop(this.master.masterLock, tls.extent);
                } else {
                    Master.log.warn("Could not connect to server {}", (Object)tls.current);
                }
            }
            catch (TException e) {
                Master.log.warn("Communications error asking tablet server to chop a tablet");
            }
        }
    }

    private void updateMergeState(Map<Table.ID, MergeStats> mergeStatsCache) {
        for (MergeStats stats : mergeStatsCache.values()) {
            try {
                MergeState update = stats.nextMergeState(this.master.getClient(), this.master);
                if (update == MergeState.COMPLETE) {
                    update = MergeState.NONE;
                }
                if (update != stats.getMergeInfo().getState()) {
                    this.master.setMergeState(stats.getMergeInfo(), update);
                }
                if (update != MergeState.MERGING) continue;
                try {
                    if (stats.getMergeInfo().isDelete()) {
                        this.deleteTablets(stats.getMergeInfo());
                    } else {
                        this.mergeMetadataRecords(stats.getMergeInfo());
                    }
                    update = MergeState.COMPLETE;
                    this.master.setMergeState(stats.getMergeInfo(), update);
                }
                catch (Exception ex) {
                    Master.log.error("Unable merge metadata table records", (Throwable)ex);
                }
            }
            catch (Exception ex) {
                Master.log.error("Unable to update merge state for merge " + stats.getMergeInfo().getExtent(), (Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteTablets(MergeInfo info) throws AccumuloException {
        block18: {
            KeyExtent extent = info.getExtent();
            String targetSystemTable = extent.isMeta() ? "accumulo.root" : "accumulo.metadata";
            Master.log.debug("Deleting tablets for {}", (Object)extent);
            char timeType = '\u0000';
            KeyExtent followingTablet = null;
            if (extent.getEndRow() != null) {
                Key nextExtent = new Key(extent.getEndRow()).followingKey(PartialKey.ROW);
                followingTablet = this.getHighTablet(new KeyExtent(extent.getTableId(), nextExtent.getRow(), extent.getEndRow()));
                Master.log.debug("Found following tablet {}", (Object)followingTablet);
            }
            try {
                AccumuloClient client = this.master.getClient();
                Text start = extent.getPrevEndRow();
                if (start == null) {
                    start = new Text();
                }
                Master.log.debug("Making file deletion entries for {}", (Object)extent);
                Range deleteRange = new Range(KeyExtent.getMetadataEntry((Table.ID)extent.getTableId(), (Text)start), false, KeyExtent.getMetadataEntry((Table.ID)extent.getTableId(), (Text)extent.getEndRow()), true);
                Scanner scanner = client.createScanner(targetSystemTable, Authorizations.EMPTY);
                scanner.setRange(deleteRange);
                MetadataSchema.TabletsSection.ServerColumnFamily.DIRECTORY_COLUMN.fetch((ScannerBase)scanner);
                MetadataSchema.TabletsSection.ServerColumnFamily.TIME_COLUMN.fetch((ScannerBase)scanner);
                scanner.fetchColumnFamily(MetadataSchema.TabletsSection.DataFileColumnFamily.NAME);
                scanner.fetchColumnFamily(MetadataSchema.TabletsSection.CurrentLocationColumnFamily.NAME);
                TreeSet<FileRef> datafiles = new TreeSet<FileRef>();
                for (Map.Entry entry : scanner) {
                    Key key = (Key)entry.getKey();
                    if (key.compareColumnFamily(MetadataSchema.TabletsSection.DataFileColumnFamily.NAME) == 0) {
                        datafiles.add(new FileRef(this.master.fs, key));
                        if (datafiles.size() <= 1000) continue;
                        MetadataTableUtil.addDeleteEntries((KeyExtent)extent, datafiles, (ServerContext)this.master.getContext());
                        datafiles.clear();
                        continue;
                    }
                    if (MetadataSchema.TabletsSection.ServerColumnFamily.TIME_COLUMN.hasColumns(key)) {
                        timeType = ((Value)entry.getValue()).toString().charAt(0);
                        continue;
                    }
                    if (key.compareColumnFamily(MetadataSchema.TabletsSection.CurrentLocationColumnFamily.NAME) == 0) {
                        throw new IllegalStateException("Tablet " + key.getRow() + " is assigned during a merge!");
                    }
                    if (!MetadataSchema.TabletsSection.ServerColumnFamily.DIRECTORY_COLUMN.hasColumns(key)) continue;
                    String path = ((Value)entry.getValue()).toString();
                    if (path.contains(":")) {
                        datafiles.add(new FileRef(path));
                    } else {
                        datafiles.add(new FileRef(path, this.master.fs.getFullPath(VolumeManager.FileType.TABLE, "/" + extent.getTableId() + path)));
                    }
                    if (datafiles.size() <= 1000) continue;
                    MetadataTableUtil.addDeleteEntries((KeyExtent)extent, datafiles, (ServerContext)this.master.getContext());
                    datafiles.clear();
                }
                MetadataTableUtil.addDeleteEntries((KeyExtent)extent, datafiles, (ServerContext)this.master.getContext());
                try (BatchWriter bw = client.createBatchWriter(targetSystemTable, new BatchWriterConfig());){
                    this.deleteTablets(info, deleteRange, bw, client);
                }
                if (followingTablet != null) {
                    Master.log.debug("Updating prevRow of {} to {}", (Object)followingTablet, (Object)extent.getPrevEndRow());
                    bw = client.createBatchWriter(targetSystemTable, new BatchWriterConfig());
                    try {
                        Mutation m = new Mutation(followingTablet.getMetadataEntry());
                        MetadataSchema.TabletsSection.TabletColumnFamily.PREV_ROW_COLUMN.put(m, KeyExtent.encodePrevEndRow((Text)extent.getPrevEndRow()));
                        MetadataSchema.TabletsSection.ChoppedColumnFamily.CHOPPED_COLUMN.putDelete(m);
                        bw.addMutation(m);
                        bw.flush();
                        break block18;
                    }
                    finally {
                        bw.close();
                    }
                }
                Master.log.debug("Recreating the last tablet to point to {}", (Object)extent.getPrevEndRow());
                VolumeChooserEnvironment chooserEnv = new VolumeChooserEnvironment(extent.getTableId(), this.master.getContext());
                String tdir = this.master.getFileSystem().choose(chooserEnv, ServerConstants.getBaseUris((AccumuloConfiguration)this.master.getConfiguration())) + "/tables" + "/" + extent.getTableId() + "/default_tablet";
                MetadataTableUtil.addTablet((KeyExtent)new KeyExtent(extent.getTableId(), null, extent.getPrevEndRow()), (String)tdir, (ServerContext)this.master.getContext(), (char)timeType, (ZooLock)this.master.masterLock);
            }
            catch (IOException | RuntimeException | AccumuloSecurityException | TableNotFoundException ex) {
                throw new AccumuloException(ex);
            }
        }
    }

    private void mergeMetadataRecords(MergeInfo info) throws AccumuloException {
        KeyExtent range = info.getExtent();
        Master.log.debug("Merging metadata for {}", (Object)range);
        KeyExtent stop = this.getHighTablet(range);
        Master.log.debug("Highest tablet is {}", (Object)stop);
        Value firstPrevRowValue = null;
        Text stopRow = stop.getMetadataEntry();
        Text start = range.getPrevEndRow();
        if (start == null) {
            start = new Text();
        }
        Range scanRange = new Range(KeyExtent.getMetadataEntry((Table.ID)range.getTableId(), (Text)start), false, stopRow, false);
        String targetSystemTable = "accumulo.metadata";
        if (range.isMeta()) {
            targetSystemTable = "accumulo.root";
        }
        BatchWriter bw = null;
        try {
            long fileCount = 0L;
            AccumuloClient client = this.master.getClient();
            bw = client.createBatchWriter(targetSystemTable, new BatchWriterConfig());
            Scanner scanner = client.createScanner(targetSystemTable, Authorizations.EMPTY);
            scanner.setRange(scanRange);
            MetadataSchema.TabletsSection.TabletColumnFamily.PREV_ROW_COLUMN.fetch((ScannerBase)scanner);
            MetadataSchema.TabletsSection.ServerColumnFamily.TIME_COLUMN.fetch((ScannerBase)scanner);
            MetadataSchema.TabletsSection.ServerColumnFamily.DIRECTORY_COLUMN.fetch((ScannerBase)scanner);
            scanner.fetchColumnFamily(MetadataSchema.TabletsSection.DataFileColumnFamily.NAME);
            Mutation m = new Mutation(stopRow);
            String maxLogicalTime = null;
            for (Map.Entry entry : scanner) {
                Key key = (Key)entry.getKey();
                Value value = (Value)entry.getValue();
                if (key.getColumnFamily().equals((Object)MetadataSchema.TabletsSection.DataFileColumnFamily.NAME)) {
                    m.put(key.getColumnFamily(), key.getColumnQualifier(), value);
                    ++fileCount;
                    continue;
                }
                if (MetadataSchema.TabletsSection.TabletColumnFamily.PREV_ROW_COLUMN.hasColumns(key) && firstPrevRowValue == null) {
                    Master.log.debug("prevRow entry for lowest tablet is {}", (Object)value);
                    firstPrevRowValue = new Value(value);
                    continue;
                }
                if (MetadataSchema.TabletsSection.ServerColumnFamily.TIME_COLUMN.hasColumns(key)) {
                    maxLogicalTime = TabletTime.maxMetadataTime((String)maxLogicalTime, (String)value.toString());
                    continue;
                }
                if (!MetadataSchema.TabletsSection.ServerColumnFamily.DIRECTORY_COLUMN.hasColumns(key)) continue;
                bw.addMutation(MetadataTableUtil.createDeleteMutation((ServerContext)this.master.getContext(), (Table.ID)range.getTableId(), (String)((Value)entry.getValue()).toString()));
            }
            scanner = client.createScanner(targetSystemTable, Authorizations.EMPTY);
            scanner.setRange(new Range(stopRow));
            MetadataSchema.TabletsSection.ServerColumnFamily.TIME_COLUMN.fetch((ScannerBase)scanner);
            for (Map.Entry entry : scanner) {
                if (!MetadataSchema.TabletsSection.ServerColumnFamily.TIME_COLUMN.hasColumns((Key)entry.getKey())) continue;
                maxLogicalTime = TabletTime.maxMetadataTime((String)maxLogicalTime, (String)((Value)entry.getValue()).toString());
            }
            if (maxLogicalTime != null) {
                MetadataSchema.TabletsSection.ServerColumnFamily.TIME_COLUMN.put(m, new Value(maxLogicalTime.getBytes()));
            }
            if (!m.getUpdates().isEmpty()) {
                bw.addMutation(m);
            }
            bw.flush();
            Master.log.debug("Moved {} files to {}", (Object)fileCount, (Object)stop);
            if (firstPrevRowValue == null) {
                Master.log.debug("tablet already merged");
                return;
            }
            stop.setPrevEndRow(KeyExtent.decodePrevEndRow((Value)firstPrevRowValue));
            Mutation updatePrevRow = stop.getPrevRowUpdateMutation();
            Master.log.debug("Setting the prevRow for last tablet: {}", (Object)stop);
            bw.addMutation(updatePrevRow);
            bw.flush();
            this.deleteTablets(info, scanRange, bw, client);
            m = new Mutation(stopRow);
            MetadataSchema.TabletsSection.ChoppedColumnFamily.CHOPPED_COLUMN.putDelete(m);
            bw.addMutation(m);
            bw.flush();
        }
        catch (Exception ex) {
            throw new AccumuloException((Throwable)ex);
        }
        finally {
            if (bw != null) {
                try {
                    bw.close();
                }
                catch (Exception ex) {
                    throw new AccumuloException((Throwable)ex);
                }
            }
        }
    }

    private void deleteTablets(MergeInfo info, Range scanRange, BatchWriter bw, AccumuloClient client) throws TableNotFoundException, MutationsRejectedException {
        Scanner scanner = client.createScanner(info.getExtent().isMeta() ? "accumulo.root" : "accumulo.metadata", Authorizations.EMPTY);
        Master.log.debug("Deleting range {}", (Object)scanRange);
        scanner.setRange(scanRange);
        RowIterator rowIter = new RowIterator((Iterable)scanner);
        while (rowIter.hasNext()) {
            Iterator row = rowIter.next();
            Mutation m = null;
            while (row.hasNext()) {
                Map.Entry entry = (Map.Entry)row.next();
                Key key = (Key)entry.getKey();
                if (m == null) {
                    m = new Mutation(key.getRow());
                }
                m.putDelete(key.getColumnFamily(), key.getColumnQualifier());
                Master.log.debug("deleting entry {}", (Object)key);
            }
            bw.addMutation(m);
        }
        bw.flush();
    }

    private KeyExtent getHighTablet(KeyExtent range) throws AccumuloException {
        try {
            AccumuloClient client = this.master.getClient();
            Scanner scanner = client.createScanner(range.isMeta() ? "accumulo.root" : "accumulo.metadata", Authorizations.EMPTY);
            MetadataSchema.TabletsSection.TabletColumnFamily.PREV_ROW_COLUMN.fetch((ScannerBase)scanner);
            KeyExtent start = new KeyExtent(range.getTableId(), range.getEndRow(), null);
            scanner.setRange(new Range(start.getMetadataEntry(), null));
            Iterator iterator = scanner.iterator();
            if (!iterator.hasNext()) {
                throw new AccumuloException("No last tablet for a merge " + range);
            }
            Map.Entry entry = (Map.Entry)iterator.next();
            KeyExtent highTablet = new KeyExtent(((Key)entry.getKey()).getRow(), KeyExtent.decodePrevEndRow((Value)((Value)entry.getValue())));
            if (!highTablet.getTableId().equals((Object)range.getTableId())) {
                throw new AccumuloException("No last tablet for merge " + range + " " + highTablet);
            }
            return highTablet;
        }
        catch (Exception ex) {
            throw new AccumuloException("Unexpected failure finding the last tablet for a merge " + range, (Throwable)ex);
        }
    }

    private void flushChanges(SortedMap<TServerInstance, TabletServerStatus> currentTServers, List<Assignment> assignments, List<Assignment> assigned, List<TabletLocationState> assignedToDeadServers, Map<TServerInstance, List<Path>> logsForDeadServers, List<TabletLocationState> suspendedToGoneServers, Map<KeyExtent, TServerInstance> unassigned) throws DistributedStoreException, TException, WalStateManager.WalMarkerException {
        int maxServersToShow;
        boolean tabletsSuspendable = this.canSuspendTablets();
        if (!assignedToDeadServers.isEmpty()) {
            maxServersToShow = Math.min(assignedToDeadServers.size(), 100);
            Master.log.debug("{} assigned to dead servers: {}...", (Object)assignedToDeadServers.size(), assignedToDeadServers.subList(0, maxServersToShow));
            Master.log.debug("logs for dead servers: {}", logsForDeadServers);
            if (tabletsSuspendable) {
                this.store.suspend(assignedToDeadServers, logsForDeadServers, this.master.getSteadyTime().longValue());
            } else {
                this.store.unassign(assignedToDeadServers, logsForDeadServers);
            }
            this.master.markDeadServerLogsAsClosed(logsForDeadServers);
            this.master.nextEvent.event("Marked %d tablets as suspended because they don't have current servers", assignedToDeadServers.size());
        }
        if (!suspendedToGoneServers.isEmpty()) {
            maxServersToShow = Math.min(assignedToDeadServers.size(), 100);
            Master.log.debug(assignedToDeadServers.size() + " suspended to gone servers: " + assignedToDeadServers.subList(0, maxServersToShow) + "...");
            this.store.unsuspend(suspendedToGoneServers);
        }
        if (!currentTServers.isEmpty()) {
            HashMap assignedOut = new HashMap();
            StringBuilder builder = new StringBuilder(64);
            this.master.tabletBalancer.getAssignments(Collections.unmodifiableSortedMap(currentTServers), Collections.unmodifiableMap(unassigned), assignedOut);
            for (Map.Entry assignment : assignedOut.entrySet()) {
                if (unassigned.containsKey(assignment.getKey())) {
                    if (assignment.getValue() == null) continue;
                    if (!currentTServers.containsKey(assignment.getValue())) {
                        Master.log.warn("balancer assigned {} to a tablet server that is not current {} ignoring", assignment.getKey(), assignment.getValue());
                        continue;
                    }
                    if (builder.length() > 0) {
                        builder.append(ASSIGNMENT_BUFFER_SEPARATOR);
                    }
                    builder.append(assignment);
                    if (builder.length() > 4096) {
                        builder.append("]");
                        Master.log.debug("{} assigning tablets: [{}", (Object)this.store.name(), (Object)builder);
                        builder.setLength(0);
                    }
                    assignments.add(new Assignment((KeyExtent)assignment.getKey(), (TServerInstance)assignment.getValue()));
                    continue;
                }
                Master.log.warn("{} load balancer assigning tablet that was not nominated for assignment {}", (Object)this.store.name(), assignment.getKey());
            }
            if (builder.length() > 0) {
                builder.append("]");
                Master.log.debug("{} assigning tablets: [{}", (Object)this.store.name(), (Object)builder);
            }
            if (!unassigned.isEmpty() && assignedOut.isEmpty()) {
                Master.log.warn("Load balancer failed to assign any tablets");
            }
        }
        if (assignments.size() > 0) {
            Master.log.info(String.format("Assigning %d tablets", assignments.size()));
            this.store.setFutureLocations(assignments);
        }
        assignments.addAll(assigned);
        for (Assignment a : assignments) {
            LiveTServerSet.TServerConnection client = this.master.tserverSet.getConnection(a.server);
            if (client != null) {
                client.assignTablet(this.master.masterLock, a.tablet);
            } else {
                Master.log.warn("Could not connect to server {}", (Object)a.server);
            }
            this.master.assignedTablet(a.tablet);
        }
    }
}

