/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.master.metrics;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.accumulo.core.client.impl.ClientContext;
import org.apache.accumulo.core.client.impl.Table;
import org.apache.accumulo.core.client.impl.Tables;
import org.apache.accumulo.core.master.state.tables.TableState;
import org.apache.accumulo.core.replication.ReplicationTable;
import org.apache.accumulo.core.replication.ReplicationTarget;
import org.apache.accumulo.master.Master;
import org.apache.accumulo.server.metrics.Metrics;
import org.apache.accumulo.server.metrics.MetricsSystemHelper;
import org.apache.accumulo.server.replication.ReplicationUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.metrics2.MetricsCollector;
import org.apache.hadoop.metrics2.MetricsInfo;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.metrics2.MetricsSource;
import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.impl.MsInfo;
import org.apache.hadoop.metrics2.lib.Interns;
import org.apache.hadoop.metrics2.lib.MetricsRegistry;
import org.apache.hadoop.metrics2.lib.MutableQuantiles;
import org.apache.hadoop.metrics2.lib.MutableStat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Metrics2ReplicationMetrics
implements Metrics,
MetricsSource {
    public static final String NAME = "Master,sub=Replication";
    public static final String DESCRIPTION = "Data-Center Replication Metrics";
    public static final String CONTEXT = "master";
    public static final String RECORD = "MasterReplication";
    public static final String PENDING_FILES = "filesPendingReplication";
    public static final String NUM_PEERS = "numPeers";
    public static final String MAX_REPLICATION_THREADS = "maxReplicationThreads";
    public static final String REPLICATION_QUEUE_TIME_QUANTILES = "replicationQueue10m";
    public static final String REPLICATION_QUEUE_TIME = "replicationQueue";
    private static final Logger log = LoggerFactory.getLogger(Metrics2ReplicationMetrics.class);
    private final Master master;
    private final MetricsSystem system;
    private final MetricsRegistry registry;
    private final ReplicationUtil replicationUtil;
    private final MutableQuantiles replicationQueueTimeQuantiles;
    private final MutableStat replicationQueueTimeStat;
    private final Map<Path, Long> pathModTimes;

    Metrics2ReplicationMetrics(Master master, MetricsSystem system) {
        this.master = master;
        this.system = system;
        this.pathModTimes = new HashMap<Path, Long>();
        this.registry = new MetricsRegistry(Interns.info((String)NAME, (String)DESCRIPTION));
        this.registry.tag((MetricsInfo)MsInfo.ProcessName, MetricsSystemHelper.getProcessName());
        this.replicationUtil = new ReplicationUtil(master.getContext());
        this.replicationQueueTimeQuantiles = this.registry.newQuantiles(REPLICATION_QUEUE_TIME_QUANTILES, "Replication queue time quantiles in milliseconds", "ops", "latency", 600);
        this.replicationQueueTimeStat = this.registry.newStat(REPLICATION_QUEUE_TIME, "Replication queue time statistics in milliseconds", "ops", "latency", true);
    }

    protected void snapshot() {
        if (TableState.ONLINE == Tables.getTableState((ClientContext)this.master.getContext(), (Table.ID)ReplicationTable.ID) && !this.replicationUtil.getPeers().isEmpty()) {
            this.registry.add(PENDING_FILES, (long)this.getNumFilesPendingReplication());
            this.addReplicationQueueTimeMetrics();
        } else {
            this.registry.add(PENDING_FILES, 0L);
        }
        this.registry.add(NUM_PEERS, (long)this.getNumConfiguredPeers());
        this.registry.add(MAX_REPLICATION_THREADS, (long)this.getMaxReplicationThreads());
    }

    public void getMetrics(MetricsCollector collector, boolean all) {
        MetricsRecordBuilder builder = collector.addRecord(RECORD).setContext(CONTEXT);
        this.snapshot();
        this.registry.snapshot(builder, all);
        this.replicationQueueTimeQuantiles.snapshot(builder, all);
        this.replicationQueueTimeStat.snapshot(builder, all);
    }

    public void register() throws Exception {
        this.system.register(NAME, DESCRIPTION, (Object)this);
    }

    public void add(String name, long time) {
        throw new UnsupportedOperationException("add() is not implemented");
    }

    public boolean isEnabled() {
        return true;
    }

    protected int getNumFilesPendingReplication() {
        Set allConfiguredTargets = this.replicationUtil.getReplicationTargets();
        Map targetCounts = this.replicationUtil.getPendingReplications();
        int filesPending = 0;
        for (ReplicationTarget configuredTarget : allConfiguredTargets) {
            Long numFiles = (Long)targetCounts.get(configuredTarget);
            if (null == numFiles) continue;
            filesPending = (int)((long)filesPending + numFiles);
        }
        return filesPending;
    }

    protected int getNumConfiguredPeers() {
        return this.replicationUtil.getPeers().size();
    }

    protected int getMaxReplicationThreads() {
        return this.replicationUtil.getMaxReplicationThreads(this.master.getMasterMonitorInfo());
    }

    protected void addReplicationQueueTimeMetrics() {
        Set paths = this.replicationUtil.getPendingReplicationPaths();
        long currentTime = this.getCurrentTime();
        for (Path path : paths) {
            if (this.pathModTimes.containsKey(path)) continue;
            try {
                this.pathModTimes.put(path, this.master.getFileSystem().getFileStatus(path).getModificationTime());
            }
            catch (IOException e) {
                log.trace("Failed to get file status for {}, file system is unavailable or it does not exist", (Object)path);
            }
        }
        HashSet<Path> deletedPaths = new HashSet<Path>(this.pathModTimes.keySet());
        deletedPaths.removeAll(paths);
        if (deletedPaths.isEmpty()) {
            return;
        }
        this.replicationQueueTimeStat.resetMinMax();
        for (Path path : deletedPaths) {
            Long modTime = this.pathModTimes.remove(path);
            if (modTime == null) continue;
            long diff = Math.max(0L, currentTime - modTime);
            this.replicationQueueTimeQuantiles.add(diff);
            this.replicationQueueTimeStat.add(diff);
        }
    }

    protected long getCurrentTime() {
        return System.currentTimeMillis();
    }
}

