/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.master.tableOps;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import org.apache.accumulo.core.client.impl.AbstractId;
import org.apache.accumulo.core.client.impl.AcceptableThriftTableOperationException;
import org.apache.accumulo.core.client.impl.ClientContext;
import org.apache.accumulo.core.client.impl.Namespace;
import org.apache.accumulo.core.client.impl.Namespaces;
import org.apache.accumulo.core.client.impl.Table;
import org.apache.accumulo.core.client.impl.Tables;
import org.apache.accumulo.core.client.impl.thrift.TableOperation;
import org.apache.accumulo.core.client.impl.thrift.TableOperationExceptionType;
import org.apache.accumulo.fate.zookeeper.DistributedReadWriteLock;
import org.apache.accumulo.fate.zookeeper.IZooReaderWriter;
import org.apache.accumulo.fate.zookeeper.ZooQueueLock;
import org.apache.accumulo.fate.zookeeper.ZooReaderWriter;
import org.apache.accumulo.fate.zookeeper.ZooReservation;
import org.apache.accumulo.fate.zookeeper.ZooUtil;
import org.apache.accumulo.master.Master;
import org.apache.accumulo.server.ServerContext;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.io.Text;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Utils {
    private static final byte[] ZERO_BYTE = new byte[]{48};
    private static final Logger log = LoggerFactory.getLogger(Utils.class);
    static final Lock tableNameLock = new ReentrantLock();
    static final Lock idLock = new ReentrantLock();

    public static void checkTableDoesNotExist(ServerContext context, String tableName, Table.ID tableId, TableOperation operation) throws AcceptableThriftTableOperationException {
        Table.ID id = (Table.ID)Tables.getNameToIdMap((ClientContext)context).get(tableName);
        if (id != null && !id.equals((Object)tableId)) {
            throw new AcceptableThriftTableOperationException(null, tableName, operation, TableOperationExceptionType.EXISTS, null);
        }
    }

    public static <T extends AbstractId> T getNextId(String name, ServerContext context, Function<String, T> newIdFunction) throws AcceptableThriftTableOperationException {
        try {
            ZooReaderWriter zoo = context.getZooReaderWriter();
            String ntp = context.getZooKeeperRoot() + "/tables";
            byte[] nid = zoo.mutate(ntp, ZERO_BYTE, ZooUtil.PUBLIC, currentValue -> {
                BigInteger nextId = new BigInteger(new String(currentValue, StandardCharsets.UTF_8), 36);
                nextId = nextId.add(BigInteger.ONE);
                return nextId.toString(36).getBytes(StandardCharsets.UTF_8);
            });
            return (T)((AbstractId)newIdFunction.apply(new String(nid, StandardCharsets.UTF_8)));
        }
        catch (Exception e1) {
            log.error("Failed to assign id to " + name, (Throwable)e1);
            throw new AcceptableThriftTableOperationException(null, name, TableOperation.CREATE, TableOperationExceptionType.OTHER, e1.getMessage());
        }
    }

    public static long reserveTable(Master env, Table.ID tableId, long tid, boolean writeLock, boolean tableMustExist, TableOperation op) throws Exception {
        if (Utils.getLock(env.getContext(), (AbstractId)tableId, tid, writeLock).tryLock()) {
            ZooReaderWriter zk;
            if (tableMustExist && !(zk = env.getContext().getZooReaderWriter()).exists(env.getContext().getZooKeeperRoot() + "/tables" + "/" + tableId)) {
                throw new AcceptableThriftTableOperationException(tableId.canonicalID(), "", op, TableOperationExceptionType.NOTFOUND, "Table does not exist");
            }
            log.info("table {} ({}) locked for {} operation: {}", new Object[]{tableId, Long.toHexString(tid), writeLock ? "write" : "read", op});
            return 0L;
        }
        return 100L;
    }

    public static void unreserveTable(Master env, Table.ID tableId, long tid, boolean writeLock) throws Exception {
        Utils.getLock(env.getContext(), (AbstractId)tableId, tid, writeLock).unlock();
        log.info("table {} ({}) unlocked for ", new Object[]{tableId, Long.toHexString(tid), writeLock ? "write" : "read"});
    }

    public static void unreserveNamespace(Master env, Namespace.ID namespaceId, long id, boolean writeLock) throws Exception {
        Utils.getLock(env.getContext(), (AbstractId)namespaceId, id, writeLock).unlock();
        log.info("namespace {} ({}) unlocked for {}", new Object[]{namespaceId, Long.toHexString(id), writeLock ? "write" : "read"});
    }

    public static long reserveNamespace(Master env, Namespace.ID namespaceId, long id, boolean writeLock, boolean mustExist, TableOperation op) throws Exception {
        if (Utils.getLock(env.getContext(), (AbstractId)namespaceId, id, writeLock).tryLock()) {
            ZooReaderWriter zk;
            if (mustExist && !(zk = env.getContext().getZooReaderWriter()).exists(env.getContext().getZooKeeperRoot() + "/namespaces" + "/" + namespaceId)) {
                throw new AcceptableThriftTableOperationException(namespaceId.canonicalID(), "", op, TableOperationExceptionType.NAMESPACE_NOTFOUND, "Namespace does not exist");
            }
            log.info("namespace {} ({}) locked for {} operation: {}", new Object[]{namespaceId, Long.toHexString(id), writeLock ? "write" : "read", op});
            return 0L;
        }
        return 100L;
    }

    public static long reserveHdfsDirectory(Master env, String directory, long tid) throws KeeperException, InterruptedException {
        String resvPath = env.getContext().getZooKeeperRoot() + "/hdfs_reservations" + "/" + Base64.getEncoder().encodeToString(directory.getBytes(StandardCharsets.UTF_8));
        ZooReaderWriter zk = env.getContext().getZooReaderWriter();
        if (ZooReservation.attempt((IZooReaderWriter)zk, (String)resvPath, (String)String.format("%016x", tid), (String)"")) {
            return 0L;
        }
        return 50L;
    }

    public static void unreserveHdfsDirectory(Master env, String directory, long tid) throws KeeperException, InterruptedException {
        String resvPath = env.getContext().getZooKeeperRoot() + "/hdfs_reservations" + "/" + Base64.getEncoder().encodeToString(directory.getBytes(StandardCharsets.UTF_8));
        ZooReservation.release((IZooReaderWriter)env.getContext().getZooReaderWriter(), (String)resvPath, (String)String.format("%016x", tid));
    }

    private static Lock getLock(ServerContext context, AbstractId id, long tid, boolean writeLock) throws Exception {
        byte[] lockData = String.format("%016x", tid).getBytes(StandardCharsets.UTF_8);
        ZooQueueLock qlock = new ZooQueueLock((IZooReaderWriter)context.getZooReaderWriter(), context.getZooKeeperRoot() + "/table_locks" + "/" + id, false);
        Lock lock = DistributedReadWriteLock.recoverLock((DistributedReadWriteLock.QueueLock)qlock, (byte[])lockData);
        if (lock == null) {
            DistributedReadWriteLock locker = new DistributedReadWriteLock((DistributedReadWriteLock.QueueLock)qlock, lockData);
            lock = writeLock ? locker.writeLock() : locker.readLock();
        }
        return lock;
    }

    public static Lock getIdLock() {
        return idLock;
    }

    public static Lock getTableNameLock() {
        return tableNameLock;
    }

    public static Lock getReadLock(Master env, AbstractId tableId, long tid) throws Exception {
        return Utils.getLock(env.getContext(), tableId, tid, false);
    }

    public static void checkNamespaceDoesNotExist(ServerContext context, String namespace, Namespace.ID namespaceId, TableOperation operation) throws AcceptableThriftTableOperationException {
        Namespace.ID n = Namespaces.lookupNamespaceId((ClientContext)context, (String)namespace);
        if (n != null && !n.equals((Object)namespaceId)) {
            throw new AcceptableThriftTableOperationException(null, namespace, operation, TableOperationExceptionType.NAMESPACE_EXISTS, null);
        }
    }

    public static SortedSet<Text> getSortedSetFromFile(FSDataInputStream inputStream, boolean encoded) throws IOException {
        TreeSet<Text> data = new TreeSet<Text>();
        try (BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)inputStream));){
            String line;
            while ((line = br.readLine()) != null) {
                if (encoded) {
                    data.add(new Text(Base64.getDecoder().decode(line)));
                    continue;
                }
                data.add(new Text(line));
            }
        }
        return data;
    }
}

