/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.master.tableOps.bulkVer2;

import java.io.IOException;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.impl.AbstractId;
import org.apache.accumulo.core.client.impl.Table;
import org.apache.accumulo.core.master.state.tables.TableState;
import org.apache.accumulo.fate.Repo;
import org.apache.accumulo.master.Master;
import org.apache.accumulo.master.tableOps.MasterRepo;
import org.apache.accumulo.master.tableOps.Utils;
import org.apache.accumulo.master.tableOps.bulkVer2.BulkInfo;
import org.apache.accumulo.server.ServerContext;
import org.apache.accumulo.server.util.MetadataTableUtil;
import org.apache.accumulo.server.zookeeper.TransactionWatcher;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CleanUpBulkImport
extends MasterRepo {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(CleanUpBulkImport.class);
    private BulkInfo info;

    public CleanUpBulkImport(BulkInfo info) {
        this.info = info;
    }

    @Override
    public Repo<Master> call(long tid, Master master) throws Exception {
        log.debug("removing the bulkDir processing flag file in " + this.info.bulkDir);
        Path bulkDir = new Path(this.info.bulkDir);
        MetadataTableUtil.removeBulkLoadInProgressFlag((ServerContext)master.getContext(), (String)("/" + bulkDir.getParent().getName() + "/" + bulkDir.getName()));
        MetadataTableUtil.addDeleteEntry((ServerContext)master.getContext(), (Table.ID)this.info.tableId, (String)bulkDir.toString());
        if (this.info.tableState == TableState.ONLINE) {
            log.debug("removing the metadata table markers for loaded files");
            AccumuloClient client = master.getClient();
            MetadataTableUtil.removeBulkLoadEntries((AccumuloClient)client, (Table.ID)this.info.tableId, (long)tid);
        }
        Utils.unreserveHdfsDirectory(master, this.info.sourceDir, tid);
        Utils.getReadLock(master, (AbstractId)this.info.tableId, tid).unlock();
        Path renamingFile = new Path(bulkDir, "renames.json");
        Path mappingFile = new Path(bulkDir, "loadmap.json");
        try {
            master.getFileSystem().delete(renamingFile);
            master.getFileSystem().delete(mappingFile);
        }
        catch (IOException ioe) {
            log.debug("Failed to delete renames and/or loadmap", (Throwable)ioe);
        }
        log.debug("completing bulkDir import transaction " + tid);
        if (this.info.tableState == TableState.ONLINE) {
            TransactionWatcher.ZooArbitrator.cleanup((ServerContext)master.getContext(), (String)"bulkTx", (long)tid);
        }
        return null;
    }
}

