/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.master.tableOps.bulkVer2;

import com.google.common.base.Preconditions;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.MutationsRejectedException;
import org.apache.accumulo.core.client.impl.Bulk;
import org.apache.accumulo.core.client.impl.BulkSerialize;
import org.apache.accumulo.core.client.impl.ClientContext;
import org.apache.accumulo.core.client.impl.Table;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.impl.KeyExtent;
import org.apache.accumulo.core.data.thrift.MapFileInfo;
import org.apache.accumulo.core.master.state.tables.TableState;
import org.apache.accumulo.core.metadata.schema.DataFileValue;
import org.apache.accumulo.core.metadata.schema.MetadataScanner;
import org.apache.accumulo.core.metadata.schema.MetadataSchema;
import org.apache.accumulo.core.metadata.schema.TabletMetadata;
import org.apache.accumulo.core.rpc.ThriftUtil;
import org.apache.accumulo.core.tabletserver.thrift.TabletClientService;
import org.apache.accumulo.core.trace.Tracer;
import org.apache.accumulo.core.util.HostAndPort;
import org.apache.accumulo.core.util.MapCounter;
import org.apache.accumulo.core.util.TextUtil;
import org.apache.accumulo.fate.Repo;
import org.apache.accumulo.master.Master;
import org.apache.accumulo.master.tableOps.MasterRepo;
import org.apache.accumulo.master.tableOps.bulkVer2.BulkInfo;
import org.apache.accumulo.master.tableOps.bulkVer2.CleanUpBulkImport;
import org.apache.accumulo.master.tableOps.bulkVer2.CompleteBulkImport;
import org.apache.accumulo.server.fs.VolumeManager;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.thrift.TException;
import org.apache.thrift.TServiceClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LoadFiles
extends MasterRepo {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(LoadFiles.class);
    private final BulkInfo bulkInfo;

    public LoadFiles(BulkInfo bulkInfo) {
        this.bulkInfo = bulkInfo;
    }

    @Override
    public long isReady(long tid, Master master) throws Exception {
        if (master.onlineTabletServers().size() == 0) {
            log.warn("There are no tablet server to process bulkDir import, waiting (tid = " + tid + ")");
            return 100L;
        }
        VolumeManager fs = master.getFileSystem();
        Path bulkDir = new Path(this.bulkInfo.bulkDir);
        try (BulkSerialize.LoadMappingIterator lmi = BulkSerialize.getUpdatedLoadMapping((String)bulkDir.toString(), (Table.ID)this.bulkInfo.tableId, p -> fs.open(p));){
            long l = this.loadFiles(this.bulkInfo.tableId, bulkDir, lmi, master, tid);
            return l;
        }
    }

    @Override
    public Repo<Master> call(long tid, Master master) throws Exception {
        if (this.bulkInfo.tableState == TableState.ONLINE) {
            return new CompleteBulkImport(this.bulkInfo);
        }
        return new CleanUpBulkImport(this.bulkInfo);
    }

    private long loadFiles(Table.ID tableId, Path bulkDir, BulkSerialize.LoadMappingIterator lmi, Master master, long tid) throws Exception {
        Map.Entry loadMapEntry = lmi.next();
        Text startRow = ((KeyExtent)loadMapEntry.getKey()).getPrevEndRow();
        Iterator tabletIter = MetadataScanner.builder().from((ClientContext)master.getContext()).scanMetadataTable().overRange(tableId, startRow, null).checkConsistency().fetchPrev().fetchLocation().fetchLoaded().build().iterator();
        ArrayList<TabletMetadata> tablets = new ArrayList<TabletMetadata>();
        TabletMetadata currentTablet = (TabletMetadata)tabletIter.next();
        Loader loader = this.bulkInfo.tableState == TableState.ONLINE ? new OnlineLoader() : new OfflineLoader();
        loader.start(bulkDir, master, tid, this.bulkInfo.setTime);
        long t1 = System.currentTimeMillis();
        while (true) {
            if (loadMapEntry == null) {
                if (!lmi.hasNext()) break;
                loadMapEntry = lmi.next();
            }
            KeyExtent fke = (KeyExtent)loadMapEntry.getKey();
            Bulk.Files files = (Bulk.Files)loadMapEntry.getValue();
            loadMapEntry = null;
            tablets.clear();
            while (!Objects.equals(currentTablet.getPrevEndRow(), fke.getPrevEndRow())) {
                currentTablet = (TabletMetadata)tabletIter.next();
            }
            tablets.add(currentTablet);
            while (!Objects.equals(currentTablet.getEndRow(), fke.getEndRow())) {
                currentTablet = (TabletMetadata)tabletIter.next();
                tablets.add(currentTablet);
            }
            loader.load(tablets, files);
        }
        long t2 = System.currentTimeMillis();
        long sleepTime = loader.finish();
        if (sleepTime > 0L) {
            long scanTime = Math.min(t2 - t1, 30000L);
            sleepTime = Math.max(sleepTime, scanTime * 2L);
        }
        return sleepTime;
    }

    private static class OfflineLoader
    extends Loader {
        BatchWriter bw;
        MapCounter<HostAndPort> unloadingTablets;

        private OfflineLoader() {
        }

        @Override
        void start(Path bulkDir, Master master, long tid, boolean setTime) throws Exception {
            Preconditions.checkArgument((!setTime ? 1 : 0) != 0);
            super.start(bulkDir, master, tid, setTime);
            this.bw = master.getClient().createBatchWriter("accumulo.metadata");
            this.unloadingTablets = new MapCounter();
        }

        @Override
        void load(List<TabletMetadata> tablets, Bulk.Files files) throws MutationsRejectedException {
            byte[] fam = TextUtil.getBytes((Text)MetadataSchema.TabletsSection.DataFileColumnFamily.NAME);
            for (TabletMetadata tablet : tablets) {
                if (tablet.getLocation() != null) {
                    this.unloadingTablets.increment((Object)tablet.getLocation().getHostAndPort(), 1L);
                    continue;
                }
                Mutation mutation = new Mutation(tablet.getExtent().getMetadataEntry());
                for (Bulk.FileInfo fileInfo : files) {
                    String fullPath = new Path(this.bulkDir, fileInfo.getFileName()).toString();
                    byte[] val = new DataFileValue(fileInfo.getEstFileSize(), fileInfo.getEstNumEntries()).encode();
                    mutation.put(fam, fullPath.getBytes(StandardCharsets.UTF_8), val);
                }
                this.bw.addMutation(mutation);
            }
        }

        @Override
        long finish() throws Exception {
            this.bw.close();
            long sleepTime = 0L;
            if (this.unloadingTablets.size() > 0) {
                sleepTime = (Long)Collections.max(this.unloadingTablets.values()) * 13L;
            }
            return sleepTime;
        }
    }

    private static class OnlineLoader
    extends Loader {
        long timeInMillis;
        String fmtTid;
        int locationLess = 0;
        MapCounter<HostAndPort> loadMsgs;

        private OnlineLoader() {
        }

        @Override
        void start(Path bulkDir, Master master, long tid, boolean setTime) throws Exception {
            super.start(bulkDir, master, tid, setTime);
            this.timeInMillis = master.getConfiguration().getTimeInMillis(Property.MASTER_BULK_TIMEOUT);
            this.fmtTid = String.format("%016x", tid);
            this.loadMsgs = new MapCounter();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void load(List<TabletMetadata> tablets, Bulk.Files files) {
            for (TabletMetadata tablet : tablets) {
                TabletMetadata.Location location = tablet.getLocation();
                HostAndPort server = null;
                if (location == null) {
                    ++this.locationLess;
                    continue;
                }
                server = location.getHostAndPort();
                Set loadedFiles = tablet.getLoaded();
                HashMap<String, MapFileInfo> thriftImports = new HashMap<String, MapFileInfo>();
                for (Bulk.FileInfo fileInfo : files) {
                    String fullPath = new Path(this.bulkDir, fileInfo.getFileName()).toString();
                    if (loadedFiles.contains(fullPath)) continue;
                    thriftImports.put(fileInfo.getFileName(), new MapFileInfo(fileInfo.getEstFileSize()));
                }
                if (thriftImports.size() <= 0) continue;
                this.loadMsgs.increment((Object)server, 1L);
                log.trace("tid {} asking {} to bulk import {} files", new Object[]{this.fmtTid, server, thriftImports.size()});
                TabletClientService.Client client = null;
                try {
                    client = ThriftUtil.getTServerClient((HostAndPort)server, (ClientContext)this.master.getContext(), (long)this.timeInMillis);
                    client.loadFiles(Tracer.traceInfo(), this.master.getContext().rpcCreds(), this.tid, tablet.getExtent().toThrift(), this.bulkDir.toString(), thriftImports, this.setTime);
                }
                catch (TException ex) {
                    try {
                        log.debug("rpc failed server: " + server + ", tid:" + this.fmtTid + " " + ex.getMessage(), (Throwable)ex);
                    }
                    catch (Throwable throwable) {
                        ThriftUtil.returnClient(client);
                        throw throwable;
                    }
                    ThriftUtil.returnClient((TServiceClient)client);
                    continue;
                }
                ThriftUtil.returnClient((TServiceClient)client);
            }
        }

        @Override
        long finish() {
            long sleepTime = 0L;
            if (this.loadMsgs.size() > 0) {
                sleepTime = (Long)Collections.max(this.loadMsgs.values()) * 13L;
            }
            if (this.locationLess > 0) {
                sleepTime = Math.max(Math.max(100L, (long)this.locationLess), sleepTime);
            }
            return sleepTime;
        }
    }

    private static abstract class Loader {
        protected Path bulkDir;
        protected Master master;
        protected long tid;
        protected boolean setTime;

        private Loader() {
        }

        void start(Path bulkDir, Master master, long tid, boolean setTime) throws Exception {
            this.bulkDir = bulkDir;
            this.master = master;
            this.tid = tid;
            this.setTime = setTime;
        }

        abstract void load(List<TabletMetadata> var1, Bulk.Files var2) throws Exception;

        abstract long finish() throws Exception;
    }
}

