/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.master.tableOps.compact.cancel;

import java.nio.charset.StandardCharsets;
import org.apache.accumulo.core.client.impl.Namespace;
import org.apache.accumulo.core.client.impl.Table;
import org.apache.accumulo.core.client.impl.thrift.TableOperation;
import org.apache.accumulo.fate.Repo;
import org.apache.accumulo.fate.zookeeper.IZooReaderWriter;
import org.apache.accumulo.fate.zookeeper.ZooReaderWriter;
import org.apache.accumulo.master.Master;
import org.apache.accumulo.master.tableOps.MasterRepo;
import org.apache.accumulo.master.tableOps.Utils;
import org.apache.accumulo.master.tableOps.compact.cancel.FinishCancelCompaction;

public class CancelCompactions
extends MasterRepo {
    private static final long serialVersionUID = 1L;
    private Table.ID tableId;
    private Namespace.ID namespaceId;

    public CancelCompactions(Namespace.ID namespaceId, Table.ID tableId) {
        this.tableId = tableId;
        this.namespaceId = namespaceId;
    }

    @Override
    public long isReady(long tid, Master env) throws Exception {
        return Utils.reserveNamespace(env, this.namespaceId, tid, false, true, TableOperation.COMPACT_CANCEL) + Utils.reserveTable(env, this.tableId, tid, false, true, TableOperation.COMPACT_CANCEL);
    }

    @Override
    public Repo<Master> call(long tid, Master environment) throws Exception {
        String zCompactID = "/accumulo/" + environment.getInstanceID() + "/tables" + "/" + this.tableId + "/compact-id";
        String zCancelID = "/accumulo/" + environment.getInstanceID() + "/tables" + "/" + this.tableId + "/compact-cancel-id";
        ZooReaderWriter zoo = environment.getContext().getZooReaderWriter();
        byte[] currentValue = zoo.getData(zCompactID, null);
        String cvs = new String(currentValue, StandardCharsets.UTF_8);
        String[] tokens = cvs.split(",");
        final long flushID = Long.parseLong(tokens[0]);
        zoo.mutate(zCancelID, null, null, new IZooReaderWriter.Mutator(){

            public byte[] mutate(byte[] currentValue) throws Exception {
                long cid = Long.parseLong(new String(currentValue, StandardCharsets.UTF_8));
                if (cid < flushID) {
                    return Long.toString(flushID).getBytes(StandardCharsets.UTF_8);
                }
                return Long.toString(cid).getBytes(StandardCharsets.UTF_8);
            }
        });
        return new FinishCancelCompaction(this.namespaceId, this.tableId);
    }

    @Override
    public void undo(long tid, Master env) throws Exception {
        Utils.unreserveTable(env, this.tableId, tid, false);
        Utils.unreserveNamespace(env, this.namespaceId, tid, false);
    }
}

