/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.master.tableOps.create;

import java.io.IOException;
import java.util.SortedSet;
import org.apache.accumulo.fate.Repo;
import org.apache.accumulo.master.Master;
import org.apache.accumulo.master.tableOps.MasterRepo;
import org.apache.accumulo.master.tableOps.TableInfo;
import org.apache.accumulo.master.tableOps.Utils;
import org.apache.accumulo.master.tableOps.create.PopulateMetadata;
import org.apache.accumulo.server.fs.VolumeManager;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;

class CreateDir
extends MasterRepo {
    private static final long serialVersionUID = 1L;
    private final TableInfo tableInfo;

    CreateDir(TableInfo ti) {
        this.tableInfo = ti;
    }

    @Override
    public long isReady(long tid, Master environment) throws Exception {
        return 0L;
    }

    @Override
    public Repo<Master> call(long tid, Master master) throws Exception {
        VolumeManager fs = master.getFileSystem();
        fs.mkdirs(new Path(this.tableInfo.defaultTabletDir));
        if (this.tableInfo.getInitialSplitSize() > 0) {
            SortedSet<Text> dirInfo = Utils.getSortedSetFromFile(master.getInputStream(this.tableInfo.getSplitDirsFile()), false);
            this.createTabletDirectories(master.getFileSystem(), dirInfo);
        }
        return new PopulateMetadata(this.tableInfo);
    }

    @Override
    public void undo(long tid, Master master) throws Exception {
        VolumeManager fs = master.getFileSystem();
        fs.deleteRecursively(new Path(this.tableInfo.defaultTabletDir));
        if (this.tableInfo.getInitialSplitSize() > 0) {
            SortedSet<Text> dirInfo = Utils.getSortedSetFromFile(master.getInputStream(this.tableInfo.getSplitDirsFile()), false);
            for (Text dirname : dirInfo) {
                fs.deleteRecursively(new Path(dirname.toString()));
            }
        }
    }

    private void createTabletDirectories(VolumeManager fs, SortedSet<Text> dirInfo) throws IOException {
        for (Text dir : dirInfo) {
            if (fs.mkdirs(new Path(dir.toString()))) continue;
            throw new IOException("Failed to create tablet directory: " + dir);
        }
    }
}

