/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.master.tableOps.create;

import java.util.Map;
import org.apache.accumulo.core.client.admin.InitialTableState;
import org.apache.accumulo.core.client.admin.TimeType;
import org.apache.accumulo.core.client.impl.Namespace;
import org.apache.accumulo.core.client.impl.Table;
import org.apache.accumulo.core.client.impl.thrift.TableOperation;
import org.apache.accumulo.fate.Repo;
import org.apache.accumulo.master.Master;
import org.apache.accumulo.master.tableOps.MasterRepo;
import org.apache.accumulo.master.tableOps.TableInfo;
import org.apache.accumulo.master.tableOps.Utils;
import org.apache.accumulo.master.tableOps.create.SetupPermissions;
import org.apache.accumulo.server.tablets.TabletTime;

public class CreateTable
extends MasterRepo {
    private static final long serialVersionUID = 1L;
    private TableInfo tableInfo = new TableInfo();

    public CreateTable(String user, String tableName, TimeType timeType, Map<String, String> props, String splitFile, int splitCount, String splitDirsFile, InitialTableState initialTableState, Namespace.ID namespaceId) {
        this.tableInfo.setTableName(tableName);
        this.tableInfo.setTimeType(TabletTime.getTimeID((TimeType)timeType));
        this.tableInfo.setUser(user);
        this.tableInfo.props = props;
        this.tableInfo.setNamespaceId(namespaceId);
        this.tableInfo.setSplitFile(splitFile);
        this.tableInfo.setInitialSplitSize(splitCount);
        this.tableInfo.setInitialTableState(initialTableState);
        this.tableInfo.setSplitDirsFile(splitDirsFile);
    }

    @Override
    public long isReady(long tid, Master environment) throws Exception {
        return Utils.reserveNamespace(environment, this.tableInfo.getNamespaceId(), tid, false, true, TableOperation.CREATE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Repo<Master> call(long tid, Master master) throws Exception {
        Utils.getIdLock().lock();
        try {
            String tName = this.tableInfo.getTableName();
            this.tableInfo.setTableId(Utils.getNextId(tName, master.getContext(), Table.ID::of));
            SetupPermissions setupPermissions = new SetupPermissions(this.tableInfo);
            return setupPermissions;
        }
        finally {
            Utils.getIdLock().unlock();
        }
    }

    @Override
    public void undo(long tid, Master env) throws Exception {
        Utils.unreserveNamespace(env, this.tableInfo.getNamespaceId(), tid, false);
    }
}

