/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.master.tableOps.create;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedSet;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.MutationsRejectedException;
import org.apache.accumulo.core.client.impl.Table;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.data.impl.KeyExtent;
import org.apache.accumulo.core.metadata.schema.MetadataSchema;
import org.apache.accumulo.fate.Repo;
import org.apache.accumulo.fate.zookeeper.ZooLock;
import org.apache.accumulo.master.Master;
import org.apache.accumulo.master.tableOps.MasterRepo;
import org.apache.accumulo.master.tableOps.TableInfo;
import org.apache.accumulo.master.tableOps.Utils;
import org.apache.accumulo.master.tableOps.create.FinishCreateTable;
import org.apache.accumulo.server.ServerContext;
import org.apache.accumulo.server.util.MetadataTableUtil;
import org.apache.hadoop.io.Text;

class PopulateMetadata
extends MasterRepo {
    private static final long serialVersionUID = 1L;
    private final TableInfo tableInfo;

    PopulateMetadata(TableInfo ti) {
        this.tableInfo = ti;
    }

    @Override
    public long isReady(long tid, Master environment) throws Exception {
        return 0L;
    }

    @Override
    public Repo<Master> call(long tid, Master environment) throws Exception {
        KeyExtent extent = new KeyExtent(this.tableInfo.getTableId(), null, null);
        MetadataTableUtil.addTablet((KeyExtent)extent, (String)this.tableInfo.defaultTabletDir, (ServerContext)environment.getContext(), (char)this.tableInfo.getTimeType(), (ZooLock)environment.getMasterLock());
        if (this.tableInfo.getInitialSplitSize() > 0) {
            SortedSet<Text> splits = Utils.getSortedSetFromFile(environment.getInputStream(this.tableInfo.getSplitFile()), true);
            SortedSet<Text> dirs = Utils.getSortedSetFromFile(environment.getInputStream(this.tableInfo.getSplitDirsFile()), false);
            Map<Text, Text> splitDirMap = this.createSplitDirectoryMap(splits, dirs);
            try (BatchWriter bw = environment.getClient().createBatchWriter("accumulo.metadata");){
                this.writeSplitsToMetadataTable(environment.getContext(), this.tableInfo.getTableId(), splits, splitDirMap, this.tableInfo.getTimeType(), environment.getMasterLock(), bw);
            }
        }
        return new FinishCreateTable(this.tableInfo);
    }

    private void writeSplitsToMetadataTable(ServerContext ctx, Table.ID tableId, SortedSet<Text> splits, Map<Text, Text> data, char timeType, ZooLock lock, BatchWriter bw) throws MutationsRejectedException {
        Text prevSplit = null;
        for (Text split : Iterables.concat(splits, Collections.singleton(null))) {
            Mutation mut = new KeyExtent(tableId, split, prevSplit).getPrevRowUpdateMutation();
            Value dirValue = split == null ? new Value((CharSequence)this.tableInfo.defaultTabletDir) : new Value(data.get(split));
            MetadataSchema.TabletsSection.ServerColumnFamily.DIRECTORY_COLUMN.put(mut, dirValue);
            MetadataSchema.TabletsSection.ServerColumnFamily.TIME_COLUMN.put(mut, new Value((CharSequence)(timeType + "0")));
            MetadataTableUtil.putLockID((ServerContext)ctx, (ZooLock)lock, (Mutation)mut);
            prevSplit = split;
            bw.addMutation(mut);
        }
    }

    @Override
    public void undo(long tid, Master environment) throws Exception {
        MetadataTableUtil.deleteTable((Table.ID)this.tableInfo.getTableId(), (boolean)false, (ServerContext)environment.getContext(), (ZooLock)environment.getMasterLock());
    }

    private Map<Text, Text> createSplitDirectoryMap(SortedSet<Text> splits, SortedSet<Text> dirs) {
        Preconditions.checkArgument((splits.size() == dirs.size() ? 1 : 0) != 0);
        HashMap<Text, Text> data = new HashMap<Text, Text>();
        Iterator s = splits.iterator();
        Iterator d = dirs.iterator();
        while (s.hasNext() && d.hasNext()) {
            data.put((Text)s.next(), (Text)d.next());
        }
        return data;
    }
}

