/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.master.tableOps.create;

import org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException;
import org.apache.accumulo.core.security.TablePermission;
import org.apache.accumulo.fate.Repo;
import org.apache.accumulo.master.Master;
import org.apache.accumulo.master.tableOps.MasterRepo;
import org.apache.accumulo.master.tableOps.TableInfo;
import org.apache.accumulo.master.tableOps.create.PopulateZookeeper;
import org.apache.accumulo.server.ServerContext;
import org.apache.accumulo.server.security.AuditedSecurityOperation;
import org.apache.accumulo.server.security.SecurityOperation;
import org.slf4j.LoggerFactory;

class SetupPermissions
extends MasterRepo {
    private static final long serialVersionUID = 1L;
    private TableInfo tableInfo;

    SetupPermissions(TableInfo ti) {
        this.tableInfo = ti;
    }

    @Override
    public Repo<Master> call(long tid, Master env) throws Exception {
        SecurityOperation security = AuditedSecurityOperation.getInstance((ServerContext)env.getContext());
        if (!this.tableInfo.getUser().equals(env.getContext().getCredentials().getPrincipal())) {
            for (TablePermission permission : TablePermission.values()) {
                try {
                    security.grantTablePermission(env.getContext().rpcCreds(), this.tableInfo.getUser(), this.tableInfo.getTableId(), permission, this.tableInfo.getNamespaceId());
                }
                catch (ThriftSecurityException e) {
                    LoggerFactory.getLogger(SetupPermissions.class).error("{}", (Object)e.getMessage(), (Object)e);
                    throw e;
                }
            }
        }
        return new PopulateZookeeper(this.tableInfo);
    }

    @Override
    public void undo(long tid, Master env) throws Exception {
        AuditedSecurityOperation.getInstance((ServerContext)env.getContext()).deleteTable(env.getContext().rpcCreds(), this.tableInfo.getTableId(), this.tableInfo.getNamespaceId());
    }
}

