/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.master.tableOps.delete;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Map;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.BatchScanner;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.ScannerBase;
import org.apache.accumulo.core.client.impl.ClientContext;
import org.apache.accumulo.core.client.impl.Namespace;
import org.apache.accumulo.core.client.impl.Table;
import org.apache.accumulo.core.client.impl.Tables;
import org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.data.impl.KeyExtent;
import org.apache.accumulo.core.iterators.user.GrepIterator;
import org.apache.accumulo.core.metadata.schema.MetadataSchema;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.fate.Repo;
import org.apache.accumulo.master.Master;
import org.apache.accumulo.master.tableOps.MasterRepo;
import org.apache.accumulo.master.tableOps.Utils;
import org.apache.accumulo.server.ServerConstants;
import org.apache.accumulo.server.ServerContext;
import org.apache.accumulo.server.fs.VolumeManager;
import org.apache.accumulo.server.master.state.CurrentState;
import org.apache.accumulo.server.master.state.MetaDataTableScanner;
import org.apache.accumulo.server.master.state.TabletLocationState;
import org.apache.accumulo.server.master.state.TabletState;
import org.apache.accumulo.server.problems.ProblemReports;
import org.apache.accumulo.server.security.AuditedSecurityOperation;
import org.apache.accumulo.server.util.MetadataTableUtil;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CleanUp
extends MasterRepo {
    private static final Logger log = LoggerFactory.getLogger(CleanUp.class);
    private static final long serialVersionUID = 1L;
    private Table.ID tableId;
    private Namespace.ID namespaceId;
    private long creationTime;

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (System.currentTimeMillis() < this.creationTime) {
            this.creationTime = System.currentTimeMillis();
        }
    }

    public CleanUp(Table.ID tableId, Namespace.ID namespaceId) {
        this.tableId = tableId;
        this.namespaceId = namespaceId;
        this.creationTime = System.currentTimeMillis();
    }

    @Override
    public long isReady(long tid, Master master) throws Exception {
        if (!master.hasCycled(this.creationTime)) {
            return 50L;
        }
        boolean done = true;
        Range tableRange = new KeyExtent(this.tableId, null, null).toMetadataRange();
        Scanner scanner = master.getClient().createScanner("accumulo.metadata", Authorizations.EMPTY);
        MetaDataTableScanner.configureScanner((ScannerBase)scanner, (CurrentState)master);
        scanner.setRange(tableRange);
        for (Map.Entry entry : scanner) {
            TabletLocationState locationState = MetaDataTableScanner.createTabletLocationState((Key)((Key)entry.getKey()), (Value)((Value)entry.getValue()));
            TabletState state = locationState.getState(master.onlineTabletServers());
            if (!state.equals((Object)TabletState.ASSIGNED) && !state.equals((Object)TabletState.HOSTED)) continue;
            log.debug("Still waiting for table to be deleted: " + this.tableId + " locationState: " + locationState);
            done = false;
            break;
        }
        if (!done) {
            return 50L;
        }
        return 0L;
    }

    @Override
    public Repo<Master> call(long tid, Master master) throws Exception {
        master.clearMigrations(this.tableId);
        int refCount = 0;
        try {
            AccumuloClient client = master.getClient();
            try (BatchScanner bs = client.createBatchScanner("accumulo.metadata", Authorizations.EMPTY, 8);){
                Range allTables = MetadataSchema.TabletsSection.getRange();
                Range tableRange = MetadataSchema.TabletsSection.getRange((Table.ID)this.tableId);
                Range beforeTable = new Range(allTables.getStartKey(), true, tableRange.getStartKey(), false);
                Range afterTable = new Range(tableRange.getEndKey(), false, allTables.getEndKey(), true);
                bs.setRanges(Arrays.asList(beforeTable, afterTable));
                bs.fetchColumnFamily(MetadataSchema.TabletsSection.DataFileColumnFamily.NAME);
                IteratorSetting cfg = new IteratorSetting(40, "grep", GrepIterator.class);
                GrepIterator.setTerm((IteratorSetting)cfg, (String)("/" + this.tableId + "/"));
                bs.addScanIterator(cfg);
                for (Map.Entry entry : bs) {
                    if (!((Key)entry.getKey()).getColumnQualifier().toString().contains("/" + this.tableId + "/")) continue;
                    ++refCount;
                }
            }
        }
        catch (Exception e) {
            refCount = -1;
            log.error("Failed to scan accumulo.metadata looking for references to deleted table " + this.tableId, (Throwable)e);
        }
        try {
            MetadataTableUtil.deleteTable((Table.ID)this.tableId, (refCount != 0 ? 1 : 0) != 0, (ServerContext)master.getContext(), null);
        }
        catch (Exception e) {
            log.error("error deleting " + this.tableId + " from metadata table", (Throwable)e);
        }
        try {
            ProblemReports.getInstance((ServerContext)master.getContext()).deleteProblemReports(this.tableId);
        }
        catch (Exception e) {
            log.error("Failed to delete problem reports for table " + this.tableId, (Throwable)e);
        }
        if (refCount == 0) {
            try {
                VolumeManager fs = master.getFileSystem();
                for (String dir : ServerConstants.getTablesDirs((AccumuloConfiguration)master.getConfiguration())) {
                    fs.deleteRecursively(new Path(dir, this.tableId.canonicalID()));
                }
            }
            catch (IOException e) {
                log.error("Unable to remove deleted table directory", (Throwable)e);
            }
            catch (IllegalArgumentException exception) {
                if (exception.getCause() instanceof UnknownHostException) {
                    log.error("Unable to remove deleted table directory", (Throwable)exception);
                }
                throw exception;
            }
        }
        try {
            master.getTableManager().removeTable(this.tableId);
            Tables.clearCache((ClientContext)master.getContext());
        }
        catch (Exception e) {
            log.error("Failed to find table id in zookeeper", (Throwable)e);
        }
        try {
            AuditedSecurityOperation.getInstance((ServerContext)master.getContext()).deleteTable(master.getContext().rpcCreds(), this.tableId, this.namespaceId);
        }
        catch (ThriftSecurityException e) {
            log.error("{}", (Object)e.getMessage(), (Object)e);
        }
        Utils.unreserveTable(master, this.tableId, tid, true);
        Utils.unreserveNamespace(master, this.namespaceId, tid, false);
        LoggerFactory.getLogger(CleanUp.class).debug("Deleted table " + this.tableId);
        return null;
    }

    protected void merge(VolumeManager fs, Path src, Path dest) throws IOException {
        for (FileStatus child : fs.listStatus(src)) {
            String childName = child.getPath().getName();
            Path childInSrc = new Path(src, childName);
            Path childInDest = new Path(dest, childName);
            if (child.isFile()) {
                if (fs.exists(childInDest)) {
                    log.warn("File already exists in archive, ignoring. " + childInDest);
                    continue;
                }
                fs.rename(childInSrc, childInDest);
                continue;
            }
            if (child.isDirectory()) {
                if (fs.exists(childInDest)) {
                    this.merge(fs, childInSrc, childInDest);
                    continue;
                }
                fs.rename(childInSrc, childInDest);
                continue;
            }
            log.warn("Ignoring archiving of non file/directory: " + child);
        }
    }

    @Override
    public void undo(long tid, Master environment) throws Exception {
    }
}

