/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.master.tableOps.namespace.create;

import org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException;
import org.apache.accumulo.core.security.NamespacePermission;
import org.apache.accumulo.fate.Repo;
import org.apache.accumulo.master.Master;
import org.apache.accumulo.master.tableOps.MasterRepo;
import org.apache.accumulo.master.tableOps.namespace.create.NamespaceInfo;
import org.apache.accumulo.master.tableOps.namespace.create.PopulateZookeeperWithNamespace;
import org.apache.accumulo.server.ServerContext;
import org.apache.accumulo.server.security.AuditedSecurityOperation;
import org.apache.accumulo.server.security.SecurityOperation;
import org.slf4j.LoggerFactory;

class SetupNamespacePermissions
extends MasterRepo {
    private static final long serialVersionUID = 1L;
    private NamespaceInfo namespaceInfo;

    public SetupNamespacePermissions(NamespaceInfo ti) {
        this.namespaceInfo = ti;
    }

    @Override
    public Repo<Master> call(long tid, Master env) throws Exception {
        SecurityOperation security = AuditedSecurityOperation.getInstance((ServerContext)env.getContext());
        for (NamespacePermission permission : NamespacePermission.values()) {
            try {
                security.grantNamespacePermission(env.getContext().rpcCreds(), this.namespaceInfo.user, this.namespaceInfo.namespaceId, permission);
            }
            catch (ThriftSecurityException e) {
                LoggerFactory.getLogger(SetupNamespacePermissions.class).error("{}", (Object)e.getMessage(), (Object)e);
                throw e;
            }
        }
        return new PopulateZookeeperWithNamespace(this.namespaceInfo);
    }
}

