/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.master.tableOps.namespace.delete;

import org.apache.accumulo.core.client.impl.Namespace;
import org.apache.accumulo.core.client.impl.thrift.TableOperation;
import org.apache.accumulo.fate.Repo;
import org.apache.accumulo.master.Master;
import org.apache.accumulo.master.tableOps.MasterRepo;
import org.apache.accumulo.master.tableOps.Utils;
import org.apache.accumulo.master.tableOps.namespace.delete.NamespaceCleanUp;

public class DeleteNamespace
extends MasterRepo {
    private static final long serialVersionUID = 1L;
    private Namespace.ID namespaceId;

    public DeleteNamespace(Namespace.ID namespaceId) {
        this.namespaceId = namespaceId;
    }

    @Override
    public long isReady(long id, Master environment) throws Exception {
        return Utils.reserveNamespace(environment, this.namespaceId, id, true, true, TableOperation.DELETE);
    }

    @Override
    public Repo<Master> call(long tid, Master environment) throws Exception {
        environment.getEventCoordinator().event("deleting namespace %s ", this.namespaceId);
        return new NamespaceCleanUp(this.namespaceId);
    }

    @Override
    public void undo(long id, Master environment) throws Exception {
        Utils.unreserveNamespace(environment, this.namespaceId, id, true);
    }
}

