/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.master.tableOps.rename;

import java.nio.charset.StandardCharsets;
import org.apache.accumulo.core.client.NamespaceNotFoundException;
import org.apache.accumulo.core.client.impl.AcceptableThriftTableOperationException;
import org.apache.accumulo.core.client.impl.ClientContext;
import org.apache.accumulo.core.client.impl.Namespace;
import org.apache.accumulo.core.client.impl.Namespaces;
import org.apache.accumulo.core.client.impl.Table;
import org.apache.accumulo.core.client.impl.Tables;
import org.apache.accumulo.core.client.impl.thrift.TableOperation;
import org.apache.accumulo.core.client.impl.thrift.TableOperationExceptionType;
import org.apache.accumulo.core.util.Pair;
import org.apache.accumulo.fate.Repo;
import org.apache.accumulo.fate.zookeeper.ZooReaderWriter;
import org.apache.accumulo.master.Master;
import org.apache.accumulo.master.tableOps.MasterRepo;
import org.apache.accumulo.master.tableOps.Utils;
import org.slf4j.LoggerFactory;

public class RenameTable
extends MasterRepo {
    private static final long serialVersionUID = 1L;
    private Table.ID tableId;
    private Namespace.ID namespaceId;
    private String oldTableName;
    private String newTableName;

    @Override
    public long isReady(long tid, Master env) throws Exception {
        return Utils.reserveNamespace(env, this.namespaceId, tid, false, true, TableOperation.RENAME) + Utils.reserveTable(env, this.tableId, tid, true, true, TableOperation.RENAME);
    }

    public RenameTable(Namespace.ID namespaceId, Table.ID tableId, String oldTableName, String newTableName) throws NamespaceNotFoundException {
        this.namespaceId = namespaceId;
        this.tableId = tableId;
        this.oldTableName = oldTableName;
        this.newTableName = newTableName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Repo<Master> call(long tid, Master master) throws Exception {
        Pair qualifiedOldTableName = Tables.qualify((String)this.oldTableName);
        Pair qualifiedNewTableName = Tables.qualify((String)this.newTableName);
        if (this.newTableName.contains(".") && !this.namespaceId.equals((Object)Namespaces.getNamespaceId((ClientContext)master.getContext(), (String)((String)qualifiedNewTableName.getFirst())))) {
            throw new AcceptableThriftTableOperationException(this.tableId.canonicalID(), this.oldTableName, TableOperation.RENAME, TableOperationExceptionType.INVALID_NAME, "Namespace in new table name does not match the old table name");
        }
        ZooReaderWriter zoo = master.getContext().getZooReaderWriter();
        Utils.getTableNameLock().lock();
        try {
            Utils.checkTableDoesNotExist(master.getContext(), this.newTableName, this.tableId, TableOperation.RENAME);
            String newName = (String)qualifiedNewTableName.getSecond();
            String oldName = (String)qualifiedOldTableName.getSecond();
            String tap = master.getZooKeeperRoot() + "/tables" + "/" + this.tableId + "/name";
            zoo.mutate(tap, null, null, current -> {
                String currentName = new String(current, StandardCharsets.UTF_8);
                if (currentName.equals(newName)) {
                    return null;
                }
                if (!currentName.equals(oldName)) {
                    throw new AcceptableThriftTableOperationException(null, this.oldTableName, TableOperation.RENAME, TableOperationExceptionType.NOTFOUND, "Name changed while processing");
                }
                return newName.getBytes(StandardCharsets.UTF_8);
            });
            Tables.clearCache((ClientContext)master.getContext());
        }
        finally {
            Utils.getTableNameLock().unlock();
            Utils.unreserveTable(master, this.tableId, tid, true);
            Utils.unreserveNamespace(master, this.namespaceId, tid, false);
        }
        LoggerFactory.getLogger(RenameTable.class).debug("Renamed table {} {} {}", new Object[]{this.tableId, this.oldTableName, this.newTableName});
        return null;
    }

    @Override
    public void undo(long tid, Master env) throws Exception {
        Utils.unreserveTable(env, this.tableId, tid, true);
        Utils.unreserveNamespace(env, this.namespaceId, tid, false);
    }
}

