/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.master.tableOps.tableImport;

import java.io.IOException;
import java.util.Map;
import org.apache.accumulo.core.client.impl.AcceptableThriftTableOperationException;
import org.apache.accumulo.core.client.impl.ClientContext;
import org.apache.accumulo.core.client.impl.Namespace;
import org.apache.accumulo.core.client.impl.Namespaces;
import org.apache.accumulo.core.client.impl.Table;
import org.apache.accumulo.core.client.impl.TableOperationsImpl;
import org.apache.accumulo.core.client.impl.Tables;
import org.apache.accumulo.core.client.impl.thrift.TableOperation;
import org.apache.accumulo.core.client.impl.thrift.TableOperationExceptionType;
import org.apache.accumulo.fate.Repo;
import org.apache.accumulo.fate.zookeeper.ZooUtil;
import org.apache.accumulo.master.Master;
import org.apache.accumulo.master.tableOps.MasterRepo;
import org.apache.accumulo.master.tableOps.Utils;
import org.apache.accumulo.master.tableOps.tableImport.CreateImportDir;
import org.apache.accumulo.master.tableOps.tableImport.ImportedTableInfo;
import org.apache.accumulo.server.ServerContext;
import org.apache.accumulo.server.fs.VolumeManager;
import org.apache.accumulo.server.util.TablePropUtil;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

class ImportPopulateZookeeper
extends MasterRepo {
    private static final long serialVersionUID = 1L;
    private ImportedTableInfo tableInfo;

    ImportPopulateZookeeper(ImportedTableInfo ti) {
        this.tableInfo = ti;
    }

    @Override
    public long isReady(long tid, Master environment) throws Exception {
        return Utils.reserveTable(environment, this.tableInfo.tableId, tid, true, false, TableOperation.IMPORT);
    }

    private Map<String, String> getExportedProps(VolumeManager fs) throws Exception {
        Path path = new Path(this.tableInfo.exportDir, "exportMetadata.zip");
        try {
            FileSystem ns = fs.getVolumeByPath(path).getFileSystem();
            return TableOperationsImpl.getExportedProps((FileSystem)ns, (Path)path);
        }
        catch (IOException ioe) {
            throw new AcceptableThriftTableOperationException(this.tableInfo.tableId.canonicalID(), this.tableInfo.tableName, TableOperation.IMPORT, TableOperationExceptionType.OTHER, "Error reading table props from " + path + " " + ioe.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Repo<Master> call(long tid, Master env) throws Exception {
        Utils.getTableNameLock().lock();
        try {
            Utils.checkTableDoesNotExist(env.getContext(), this.tableInfo.tableName, this.tableInfo.tableId, TableOperation.CREATE);
            String namespace = (String)Tables.qualify((String)this.tableInfo.tableName).getFirst();
            Namespace.ID namespaceId = Namespaces.getNamespaceId((ClientContext)env.getContext(), (String)namespace);
            env.getTableManager().addTable(this.tableInfo.tableId, namespaceId, this.tableInfo.tableName, ZooUtil.NodeExistsPolicy.OVERWRITE);
            Tables.clearCache((ClientContext)env.getContext());
        }
        finally {
            Utils.getTableNameLock().unlock();
        }
        for (Map.Entry<String, String> entry : this.getExportedProps(env.getFileSystem()).entrySet()) {
            if (TablePropUtil.setTableProperty((ServerContext)env.getContext(), (Table.ID)this.tableInfo.tableId, (String)entry.getKey(), (String)entry.getValue())) continue;
            throw new AcceptableThriftTableOperationException(this.tableInfo.tableId.canonicalID(), this.tableInfo.tableName, TableOperation.IMPORT, TableOperationExceptionType.OTHER, "Invalid table property " + entry.getKey());
        }
        return new CreateImportDir(this.tableInfo);
    }

    @Override
    public void undo(long tid, Master env) throws Exception {
        env.getTableManager().removeTable(this.tableInfo.tableId);
        Utils.unreserveTable(env, this.tableInfo.tableId, tid, true);
        Tables.clearCache((ClientContext)env.getContext());
    }
}

