/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.master.tableOps.tableImport;

import org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException;
import org.apache.accumulo.core.security.TablePermission;
import org.apache.accumulo.fate.Repo;
import org.apache.accumulo.master.Master;
import org.apache.accumulo.master.tableOps.MasterRepo;
import org.apache.accumulo.master.tableOps.tableImport.ImportPopulateZookeeper;
import org.apache.accumulo.master.tableOps.tableImport.ImportedTableInfo;
import org.apache.accumulo.server.ServerContext;
import org.apache.accumulo.server.security.AuditedSecurityOperation;
import org.apache.accumulo.server.security.SecurityOperation;
import org.slf4j.LoggerFactory;

class ImportSetupPermissions
extends MasterRepo {
    private static final long serialVersionUID = 1L;
    private ImportedTableInfo tableInfo;

    public ImportSetupPermissions(ImportedTableInfo ti) {
        this.tableInfo = ti;
    }

    @Override
    public long isReady(long tid, Master environment) throws Exception {
        return 0L;
    }

    @Override
    public Repo<Master> call(long tid, Master env) throws Exception {
        SecurityOperation security = AuditedSecurityOperation.getInstance((ServerContext)env.getContext());
        for (TablePermission permission : TablePermission.values()) {
            try {
                security.grantTablePermission(env.getContext().rpcCreds(), this.tableInfo.user, this.tableInfo.tableId, permission, this.tableInfo.namespaceId);
            }
            catch (ThriftSecurityException e) {
                LoggerFactory.getLogger(ImportSetupPermissions.class).error("{}", (Object)e.getMessage(), (Object)e);
                throw e;
            }
        }
        return new ImportPopulateZookeeper(this.tableInfo);
    }

    @Override
    public void undo(long tid, Master env) throws Exception {
        AuditedSecurityOperation.getInstance((ServerContext)env.getContext()).deleteTable(env.getContext().rpcCreds(), this.tableInfo.tableId, this.tableInfo.namespaceId);
    }
}

