/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.master;

import com.google.protobuf.GeneratedMessage;
import com.google.protobuf.InvalidProtocolBufferException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.BatchScanner;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.admin.DelegationTokenConfig;
import org.apache.accumulo.core.clientImpl.AuthenticationTokenIdentifier;
import org.apache.accumulo.core.clientImpl.ClientContext;
import org.apache.accumulo.core.clientImpl.DelegationTokenConfigSerializer;
import org.apache.accumulo.core.clientImpl.Namespace;
import org.apache.accumulo.core.clientImpl.Table;
import org.apache.accumulo.core.clientImpl.Tables;
import org.apache.accumulo.core.clientImpl.thrift.SecurityErrorCode;
import org.apache.accumulo.core.clientImpl.thrift.TableOperation;
import org.apache.accumulo.core.clientImpl.thrift.TableOperationExceptionType;
import org.apache.accumulo.core.clientImpl.thrift.ThriftSecurityException;
import org.apache.accumulo.core.clientImpl.thrift.ThriftTableOperationException;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.dataImpl.KeyExtent;
import org.apache.accumulo.core.dataImpl.thrift.TKeyExtent;
import org.apache.accumulo.core.master.thrift.MasterClientService;
import org.apache.accumulo.core.master.thrift.MasterGoalState;
import org.apache.accumulo.core.master.thrift.MasterMonitorInfo;
import org.apache.accumulo.core.master.thrift.MasterState;
import org.apache.accumulo.core.master.thrift.TabletLoadState;
import org.apache.accumulo.core.master.thrift.TabletSplit;
import org.apache.accumulo.core.metadata.RootTable;
import org.apache.accumulo.core.metadata.schema.MetadataSchema;
import org.apache.accumulo.core.metadata.schema.TabletDeletedException;
import org.apache.accumulo.core.metadata.schema.TabletMetadata;
import org.apache.accumulo.core.metadata.schema.TabletsMetadata;
import org.apache.accumulo.core.protobuf.ProtobufUtil;
import org.apache.accumulo.core.replication.ReplicationSchema;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.securityImpl.thrift.TCredentials;
import org.apache.accumulo.core.securityImpl.thrift.TDelegationToken;
import org.apache.accumulo.core.securityImpl.thrift.TDelegationTokenConfig;
import org.apache.accumulo.core.trace.thrift.TInfo;
import org.apache.accumulo.core.util.ByteBufferUtil;
import org.apache.accumulo.fate.util.UtilWaitThread;
import org.apache.accumulo.fate.zookeeper.IZooReaderWriter;
import org.apache.accumulo.fate.zookeeper.ZooReaderWriter;
import org.apache.accumulo.master.EventCoordinator;
import org.apache.accumulo.master.FateServiceHandler;
import org.apache.accumulo.master.Master;
import org.apache.accumulo.master.tableOps.TraceRepo;
import org.apache.accumulo.master.tserverOps.ShutdownTServer;
import org.apache.accumulo.server.ServerContext;
import org.apache.accumulo.server.client.ClientServiceHandler;
import org.apache.accumulo.server.master.LiveTServerSet;
import org.apache.accumulo.server.master.balancer.DefaultLoadBalancer;
import org.apache.accumulo.server.master.balancer.TabletBalancer;
import org.apache.accumulo.server.master.state.TServerInstance;
import org.apache.accumulo.server.replication.StatusUtil;
import org.apache.accumulo.server.replication.proto.Replication;
import org.apache.accumulo.server.security.delegation.AuthenticationTokenSecretManager;
import org.apache.accumulo.server.util.NamespacePropUtil;
import org.apache.accumulo.server.util.SystemPropUtil;
import org.apache.accumulo.server.util.TablePropUtil;
import org.apache.hadoop.io.BinaryComparable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.token.Token;
import org.apache.thrift.TException;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MasterClientServiceHandler
extends FateServiceHandler
implements MasterClientService.Iface {
    private static final Logger log = Master.log;
    private static final Logger drainLog = LoggerFactory.getLogger((String)"org.apache.accumulo.master.MasterDrainImpl");

    protected MasterClientServiceHandler(Master master) {
        super(master);
    }

    public long initiateFlush(TInfo tinfo, TCredentials c, String tableIdStr) throws ThriftSecurityException, ThriftTableOperationException {
        byte[] fid;
        Table.ID tableId = Table.ID.of((String)tableIdStr);
        Namespace.ID namespaceId = this.getNamespaceIdFromTableId(TableOperation.FLUSH, tableId);
        this.master.security.canFlush(c, tableId, namespaceId);
        String zTablePath = "/accumulo/" + this.master.getInstanceID() + "/tables" + "/" + tableId + "/flush-id";
        ZooReaderWriter zoo = this.master.getContext().getZooReaderWriter();
        try {
            fid = zoo.mutate(zTablePath, null, null, new IZooReaderWriter.Mutator(){

                public byte[] mutate(byte[] currentValue) {
                    long flushID = Long.parseLong(new String(currentValue));
                    return ("" + ++flushID).getBytes();
                }
            });
        }
        catch (KeeperException.NoNodeException nne) {
            throw new ThriftTableOperationException(tableId.canonicalID(), null, TableOperation.FLUSH, TableOperationExceptionType.NOTFOUND, null);
        }
        catch (Exception e) {
            Master.log.warn("{}", (Object)e.getMessage(), (Object)e);
            throw new ThriftTableOperationException(tableId.canonicalID(), null, TableOperation.FLUSH, TableOperationExceptionType.OTHER, null);
        }
        return Long.parseLong(new String(fid));
    }

    public void waitForFlush(TInfo tinfo, TCredentials c, String tableIdStr, ByteBuffer startRowBB, ByteBuffer endRowBB, long flushID, long maxLoops) throws ThriftSecurityException, ThriftTableOperationException {
        Table.ID tableId = Table.ID.of((String)tableIdStr);
        Namespace.ID namespaceId = this.getNamespaceIdFromTableId(TableOperation.FLUSH, tableId);
        this.master.security.canFlush(c, tableId, namespaceId);
        Text startRow = ByteBufferUtil.toText((ByteBuffer)startRowBB);
        Text endRow = ByteBufferUtil.toText((ByteBuffer)endRowBB);
        if (endRow != null && startRow != null && startRow.compareTo((BinaryComparable)endRow) >= 0) {
            throw new ThriftTableOperationException(tableId.canonicalID(), null, TableOperation.FLUSH, TableOperationExceptionType.BAD_RANGE, "start row must be less than end row");
        }
        HashSet<TServerInstance> serversToFlush = new HashSet<TServerInstance>(this.master.tserverSet.getCurrentServers());
        for (long l = 0L; l < maxLoops; ++l) {
            for (TServerInstance instance : serversToFlush) {
                try {
                    LiveTServerSet.TServerConnection server = this.master.tserverSet.getConnection(instance);
                    if (server == null) continue;
                    server.flush(this.master.masterLock, tableId, ByteBufferUtil.toBytes((ByteBuffer)startRowBB), ByteBufferUtil.toBytes((ByteBuffer)endRowBB));
                }
                catch (TException ex) {
                    Master.log.error(ex.toString());
                }
            }
            if (tableId.equals((Object)RootTable.ID) || l == maxLoops - 1L) break;
            UtilWaitThread.sleepUninterruptibly((long)50L, (TimeUnit)TimeUnit.MILLISECONDS);
            serversToFlush.clear();
            try (TabletsMetadata tablets = TabletsMetadata.builder().forTable(tableId).overlapping(startRow, endRow).fetchFlushId().fetchLocation().fetchLogs().fetchPrev().build((AccumuloClient)this.master.getContext());){
                int tabletsToWaitFor = 0;
                int tabletCount = 0;
                for (TabletMetadata tablet : tablets) {
                    int logs = tablet.getLogs().size();
                    if ((tablet.hasCurrent() || logs > 0) && tablet.getFlushId().orElse(-1L) < flushID) {
                        ++tabletsToWaitFor;
                        if (tablet.hasCurrent()) {
                            serversToFlush.add(new TServerInstance(tablet.getLocation()));
                        }
                    }
                    ++tabletCount;
                }
                if (tabletsToWaitFor == 0) break;
                if (tabletCount != 0 || Tables.exists((ClientContext)this.master.getContext(), (Table.ID)tableId)) continue;
                throw new ThriftTableOperationException(tableId.canonicalID(), null, TableOperation.FLUSH, TableOperationExceptionType.NOTFOUND, null);
            }
            catch (TabletDeletedException e) {
                Master.log.debug("Failed to scan {} table to wait for flush {}", new Object[]{"accumulo.metadata", tableId, e});
            }
        }
    }

    private Namespace.ID getNamespaceIdFromTableId(TableOperation tableOp, Table.ID tableId) throws ThriftTableOperationException {
        Namespace.ID namespaceId;
        try {
            namespaceId = Tables.getNamespaceId((ClientContext)this.master.getContext(), (Table.ID)tableId);
        }
        catch (TableNotFoundException e) {
            throw new ThriftTableOperationException(tableId.canonicalID(), null, tableOp, TableOperationExceptionType.NOTFOUND, e.getMessage());
        }
        return namespaceId;
    }

    public MasterMonitorInfo getMasterStats(TInfo info, TCredentials credentials) {
        return this.master.getMasterMonitorInfo();
    }

    public void removeTableProperty(TInfo info, TCredentials credentials, String tableName, String property) throws ThriftSecurityException, ThriftTableOperationException {
        this.alterTableProperty(credentials, tableName, property, null, TableOperation.REMOVE_PROPERTY);
    }

    public void setTableProperty(TInfo info, TCredentials credentials, String tableName, String property, String value) throws ThriftSecurityException, ThriftTableOperationException {
        this.alterTableProperty(credentials, tableName, property, value, TableOperation.SET_PROPERTY);
    }

    public void shutdown(TInfo info, TCredentials c, boolean stopTabletServers) throws ThriftSecurityException {
        this.master.security.canPerformSystemActions(c);
        if (stopTabletServers) {
            this.master.setMasterGoalState(MasterGoalState.CLEAN_STOP);
            EventCoordinator.Listener eventListener = this.master.nextEvent.getListener();
            do {
                eventListener.waitForEvents(1000L);
            } while (this.master.tserverSet.size() > 0);
        }
        this.master.setMasterState(MasterState.STOP);
    }

    public void shutdownTabletServer(TInfo info, TCredentials c, String tabletServer, boolean force) throws ThriftSecurityException {
        LiveTServerSet.TServerConnection server;
        this.master.security.canPerformSystemActions(c);
        TServerInstance doomed = this.master.tserverSet.find(tabletServer);
        if (!force && (server = this.master.tserverSet.getConnection(doomed)) == null) {
            Master.log.warn("No server found for name {}", (Object)tabletServer);
            return;
        }
        long tid = this.master.fate.startTransaction();
        log.debug("Seeding FATE op to shutdown " + tabletServer + " with tid " + tid);
        this.master.fate.seedTransaction(tid, new TraceRepo<Master>(new ShutdownTServer(doomed, force)), false);
        this.master.fate.waitForCompletion(tid);
        this.master.fate.delete(tid);
        log.debug("FATE op shutting down " + tabletServer + " finished");
    }

    public void reportSplitExtent(TInfo info, TCredentials credentials, String serverName, TabletSplit split) {
        KeyExtent oldTablet = new KeyExtent(split.oldTablet);
        if (this.master.migrations.remove(oldTablet) != null) {
            Master.log.info("Canceled migration of {}", (Object)split.oldTablet);
        }
        for (TServerInstance instance : this.master.tserverSet.getCurrentServers()) {
            if (!serverName.equals(instance.hostPort())) continue;
            this.master.nextEvent.event("%s reported split %s, %s", serverName, new KeyExtent((TKeyExtent)split.newTablets.get(0)), new KeyExtent((TKeyExtent)split.newTablets.get(1)));
            return;
        }
        Master.log.warn("Got a split from a server we don't recognize: {}", (Object)serverName);
    }

    public void reportTabletStatus(TInfo info, TCredentials credentials, String serverName, TabletLoadState status, TKeyExtent ttablet) {
        KeyExtent tablet = new KeyExtent(ttablet);
        switch (status) {
            case LOAD_FAILURE: {
                Master.log.error("{} reports assignment failed for tablet {}", (Object)serverName, (Object)tablet);
                break;
            }
            case LOADED: {
                this.master.nextEvent.event("tablet %s was loaded on %s", tablet, serverName);
                break;
            }
            case UNLOADED: {
                this.master.nextEvent.event("tablet %s was unloaded from %s", tablet, serverName);
                break;
            }
            case UNLOAD_ERROR: {
                Master.log.error("{} reports unload failed for tablet {}", (Object)serverName, (Object)tablet);
                break;
            }
            case UNLOAD_FAILURE_NOT_SERVING: {
                if (!Master.log.isTraceEnabled()) break;
                Master.log.trace("{} reports unload failed: not serving tablet, could be a split: {}", (Object)serverName, (Object)tablet);
                break;
            }
            case CHOPPED: {
                this.master.nextEvent.event("tablet %s chopped", tablet);
            }
        }
    }

    public void setMasterGoalState(TInfo info, TCredentials c, MasterGoalState state) throws ThriftSecurityException {
        this.master.security.canPerformSystemActions(c);
        this.master.setMasterGoalState(state);
    }

    public void removeSystemProperty(TInfo info, TCredentials c, String property) throws ThriftSecurityException {
        this.master.security.canPerformSystemActions(c);
        try {
            SystemPropUtil.removeSystemProperty((ServerContext)this.master.getContext(), (String)property);
            this.updatePlugins(property);
        }
        catch (Exception e) {
            Master.log.error("Problem removing config property in zookeeper", (Throwable)e);
            throw new RuntimeException(e.getMessage());
        }
    }

    public void setSystemProperty(TInfo info, TCredentials c, String property, String value) throws ThriftSecurityException, TException {
        this.master.security.canPerformSystemActions(c);
        try {
            SystemPropUtil.setSystemProperty((ServerContext)this.master.getContext(), (String)property, (String)value);
            this.updatePlugins(property);
        }
        catch (IllegalArgumentException iae) {
            throw iae;
        }
        catch (Exception e) {
            Master.log.error("Problem setting config property in zookeeper", (Throwable)e);
            throw new TException(e.getMessage());
        }
    }

    public void setNamespaceProperty(TInfo tinfo, TCredentials credentials, String ns, String property, String value) throws ThriftSecurityException, ThriftTableOperationException {
        this.alterNamespaceProperty(credentials, ns, property, value, TableOperation.SET_PROPERTY);
    }

    public void removeNamespaceProperty(TInfo tinfo, TCredentials credentials, String ns, String property) throws ThriftSecurityException, ThriftTableOperationException {
        this.alterNamespaceProperty(credentials, ns, property, null, TableOperation.REMOVE_PROPERTY);
    }

    private void alterNamespaceProperty(TCredentials c, String namespace, String property, String value, TableOperation op) throws ThriftSecurityException, ThriftTableOperationException {
        Namespace.ID namespaceId = null;
        namespaceId = ClientServiceHandler.checkNamespaceId((ClientContext)this.master.getContext(), (String)namespace, (TableOperation)op);
        if (!this.master.security.canAlterNamespace(c, namespaceId)) {
            throw new ThriftSecurityException(c.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED);
        }
        try {
            if (value == null) {
                NamespacePropUtil.removeNamespaceProperty((ServerContext)this.master.getContext(), (Namespace.ID)namespaceId, (String)property);
            } else {
                NamespacePropUtil.setNamespaceProperty((ServerContext)this.master.getContext(), (Namespace.ID)namespaceId, (String)property, (String)value);
            }
        }
        catch (KeeperException.NoNodeException e) {
            ClientServiceHandler.checkNamespaceId((ClientContext)this.master.getContext(), (String)namespace, (TableOperation)op);
            log.info("Error altering namespace property", (Throwable)e);
            throw new ThriftTableOperationException(namespaceId.canonicalID(), namespace, op, TableOperationExceptionType.OTHER, "Problem altering namespaceproperty");
        }
        catch (Exception e) {
            log.error("Problem altering namespace property", (Throwable)e);
            throw new ThriftTableOperationException(namespaceId.canonicalID(), namespace, op, TableOperationExceptionType.OTHER, "Problem altering namespace property");
        }
    }

    private void alterTableProperty(TCredentials c, String tableName, String property, String value, TableOperation op) throws ThriftSecurityException, ThriftTableOperationException {
        Namespace.ID namespaceId;
        Table.ID tableId = ClientServiceHandler.checkTableId((ClientContext)this.master.getContext(), (String)tableName, (TableOperation)op);
        if (!this.master.security.canAlterTable(c, tableId, namespaceId = this.getNamespaceIdFromTableId(op, tableId))) {
            throw new ThriftSecurityException(c.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED);
        }
        try {
            if (value == null || value.isEmpty()) {
                TablePropUtil.removeTableProperty((ServerContext)this.master.getContext(), (Table.ID)tableId, (String)property);
            } else if (!TablePropUtil.setTableProperty((ServerContext)this.master.getContext(), (Table.ID)tableId, (String)property, (String)value)) {
                throw new Exception("Invalid table property.");
            }
        }
        catch (KeeperException.NoNodeException e) {
            ClientServiceHandler.checkTableId((ClientContext)this.master.getContext(), (String)tableName, (TableOperation)op);
            log.info("Error altering table property", (Throwable)e);
            throw new ThriftTableOperationException(tableId.canonicalID(), tableName, op, TableOperationExceptionType.OTHER, "Problem altering table property");
        }
        catch (Exception e) {
            log.error("Problem altering table property", (Throwable)e);
            throw new ThriftTableOperationException(tableId.canonicalID(), tableName, op, TableOperationExceptionType.OTHER, "Problem altering table property");
        }
    }

    private void updatePlugins(String property) {
        if (property.equals(Property.MASTER_TABLET_BALANCER.getKey())) {
            AccumuloConfiguration conf = this.master.getConfiguration();
            TabletBalancer balancer = (TabletBalancer)Property.createInstanceFromPropertyName((AccumuloConfiguration)conf, (Property)Property.MASTER_TABLET_BALANCER, TabletBalancer.class, (Object)new DefaultLoadBalancer());
            balancer.init(this.master.getContext());
            this.master.tabletBalancer = balancer;
            log.info("tablet balancer changed to {}", (Object)this.master.tabletBalancer.getClass().getName());
        }
    }

    public void waitForBalance(TInfo tinfo) {
        this.master.waitForBalance();
    }

    public List<String> getActiveTservers(TInfo tinfo, TCredentials credentials) {
        Set<TServerInstance> tserverInstances = this.master.onlineTabletServers();
        ArrayList<String> servers = new ArrayList<String>();
        for (TServerInstance tserverInstance : tserverInstances) {
            servers.add(tserverInstance.getLocation().toString());
        }
        return servers;
    }

    public TDelegationToken getDelegationToken(TInfo tinfo, TCredentials credentials, TDelegationTokenConfig tConfig) throws ThriftSecurityException, TException {
        if (!this.master.security.canObtainDelegationToken(credentials)) {
            throw new ThriftSecurityException(credentials.getPrincipal(), SecurityErrorCode.PERMISSION_DENIED);
        }
        if (!this.master.delegationTokensAvailable()) {
            throw new TException("Delegation tokens are not available for use");
        }
        DelegationTokenConfig config = DelegationTokenConfigSerializer.deserialize((TDelegationTokenConfig)tConfig);
        AuthenticationTokenSecretManager secretManager = this.master.getContext().getSecretManager();
        try {
            Map.Entry pair = secretManager.generateToken(credentials.principal, config);
            return new TDelegationToken(ByteBuffer.wrap(((Token)pair.getKey()).getPassword()), ((AuthenticationTokenIdentifier)pair.getValue()).getThriftIdentifier());
        }
        catch (Exception e) {
            throw new TException(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean drainReplicationTable(TInfo tfino, TCredentials credentials, String tableName, Set<String> logsToWatch) throws TException {
        BatchScanner bs;
        ServerContext client = this.master.getContext();
        Text tableId = new Text(this.getTableId((ClientContext)this.master.getContext(), tableName).getUtf8());
        drainLog.trace("Waiting for {} to be replicated for {}", logsToWatch, (Object)tableId);
        drainLog.trace("Reading from metadata table");
        Set<Range> range = Collections.singleton(new Range(MetadataSchema.ReplicationSection.getRange()));
        try {
            bs = client.createBatchScanner("accumulo.metadata", Authorizations.EMPTY, 4);
        }
        catch (TableNotFoundException e) {
            throw new RuntimeException("Could not read metadata table", e);
        }
        bs.setRanges(range);
        bs.fetchColumnFamily(MetadataSchema.ReplicationSection.COLF);
        try {
            if (!this.allReferencesReplicated(bs, tableId, logsToWatch)) {
                boolean e = false;
                return e;
            }
        }
        finally {
            bs.close();
        }
        drainLog.trace("reading from replication table");
        try {
            bs = client.createBatchScanner("accumulo.replication", Authorizations.EMPTY, 4);
        }
        catch (TableNotFoundException e) {
            throw new RuntimeException("Replication table was not found", e);
        }
        bs.setRanges(Collections.singleton(new Range()));
        try {
            boolean bl = this.allReferencesReplicated(bs, tableId, logsToWatch);
            return bl;
        }
        finally {
            bs.close();
        }
    }

    protected Table.ID getTableId(ClientContext context, String tableName) throws ThriftTableOperationException {
        return ClientServiceHandler.checkTableId((ClientContext)context, (String)tableName, null);
    }

    protected boolean allReferencesReplicated(BatchScanner bs, Text tableId, Set<String> relevantLogs) {
        Text rowHolder = new Text();
        Text colfHolder = new Text();
        for (Map.Entry entry : bs) {
            String file;
            drainLog.trace("Got key {}", (Object)((Key)entry.getKey()).toStringNoTruncate());
            ((Key)entry.getKey()).getColumnQualifier(rowHolder);
            if (!tableId.equals((Object)rowHolder)) continue;
            ((Key)entry.getKey()).getRow(rowHolder);
            ((Key)entry.getKey()).getColumnFamily(colfHolder);
            if (colfHolder.equals((Object)MetadataSchema.ReplicationSection.COLF)) {
                file = rowHolder.toString();
                file = file.substring(MetadataSchema.ReplicationSection.getRowPrefix().length());
            } else if (colfHolder.equals((Object)ReplicationSchema.OrderSection.NAME)) {
                file = ReplicationSchema.OrderSection.getFile((Key)((Key)entry.getKey()), (Text)rowHolder);
                long timeClosed = ReplicationSchema.OrderSection.getTimeClosed((Key)((Key)entry.getKey()), (Text)rowHolder);
                drainLog.trace("Order section: {} and {}", (Object)timeClosed, (Object)file);
            } else {
                file = rowHolder.toString();
            }
            if (!relevantLogs.contains(file)) {
                drainLog.trace("Found file that we didn't care about {}", (Object)file);
                continue;
            }
            drainLog.trace("Found file that we *do* care about {}", (Object)file);
            try {
                Replication.Status stat = Replication.Status.parseFrom((byte[])((Value)entry.getValue()).get());
                if (!StatusUtil.isFullyReplicated((Replication.Status)stat)) {
                    drainLog.trace("{} and {} is not replicated", (Object)file, (Object)ProtobufUtil.toString((GeneratedMessage)stat));
                    return false;
                }
                drainLog.trace("{} and {} is replicated", (Object)file, (Object)ProtobufUtil.toString((GeneratedMessage)stat));
            }
            catch (InvalidProtocolBufferException e) {
                drainLog.trace("Could not parse protobuf for {}", entry.getKey(), (Object)e);
            }
        }
        return true;
    }
}

