/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.master.replication;

import com.google.protobuf.GeneratedMessage;
import com.google.protobuf.InvalidProtocolBufferException;
import java.io.IOException;
import java.util.Map;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.BatchWriterConfig;
import org.apache.accumulo.core.client.MutationsRejectedException;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.clientImpl.Table;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.metadata.schema.MetadataSchema;
import org.apache.accumulo.core.protobuf.ProtobufUtil;
import org.apache.accumulo.core.replication.ReplicationSchema;
import org.apache.accumulo.core.replication.ReplicationTable;
import org.apache.accumulo.core.replication.ReplicationTableOfflineException;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.trace.Span;
import org.apache.accumulo.core.trace.Trace;
import org.apache.accumulo.server.fs.VolumeManager;
import org.apache.accumulo.server.replication.proto.Replication;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatusMaker {
    private static final Logger log = LoggerFactory.getLogger(StatusMaker.class);
    private final AccumuloClient client;
    private final VolumeManager fs;
    private BatchWriter replicationWriter;
    private BatchWriter metadataWriter;
    private String sourceTableName = "accumulo.metadata";

    public StatusMaker(AccumuloClient client, VolumeManager fs) {
        this.client = client;
        this.fs = fs;
    }

    public void setSourceTableName(String table) {
        this.sourceTableName = table;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Span span = Trace.start((String)"replicationStatusMaker");
        try {
            Scanner s;
            try {
                s = this.client.createScanner(this.sourceTableName, Authorizations.EMPTY);
            }
            catch (TableNotFoundException e) {
                throw new RuntimeException(e);
            }
            s.fetchColumnFamily(MetadataSchema.ReplicationSection.COLF);
            s.setRange(MetadataSchema.ReplicationSection.getRange());
            Text file = new Text();
            for (Map.Entry entry : s) {
                Replication.Status status;
                if (this.replicationWriter == null) {
                    try {
                        ReplicationTable.setOnline((AccumuloClient)this.client);
                        this.replicationWriter = ReplicationTable.getBatchWriter((AccumuloClient)this.client);
                    }
                    catch (AccumuloException | AccumuloSecurityException | ReplicationTableOfflineException e) {
                        log.warn("Replication table did not come online");
                        this.replicationWriter = null;
                        span.stop();
                        return;
                    }
                }
                MetadataSchema.ReplicationSection.getFile((Key)((Key)entry.getKey()), (Text)file);
                Table.ID tableId = MetadataSchema.ReplicationSection.getTableId((Key)((Key)entry.getKey()));
                try {
                    status = Replication.Status.parseFrom((byte[])((Value)entry.getValue()).get());
                }
                catch (InvalidProtocolBufferException e) {
                    log.warn("Could not deserialize protobuf for {}", (Object)file);
                    continue;
                }
                log.debug("Creating replication status record for {} on table {} with {}.", new Object[]{file, tableId, ProtobufUtil.toString((GeneratedMessage)status)});
                Span workSpan = Trace.start((String)"createStatusMutations");
                try {
                    if (!this.addStatusRecord(file, tableId, (Value)entry.getValue())) {
                        continue;
                    }
                }
                finally {
                    workSpan.stop();
                    continue;
                }
                if (!status.getClosed()) continue;
                Span orderSpan = Trace.start((String)"recordStatusOrder");
                try {
                    if (!this.addOrderRecord(file, tableId, status, (Value)entry.getValue())) {
                        continue;
                    }
                }
                finally {
                    orderSpan.stop();
                    continue;
                }
                Span deleteSpan = Trace.start((String)"deleteClosedStatus");
                try {
                    this.deleteStatusRecord((Key)entry.getKey());
                }
                finally {
                    deleteSpan.stop();
                }
            }
        }
        finally {
            span.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean addStatusRecord(Text file, Table.ID tableId, Value v) {
        try {
            Mutation m = new Mutation(file);
            m.put(ReplicationSchema.StatusSection.NAME, new Text(tableId.getUtf8()), v);
            try {
                this.replicationWriter.addMutation(m);
            }
            catch (MutationsRejectedException e) {
                log.warn("Failed to write work mutations for replication, will retry", (Throwable)e);
                boolean bl = false;
                try {
                    this.replicationWriter.flush();
                }
                catch (MutationsRejectedException e2) {
                    log.warn("Failed to write work mutations for replication, will retry", (Throwable)e2);
                    return false;
                }
                return bl;
            }
        }
        finally {
            try {
                this.replicationWriter.flush();
            }
            catch (MutationsRejectedException e) {
                log.warn("Failed to write work mutations for replication, will retry", (Throwable)e);
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected boolean addOrderRecord(Text file, Table.ID tableId, Replication.Status stat, Value value) {
        block21: {
            try {
                if (!stat.hasCreatedTime()) {
                    try {
                        long createdTime = this.setAndGetCreatedTime(new Path(file.toString()), tableId.toString());
                        stat = Replication.Status.newBuilder((Replication.Status)stat).setCreatedTime(createdTime).build();
                        value = ProtobufUtil.toValue((GeneratedMessage)stat);
                        log.debug("Status was lacking createdTime, set to {} for {}", (Object)createdTime, (Object)file);
                    }
                    catch (IOException e) {
                        log.warn("Failed to get file status, will retry", (Throwable)e);
                        boolean bl = false;
                        try {
                            this.replicationWriter.flush();
                        }
                        catch (MutationsRejectedException e2) {
                            log.warn("Failed to write order mutation for replication, will retry", (Throwable)e2);
                            return false;
                        }
                        return bl;
                    }
                    catch (MutationsRejectedException e) {
                        log.warn("Failed to write status mutation for replication, will retry", (Throwable)e);
                        boolean bl = false;
                        try {
                            this.replicationWriter.flush();
                        }
                        catch (MutationsRejectedException e3) {
                            log.warn("Failed to write order mutation for replication, will retry", (Throwable)e3);
                            return false;
                        }
                        return bl;
                    }
                }
                log.info("Creating order record for {} for {} with {}", new Object[]{file, tableId, ProtobufUtil.toString((GeneratedMessage)stat)});
                Mutation m = ReplicationSchema.OrderSection.createMutation((String)file.toString(), (long)stat.getCreatedTime());
                ReplicationSchema.OrderSection.add((Mutation)m, (Table.ID)tableId, (Value)value);
                try {
                    this.replicationWriter.addMutation(m);
                    break block21;
                }
                catch (MutationsRejectedException e) {
                    log.warn("Failed to write order mutation for replication, will retry", (Throwable)e);
                    boolean bl = false;
                    try {
                        this.replicationWriter.flush();
                    }
                    catch (MutationsRejectedException e4) {
                        log.warn("Failed to write order mutation for replication, will retry", (Throwable)e4);
                        return false;
                    }
                    return bl;
                }
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                try {
                    this.replicationWriter.flush();
                }
                catch (MutationsRejectedException e) {
                    log.warn("Failed to write order mutation for replication, will retry", (Throwable)e);
                    return false;
                }
            }
        }
        return true;
    }

    protected void deleteStatusRecord(Key k) {
        log.debug("Deleting {} from metadata table as it's no longer needed", (Object)k.toStringNoTruncate());
        if (this.metadataWriter == null) {
            try {
                this.metadataWriter = this.client.createBatchWriter(this.sourceTableName, new BatchWriterConfig());
            }
            catch (TableNotFoundException e) {
                throw new RuntimeException("Metadata table doesn't exist");
            }
        }
        try {
            Mutation m = new Mutation(k.getRow());
            m.putDelete(k.getColumnFamily(), k.getColumnQualifier());
            this.metadataWriter.addMutation(m);
            this.metadataWriter.flush();
        }
        catch (MutationsRejectedException e) {
            log.warn("Failed to delete status mutations for metadata table, will retry", (Throwable)e);
        }
    }

    private long setAndGetCreatedTime(Path file, String tableId) throws IOException, MutationsRejectedException {
        long createdTime = this.fs.exists(file) ? this.fs.getFileStatus(file).getModificationTime() : System.currentTimeMillis();
        Replication.Status status = Replication.Status.newBuilder().setCreatedTime(createdTime).build();
        Mutation m = new Mutation(new Text(MetadataSchema.ReplicationSection.getRowPrefix() + file));
        m.put(MetadataSchema.ReplicationSection.COLF, new Text(tableId), ProtobufUtil.toValue((GeneratedMessage)status));
        this.replicationWriter.addMutation(m);
        this.replicationWriter.flush();
        return createdTime;
    }
}

