/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.master.tableOps.bulkVer1;

import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.clientImpl.AbstractId;
import org.apache.accumulo.core.clientImpl.Table;
import org.apache.accumulo.core.master.thrift.BulkImportState;
import org.apache.accumulo.fate.Repo;
import org.apache.accumulo.master.Master;
import org.apache.accumulo.master.tableOps.MasterRepo;
import org.apache.accumulo.master.tableOps.Utils;
import org.apache.accumulo.server.ServerContext;
import org.apache.accumulo.server.util.MetadataTableUtil;
import org.apache.accumulo.server.zookeeper.TransactionWatcher;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CleanUpBulkImport
extends MasterRepo {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(CleanUpBulkImport.class);
    private Table.ID tableId;
    private String source;
    private String bulk;
    private String error;

    CleanUpBulkImport(Table.ID tableId, String source, String bulk, String error) {
        this.tableId = tableId;
        this.source = source;
        this.bulk = bulk;
        this.error = error;
    }

    @Override
    public Repo<Master> call(long tid, Master master) throws Exception {
        master.updateBulkImportStatus(this.source, BulkImportState.CLEANUP);
        log.debug("removing the bulkDir processing flag file in " + this.bulk);
        Path bulkDir = new Path(this.bulk);
        MetadataTableUtil.removeBulkLoadInProgressFlag((ServerContext)master.getContext(), (String)("/" + bulkDir.getParent().getName() + "/" + bulkDir.getName()));
        MetadataTableUtil.addDeleteEntry((ServerContext)master.getContext(), (Table.ID)this.tableId, (String)bulkDir.toString());
        log.debug("removing the metadata table markers for loaded files");
        ServerContext client = master.getContext();
        MetadataTableUtil.removeBulkLoadEntries((AccumuloClient)client, (Table.ID)this.tableId, (long)tid);
        log.debug("releasing HDFS reservations for " + this.source + " and " + this.error);
        Utils.unreserveHdfsDirectory(master, this.source, tid);
        Utils.unreserveHdfsDirectory(master, this.error, tid);
        Utils.getReadLock(master, (AbstractId)this.tableId, tid).unlock();
        log.debug("completing bulkDir import transaction " + tid);
        TransactionWatcher.ZooArbitrator.cleanup((ServerContext)master.getContext(), (String)"bulkTx", (long)tid);
        master.removeBulkImportStatus(this.source);
        return null;
    }
}

