/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.master.tableOps.clone;

import java.util.Map;
import java.util.Set;
import org.apache.accumulo.core.clientImpl.Namespace;
import org.apache.accumulo.core.clientImpl.Table;
import org.apache.accumulo.core.clientImpl.thrift.TableOperation;
import org.apache.accumulo.fate.Repo;
import org.apache.accumulo.master.Master;
import org.apache.accumulo.master.tableOps.MasterRepo;
import org.apache.accumulo.master.tableOps.Utils;
import org.apache.accumulo.master.tableOps.clone.CloneInfo;
import org.apache.accumulo.master.tableOps.clone.ClonePermissions;

public class CloneTable
extends MasterRepo {
    private static final long serialVersionUID = 1L;
    private CloneInfo cloneInfo = new CloneInfo();

    public CloneTable(String user, Namespace.ID namespaceId, Table.ID srcTableId, String tableName, Map<String, String> propertiesToSet, Set<String> propertiesToExclude) {
        this.cloneInfo.user = user;
        this.cloneInfo.srcTableId = srcTableId;
        this.cloneInfo.tableName = tableName;
        this.cloneInfo.propertiesToExclude = propertiesToExclude;
        this.cloneInfo.propertiesToSet = propertiesToSet;
        this.cloneInfo.srcNamespaceId = namespaceId;
    }

    @Override
    public long isReady(long tid, Master environment) throws Exception {
        long val = Utils.reserveNamespace(environment, this.cloneInfo.srcNamespaceId, tid, false, true, TableOperation.CLONE);
        return val += Utils.reserveTable(environment, this.cloneInfo.srcTableId, tid, false, true, TableOperation.CLONE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Repo<Master> call(long tid, Master environment) throws Exception {
        Utils.getIdLock().lock();
        try {
            this.cloneInfo.tableId = Utils.getNextId(this.cloneInfo.tableName, environment.getContext(), Table.ID::of);
            ClonePermissions clonePermissions = new ClonePermissions(this.cloneInfo);
            return clonePermissions;
        }
        finally {
            Utils.getIdLock().unlock();
        }
    }

    @Override
    public void undo(long tid, Master environment) {
        Utils.unreserveNamespace(environment, this.cloneInfo.srcNamespaceId, tid, false);
        Utils.unreserveTable(environment, this.cloneInfo.srcTableId, tid, false);
    }
}

