/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.master.tableOps.compact;

import java.util.Collections;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.clientImpl.AbstractId;
import org.apache.accumulo.core.clientImpl.AcceptableThriftTableOperationException;
import org.apache.accumulo.core.clientImpl.ClientContext;
import org.apache.accumulo.core.clientImpl.Namespace;
import org.apache.accumulo.core.clientImpl.Table;
import org.apache.accumulo.core.clientImpl.Tables;
import org.apache.accumulo.core.clientImpl.thrift.TableOperation;
import org.apache.accumulo.core.clientImpl.thrift.TableOperationExceptionType;
import org.apache.accumulo.core.master.state.tables.TableState;
import org.apache.accumulo.core.metadata.RootTable;
import org.apache.accumulo.core.metadata.schema.TabletMetadata;
import org.apache.accumulo.core.metadata.schema.TabletsMetadata;
import org.apache.accumulo.core.util.MapCounter;
import org.apache.accumulo.fate.Repo;
import org.apache.accumulo.fate.zookeeper.ZooReaderWriter;
import org.apache.accumulo.master.Master;
import org.apache.accumulo.master.tableOps.MasterRepo;
import org.apache.accumulo.master.tableOps.Utils;
import org.apache.accumulo.master.tableOps.compact.CompactRange;
import org.apache.accumulo.server.master.LiveTServerSet;
import org.apache.accumulo.server.master.state.TServerInstance;
import org.apache.thrift.TException;
import org.slf4j.LoggerFactory;

class CompactionDriver
extends MasterRepo {
    private static final long serialVersionUID = 1L;
    private long compactId;
    private final Table.ID tableId;
    private final Namespace.ID namespaceId;
    private byte[] startRow;
    private byte[] endRow;

    public CompactionDriver(long compactId, Namespace.ID namespaceId, Table.ID tableId, byte[] startRow, byte[] endRow) {
        this.compactId = compactId;
        this.tableId = tableId;
        this.namespaceId = namespaceId;
        this.startRow = startRow;
        this.endRow = endRow;
    }

    @Override
    public long isReady(long tid, Master master) throws Exception {
        if (this.tableId.equals((Object)RootTable.ID)) {
            return 0L;
        }
        String zCancelID = "/accumulo/" + master.getInstanceID() + "/tables" + "/" + this.tableId + "/compact-cancel-id";
        ZooReaderWriter zoo = master.getContext().getZooReaderWriter();
        if (Long.parseLong(new String(zoo.getData(zCancelID, null))) >= this.compactId) {
            throw new AcceptableThriftTableOperationException(this.tableId.canonicalID(), null, TableOperation.COMPACT, TableOperationExceptionType.OTHER, "Compaction canceled");
        }
        MapCounter serversToFlush = new MapCounter();
        long t1 = System.currentTimeMillis();
        int tabletsToWaitFor = 0;
        int tabletCount = 0;
        TabletsMetadata tablets = TabletsMetadata.builder().forTable(this.tableId).overlapping(this.startRow, this.endRow).fetchLocation().fetchPrev().fetchCompactId().build((AccumuloClient)master.getContext());
        for (TabletMetadata tablet : tablets) {
            if (tablet.getCompactId().orElse(-1L) < this.compactId) {
                ++tabletsToWaitFor;
                if (tablet.hasCurrent()) {
                    serversToFlush.increment((Object)new TServerInstance(tablet.getLocation()), 1L);
                }
            }
            ++tabletCount;
        }
        long scanTime = System.currentTimeMillis() - t1;
        Tables.clearCache((ClientContext)master.getContext());
        if (tabletCount == 0 && !Tables.exists((ClientContext)master.getContext(), (Table.ID)this.tableId)) {
            throw new AcceptableThriftTableOperationException(this.tableId.canonicalID(), null, TableOperation.COMPACT, TableOperationExceptionType.NOTFOUND, null);
        }
        if (serversToFlush.size() == 0 && Tables.getTableState((ClientContext)master.getContext(), (Table.ID)this.tableId) == TableState.OFFLINE) {
            throw new AcceptableThriftTableOperationException(this.tableId.canonicalID(), null, TableOperation.COMPACT, TableOperationExceptionType.OFFLINE, null);
        }
        if (tabletsToWaitFor == 0) {
            return 0L;
        }
        for (TServerInstance tsi : serversToFlush.keySet()) {
            try {
                LiveTServerSet.TServerConnection server = master.getConnection(tsi);
                if (server == null) continue;
                server.compact(master.getMasterLock(), this.tableId.canonicalID(), this.startRow, this.endRow);
            }
            catch (TException ex) {
                LoggerFactory.getLogger(CompactionDriver.class).error(ex.toString());
            }
        }
        long sleepTime = 500L;
        if (serversToFlush.size() > 0) {
            sleepTime = (Long)Collections.max(serversToFlush.values()) * sleepTime;
        }
        sleepTime = Math.max(2L * scanTime, sleepTime);
        sleepTime = Math.min(sleepTime, 30000L);
        return sleepTime;
    }

    @Override
    public Repo<Master> call(long tid, Master env) throws Exception {
        CompactRange.removeIterators(env, tid, this.tableId);
        Utils.getReadLock(env, (AbstractId)this.tableId, tid).unlock();
        Utils.getReadLock(env, (AbstractId)this.namespaceId, tid).unlock();
        return null;
    }

    @Override
    public void undo(long tid, Master environment) {
    }
}

