/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.master.tableOps.create;

import java.io.IOException;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.fate.Repo;
import org.apache.accumulo.master.Master;
import org.apache.accumulo.master.tableOps.MasterRepo;
import org.apache.accumulo.master.tableOps.TableInfo;
import org.apache.accumulo.master.tableOps.Utils;
import org.apache.accumulo.master.tableOps.create.CreateDir;
import org.apache.accumulo.server.ServerConstants;
import org.apache.accumulo.server.fs.VolumeChooserEnvironment;
import org.apache.accumulo.server.fs.VolumeManager;
import org.apache.accumulo.server.tablets.UniqueNameAllocator;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;

class ChooseDir
extends MasterRepo {
    private static final long serialVersionUID = 1L;
    private final TableInfo tableInfo;

    ChooseDir(TableInfo ti) {
        this.tableInfo = ti;
    }

    @Override
    public long isReady(long tid, Master environment) {
        return 0L;
    }

    @Override
    public Repo<Master> call(long tid, Master master) throws Exception {
        VolumeChooserEnvironment chooserEnv = new VolumeChooserEnvironment(this.tableInfo.getTableId(), master.getContext());
        String baseDir = master.getFileSystem().choose(chooserEnv, ServerConstants.getBaseUris((AccumuloConfiguration)master.getConfiguration())) + "/tables" + "/" + this.tableInfo.getTableId();
        this.tableInfo.defaultTabletDir = baseDir + "/default_tablet";
        if (this.tableInfo.getInitialSplitSize() > 0) {
            this.createTableDirectoriesInfo(master, baseDir);
        }
        return new CreateDir(this.tableInfo);
    }

    @Override
    public void undo(long tid, Master master) throws Exception {
        VolumeManager fs = master.getFileSystem();
        fs.deleteRecursively(new Path(this.tableInfo.getSplitDirsFile()));
    }

    private void createTableDirectoriesInfo(Master master, String baseDir) throws IOException {
        SortedSet<Text> splits = Utils.getSortedSetFromFile(master.getInputStream(this.tableInfo.getSplitFile()), true);
        SortedSet<Text> tabletDirectoryInfo = this.createTabletDirectoriesSet(master, splits.size(), baseDir);
        this.writeTabletDirectoriesToFileSystem(master, tabletDirectoryInfo);
    }

    private SortedSet<Text> createTabletDirectoriesSet(Master master, int num, String baseDir) {
        UniqueNameAllocator namer = master.getContext().getUniqueNameAllocator();
        TreeSet<Text> splitDirs = new TreeSet<Text>();
        for (int i = 0; i < num; ++i) {
            String tabletDir = "/t-" + namer.getNextName();
            splitDirs.add(new Text(baseDir + "/" + new Path(tabletDir).getName()));
        }
        return splitDirs;
    }

    private void writeTabletDirectoriesToFileSystem(Master master, SortedSet<Text> dirs) throws IOException {
        FileSystem fs = master.getFileSystem().getDefaultVolume().getFileSystem();
        if (fs.exists(new Path(this.tableInfo.getSplitDirsFile()))) {
            fs.delete(new Path(this.tableInfo.getSplitDirsFile()), true);
        }
        try (FSDataOutputStream stream = master.getOutputStream(this.tableInfo.getSplitDirsFile());){
            for (Text dir : dirs) {
                stream.writeBytes(dir + "\n");
            }
        }
    }
}

