/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.master.tableOps.create;

import java.io.IOException;
import org.apache.accumulo.core.client.admin.InitialTableState;
import org.apache.accumulo.core.master.state.tables.TableState;
import org.apache.accumulo.core.volume.Volume;
import org.apache.accumulo.fate.Repo;
import org.apache.accumulo.master.Master;
import org.apache.accumulo.master.tableOps.MasterRepo;
import org.apache.accumulo.master.tableOps.TableInfo;
import org.apache.accumulo.master.tableOps.Utils;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

class FinishCreateTable
extends MasterRepo {
    private static final long serialVersionUID = 1L;
    private final TableInfo tableInfo;

    public FinishCreateTable(TableInfo ti) {
        this.tableInfo = ti;
    }

    @Override
    public long isReady(long tid, Master environment) {
        return 0L;
    }

    @Override
    public Repo<Master> call(long tid, Master env) throws Exception {
        if (this.tableInfo.getInitialTableState() == InitialTableState.OFFLINE) {
            env.getContext().getTableManager().transitionTableState(this.tableInfo.getTableId(), TableState.OFFLINE);
        } else {
            env.getContext().getTableManager().transitionTableState(this.tableInfo.getTableId(), TableState.ONLINE);
        }
        Utils.unreserveNamespace(env, this.tableInfo.getNamespaceId(), tid, false);
        Utils.unreserveTable(env, this.tableInfo.getTableId(), tid, true);
        env.getEventCoordinator().event("Created table %s ", this.tableInfo.getTableName());
        if (this.tableInfo.getInitialSplitSize() > 0) {
            this.cleanupSplitFiles(env);
        }
        return null;
    }

    private void cleanupSplitFiles(Master env) throws IOException {
        Volume defaultVolume = env.getFileSystem().getDefaultVolume();
        FileSystem fs = defaultVolume.getFileSystem();
        fs.delete(new Path(this.tableInfo.getSplitFile()), true);
        fs.delete(new Path(this.tableInfo.getSplitDirsFile()), true);
    }

    @Override
    public String getReturn() {
        return this.tableInfo.getTableId().canonicalID();
    }

    @Override
    public void undo(long tid, Master env) {
    }
}

