/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.master.tableOps.create;

import java.util.Map;
import org.apache.accumulo.core.clientImpl.ClientContext;
import org.apache.accumulo.core.clientImpl.Table;
import org.apache.accumulo.core.clientImpl.Tables;
import org.apache.accumulo.core.clientImpl.thrift.TableOperation;
import org.apache.accumulo.fate.Repo;
import org.apache.accumulo.fate.zookeeper.ZooUtil;
import org.apache.accumulo.master.Master;
import org.apache.accumulo.master.tableOps.MasterRepo;
import org.apache.accumulo.master.tableOps.TableInfo;
import org.apache.accumulo.master.tableOps.Utils;
import org.apache.accumulo.master.tableOps.create.ChooseDir;
import org.apache.accumulo.server.ServerContext;
import org.apache.accumulo.server.util.TablePropUtil;

class PopulateZookeeper
extends MasterRepo {
    private static final long serialVersionUID = 1L;
    private TableInfo tableInfo;

    PopulateZookeeper(TableInfo ti) {
        this.tableInfo = ti;
    }

    @Override
    public long isReady(long tid, Master environment) throws Exception {
        return Utils.reserveTable(environment, this.tableInfo.getTableId(), tid, true, false, TableOperation.CREATE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Repo<Master> call(long tid, Master master) throws Exception {
        Utils.getTableNameLock().lock();
        try {
            Utils.checkTableDoesNotExist(master.getContext(), this.tableInfo.getTableName(), this.tableInfo.getTableId(), TableOperation.CREATE);
            master.getTableManager().addTable(this.tableInfo.getTableId(), this.tableInfo.getNamespaceId(), this.tableInfo.getTableName(), ZooUtil.NodeExistsPolicy.OVERWRITE);
            for (Map.Entry<String, String> entry : this.tableInfo.props.entrySet()) {
                TablePropUtil.setTableProperty((ServerContext)master.getContext(), (Table.ID)this.tableInfo.getTableId(), (String)entry.getKey(), (String)entry.getValue());
            }
            Tables.clearCache((ClientContext)master.getContext());
            ChooseDir chooseDir = new ChooseDir(this.tableInfo);
            return chooseDir;
        }
        finally {
            Utils.getTableNameLock().unlock();
        }
    }

    @Override
    public void undo(long tid, Master master) throws Exception {
        master.getTableManager().removeTable(this.tableInfo.getTableId());
        Utils.unreserveTable(master, this.tableInfo.getTableId(), tid, true);
        Tables.clearCache((ClientContext)master.getContext());
    }
}

