/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.master.tableOps.namespace.create;

import java.util.Map;
import org.apache.accumulo.core.clientImpl.Namespace;
import org.apache.accumulo.fate.Repo;
import org.apache.accumulo.master.Master;
import org.apache.accumulo.master.tableOps.MasterRepo;
import org.apache.accumulo.master.tableOps.Utils;
import org.apache.accumulo.master.tableOps.namespace.create.NamespaceInfo;
import org.apache.accumulo.master.tableOps.namespace.create.SetupNamespacePermissions;

public class CreateNamespace
extends MasterRepo {
    private static final long serialVersionUID = 1L;
    private NamespaceInfo namespaceInfo = new NamespaceInfo();

    public CreateNamespace(String user, String namespaceName, Map<String, String> props) {
        this.namespaceInfo.namespaceName = namespaceName;
        this.namespaceInfo.user = user;
        this.namespaceInfo.props = props;
    }

    @Override
    public long isReady(long tid, Master environment) {
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Repo<Master> call(long tid, Master master) throws Exception {
        Utils.getIdLock().lock();
        try {
            this.namespaceInfo.namespaceId = Utils.getNextId(this.namespaceInfo.namespaceName, master.getContext(), Namespace.ID::of);
            SetupNamespacePermissions setupNamespacePermissions = new SetupNamespacePermissions(this.namespaceInfo);
            return setupNamespacePermissions;
        }
        finally {
            Utils.getIdLock().unlock();
        }
    }

    @Override
    public void undo(long tid, Master env) {
    }
}

